/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ChangeFieldName {
    private ChangeFieldName() {
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final JavaType.Class classType;
        private final String hasName;
        private final String toName;

        public Scoped(JavaType.Class classType, String hasName, String toName) {
            this.classType = classType;
            this.hasName = hasName;
            this.toName = toName;
            this.setCursoringOn();
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String[])new String[]{"class.type", this.classType.getFullyQualifiedName(), "has.name", this.hasName, "to.name", this.toName});
        }

        @Override
        public J visitVariable(J.VariableDecls.NamedVar variable) {
            J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.refactor(variable, x$0 -> super.visitVariable((J.VariableDecls.NamedVar)x$0));
            if (variable.isField(this.getCursor()) && this.matchesClass(this.enclosingClass().getType()) && variable.getSimpleName().equals(this.hasName)) {
                v = v.withName(v.getName().withName(this.toName));
            }
            return v;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess) {
            J.FieldAccess f = (J.FieldAccess)this.refactor(fieldAccess, x$0 -> super.visitFieldAccess((J.FieldAccess)x$0));
            if (this.matchesClass(fieldAccess.getTarget().getType()) && fieldAccess.getSimpleName().equals(this.hasName)) {
                f = f.withName(f.getName().withName(this.toName));
            }
            return f;
        }

        @Override
        public J visitIdentifier(J.Ident ident) {
            J.Ident i = (J.Ident)this.refactor(ident, x$0 -> super.visitIdentifier((J.Ident)x$0));
            if (ident.getSimpleName().equals(this.hasName) && this.isFieldReference(ident)) {
                i = i.withName(this.toName);
            }
            return i;
        }

        private boolean matchesClass(@Nullable JavaType test) {
            JavaType.Class testClassType = TypeUtils.asClass(test);
            return testClassType != null && testClassType.getFullyQualifiedName().equals(this.classType.getFullyQualifiedName());
        }

        private boolean isFieldReference(J.Ident ident) {
            Cursor nearest = (Cursor)new FindVariableDefinition(ident, this.getCursor()).visit(this.enclosingCompilationUnit());
            return nearest != null && nearest.getParentOrThrow().getParentOrThrow().getParentOrThrow().getTree() instanceof J.ClassDecl;
        }

        private static class FindVariableDefinition
        extends JavaSourceVisitor<Cursor> {
            private final J.Ident ident;
            private final Cursor referenceScope;

            public FindVariableDefinition(J.Ident ident, Cursor referenceScope) {
                this.ident = ident;
                this.referenceScope = referenceScope;
                this.setCursoringOn();
            }

            public Cursor defaultTo(Tree t) {
                return null;
            }

            @Override
            public Cursor visitVariable(J.VariableDecls.NamedVar variable) {
                return variable.getSimpleName().equalsIgnoreCase(this.ident.getSimpleName()) && this.isInSameNameScope(this.referenceScope) ? this.getCursor() : (Cursor)super.visitVariable(variable);
            }

            public Cursor reduce(Cursor r1, Cursor r2) {
                if (r1 == null) {
                    return r2;
                }
                if (r2 == null) {
                    return r1;
                }
                return r1.getPathAsStream().count() > r2.getPathAsStream().count() ? r1 : r2;
            }
        }
    }
}

