/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.tree.J;

public class FindReferencesToVariable
extends JavaSourceVisitor<List<Tree>> {
    private final J.Ident variable;

    public FindReferencesToVariable(J.Ident variable) {
        this.variable = variable;
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String)"variable", (String)this.variable.getSimpleName());
    }

    public List<Tree> defaultTo(Tree t) {
        return Collections.emptyList();
    }

    @Override
    public List<Tree> visitAssign(J.Assign assign) {
        return this.hasReference(assign.getVariable()) ? Collections.singletonList(assign) : (List)super.visitAssign(assign);
    }

    @Override
    public List<Tree> visitAssignOp(J.AssignOp assignOp) {
        return this.hasReference(assignOp.getVariable()) ? Collections.singletonList(assignOp) : (List)super.visitAssignOp(assignOp);
    }

    @Override
    public List<Tree> visitUnary(J.Unary unary) {
        return this.hasReference(unary.getExpr()) ? Collections.singletonList(unary) : (List)super.visitUnary(unary);
    }

    private boolean hasReference(Tree t) {
        return (Boolean)new HasReferenceToVariableInSubtree().visit(t);
    }

    private class HasReferenceToVariableInSubtree
    extends JavaSourceVisitor<Boolean> {
        private HasReferenceToVariableInSubtree() {
        }

        public Boolean defaultTo(Tree t) {
            return false;
        }

        @Override
        public Boolean visitIdentifier(J.Ident ident) {
            return ident.getIdent() == FindReferencesToVariable.this.variable.getIdent() || (Boolean)super.visitIdentifier(ident) != false;
        }
    }
}

