/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.LinkedHashSet;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeMethodTargetToVariable
extends JavaRefactorVisitor {
    private final J.MethodInvocation scope;
    private final String varName;
    @Nullable
    private final JavaType.Class type;

    public ChangeMethodTargetToVariable(J.MethodInvocation scope, J.VariableDecls.NamedVar namedVar) {
        this(scope, namedVar.getSimpleName(), TypeUtils.asClass(namedVar.getType()));
    }

    public ChangeMethodTargetToVariable(J.MethodInvocation scope, String varName, @Nullable JavaType.Class type) {
        super("java.ChangeMethodTargetToVariable", "to", varName);
        this.scope = scope;
        this.varName = varName;
        this.type = type;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.scope.isScope(method)) {
            Expression select = method.getSelect();
            JavaType.Method methodType = null;
            if (method.getType() != null) {
                this.maybeRemoveImport(method.getType().getDeclaringType());
                LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getType().getFlags());
                flags.remove((Object)Flag.Static);
                methodType = method.getType().withDeclaringType(this.type).withFlags(flags);
            }
            return method.withSelect(J.Ident.build(Tree.randomId(), this.varName, this.type, select == null ? Formatting.EMPTY : select.getFormatting())).withType(methodType);
        }
        return super.visitMethodInvocation(method);
    }
}

