/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.search.FindType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;

public class AddImport
extends JavaRefactorVisitor {
    OrderImports orderImports = new IntellijOrderImports();
    private final String clazz;
    @Nullable
    private final String staticMethod;
    private final boolean onlyIfReferenced;
    private final JavaType.Class classType;
    private boolean coveredByExistingImport;

    public AddImport(String clazz, @Nullable String staticMethod, boolean onlyIfReferenced) {
        super("java.AddImport", "class", clazz, "static.method", staticMethod == null ? "none" : staticMethod);
        this.clazz = clazz;
        this.staticMethod = staticMethod;
        this.onlyIfReferenced = onlyIfReferenced;
        this.classType = JavaType.Class.build(clazz);
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        boolean hasReferences;
        this.coveredByExistingImport = false;
        boolean bl = hasReferences = !((Set)new FindType(this.clazz).visit(cu)).isEmpty();
        if (this.onlyIfReferenced && !hasReferences) {
            return cu;
        }
        cu = (J.CompilationUnit)this.refactor(cu, x$0 -> super.visitCompilationUnit((J.CompilationUnit)x$0));
        if (this.coveredByExistingImport) {
            return cu;
        }
        if (this.classType.getPackageName().isEmpty()) {
            return cu;
        }
        if ((cu = cu.withImports(this.orderImports.addImport(cu))).getClasses().size() > 0 && cu.getImports().isEmpty() || cu.getClasses().get(0).getFormatting().getPrefix().chars().takeWhile(c -> c == 10 || c == 13).count() < 2L) {
            ArrayList<J.ClassDecl> classes = new ArrayList<J.ClassDecl>(cu.getClasses());
            classes.set(0, (J.ClassDecl)((J.ClassDecl)classes.get(0)).withPrefix("\n\n"));
            cu = cu.withClasses(classes);
        }
        return cu;
    }

    @Override
    public J visitImport(J.Import impoort) {
        String importedType = impoort.getQualid().getSimpleName();
        if (this.staticMethod != null) {
            if (impoort.isFromType(this.clazz) && impoort.isStatic() && (importedType.equals(this.staticMethod) || importedType.equals("*"))) {
                this.coveredByExistingImport = true;
            }
        } else if (impoort.isFromType(this.clazz)) {
            this.coveredByExistingImport = true;
        } else if (importedType.equals("*") && impoort.getQualid().getTarget().printTrimmed().equals(this.classType.getPackageName())) {
            this.coveredByExistingImport = true;
        }
        return super.visitImport(impoort);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$clazz = this.clazz;
        String other$clazz = other.clazz;
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        String this$staticMethod = this.staticMethod;
        String other$staticMethod = other.staticMethod;
        if (this$staticMethod == null ? other$staticMethod != null : !this$staticMethod.equals(other$staticMethod)) {
            return false;
        }
        return this.onlyIfReferenced == other.onlyIfReferenced;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clazz = this.clazz;
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        String $staticMethod = this.staticMethod;
        result = result * 59 + ($staticMethod == null ? 43 : $staticMethod.hashCode());
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        return result;
    }

    public class IntellijOrderImports
    extends OrderImports {
        private final int classCountToUseStarImport;
        private final int namesCountToUseStarImport;

        public IntellijOrderImports() {
            this(5, 3);
        }

        @Override
        public List<J.Import> addImport(J.CompilationUnit cu) {
            List<J.Import> importsThatCouldBeStarReplaced = this.importsThatCouldBeStarReplaced(cu);
            boolean starImporting = importsThatCouldBeStarReplaced.size() > (AddImport.this.staticMethod == null ? this.classCountToUseStarImport : this.namesCountToUseStarImport);
            ArrayList<J.Import> importsWithAdded = new ArrayList<J.Import>(cu.getImports());
            if (starImporting) {
                importsWithAdded.removeAll(importsThatCouldBeStarReplaced);
            }
            J.FieldAccess classImportField = (J.FieldAccess)TreeBuilder.buildName(AddImport.this.clazz, Formatting.format((String)" "));
            if (AddImport.this.staticMethod == null) {
                J.Import importStatementToAdd = new J.Import(Tree.randomId(), starImporting ? (J.FieldAccess)TreeBuilder.buildName(AddImport.this.classType.getPackageName() + ".*", Formatting.format((String)" ")) : classImportField, false, Formatting.format((String)"\n"));
                boolean added = false;
                for (int i = 0; i < importsWithAdded.size(); ++i) {
                    J.Import anImport = (J.Import)importsWithAdded.get(i);
                    if (!anImport.isStatic() && importStatementToAdd.compareTo(anImport) >= 0) continue;
                    importsWithAdded.add(i, importStatementToAdd);
                    added = true;
                    break;
                }
                if (!added) {
                    importsWithAdded.add(importStatementToAdd);
                }
                boolean encounteredJavaImport = false;
                for (int i = 0; i < importsWithAdded.size(); ++i) {
                    J.Import anImport = (J.Import)importsWithAdded.get(i);
                    if (i == 0) {
                        encounteredJavaImport = anImport.getPackageName().startsWith("java");
                        if (cu.getPackageDecl() == null) continue;
                    }
                    if (i == 0 || !encounteredJavaImport && (encounteredJavaImport = anImport.getPackageName().startsWith("java")) || anImport.isStatic()) {
                        importsWithAdded.set(i, (J.Import)anImport.withPrefix("\n\n"));
                        if (!anImport.isStatic()) continue;
                        break;
                    }
                    importsWithAdded.set(i, (J.Import)anImport.withPrefix("\n"));
                }
            } else {
                J.Import importStatementToAdd = new J.Import(Tree.randomId(), new J.FieldAccess(Tree.randomId(), classImportField, J.Ident.build(Tree.randomId(), starImporting ? "*" : AddImport.this.staticMethod, null, Formatting.EMPTY), null, Formatting.EMPTY), true, Formatting.format((String)"\n"));
                boolean added = false;
                for (int i = 0; i < importsWithAdded.size(); ++i) {
                    J.Import anImport = (J.Import)importsWithAdded.get(i);
                    if (!anImport.isStatic() || importStatementToAdd.compareTo(anImport) >= 0) continue;
                    importsWithAdded.add(i, importStatementToAdd);
                    added = true;
                    break;
                }
                if (!added) {
                    importsWithAdded.add(importStatementToAdd);
                }
                boolean encounteredStatic = false;
                for (int i = 0; i < importsWithAdded.size(); ++i) {
                    J.Import anImport = (J.Import)importsWithAdded.get(i);
                    if (!encounteredStatic && (encounteredStatic = anImport.isStatic())) {
                        importsWithAdded.set(i, (J.Import)anImport.withPrefix("\n\n"));
                        continue;
                    }
                    if (!anImport.isStatic()) continue;
                    importsWithAdded.set(i, (J.Import)anImport.withPrefix("\n"));
                }
            }
            return importsWithAdded;
        }

        public IntellijOrderImports(int classCountToUseStarImport, int namesCountToUseStarImport) {
            this.classCountToUseStarImport = classCountToUseStarImport;
            this.namesCountToUseStarImport = namesCountToUseStarImport;
        }
    }

    public abstract class OrderImports {
        public abstract List<J.Import> addImport(J.CompilationUnit var1);

        protected List<J.Import> importsThatCouldBeStarReplaced(J.CompilationUnit cu) {
            return AddImport.this.staticMethod == null ? cu.getImports().stream().filter(i -> !i.isStatic() && i.getPackageName().equals(AddImport.this.classType.getPackageName())).collect(Collectors.toList()) : cu.getImports().stream().filter(i -> {
                String fqn = i.getQualid().getTarget().printTrimmed();
                return i.isStatic() && fqn.substring(0, Math.max(0, fqn.lastIndexOf(46))).equals(AddImport.this.clazz);
            }).collect(Collectors.toList());
        }
    }
}

