/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.LinkedHashSet;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class ChangeMethodTargetToStatic
extends ScopedJavaRefactorVisitor {
    private final String clazz;

    public ChangeMethodTargetToStatic(J.MethodInvocation scope, String clazz) {
        super(scope.getId());
        this.clazz = clazz;
    }

    public String getName() {
        return "core.ChangeMethodTargetToStatic{to=" + this.clazz + "}";
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.isScope()) {
            JavaType.Class classType = JavaType.Class.build(this.clazz);
            J.MethodInvocation m = method.withSelect(J.Ident.build(Tree.randomId(), classType.getClassName(), classType, method.getSelect() == null ? Formatting.EMPTY : method.getSelect().getFormatting()));
            this.maybeAddImport(this.clazz);
            JavaType.Method transformedType = null;
            if (method.getType() != null) {
                this.maybeRemoveImport(method.getType().getDeclaringType());
                transformedType = method.getType().withDeclaringType(classType);
                if (!method.getType().hasFlags(Flag.Static)) {
                    LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getType().getFlags());
                    flags.add(Flag.Static);
                    transformedType = transformedType.withFlags(flags);
                }
            }
            return m.withType(transformedType);
        }
        return super.visitMethodInvocation(method);
    }
}

