/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class CommentTest
implements RewriteTest {
    CommentTest() {
    }

    @Test
    void backToBackMultilineComments() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    /*\n        Comment 1\n    *//*\n        Comment 2\n    */\n}\n")});
    }

    @Test
    void multilineNestedInsideSingleLine() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {// /*\n}\n")});
    }

    @Test
    void trailingComment() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"abstract class Test {\n  void alert(String msg) /*-{ $wnd.alert(msg); }-*/;\n}\n")});
    }

    @Test
    void commentAsLastLine() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n}\n//\n")});
    }

    @Test
    void multiLineCommentWithUrl() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"package hello;\npublic class Test {\n  public static void test() {\n    /*addItem(\"Site A\", \"https://hello.com/A\");*/\n  }\n}\n")});
    }
}

