/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.openrewrite.DocumentExample;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class ArrayTypeTest
implements RewriteTest {
    ArrayTypeTest() {
    }

    @DocumentExample
    @Test
    void javaTypesFromJsonCreatorConstructor() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaVisitor<ExecutionContext>(this){

            public TypeTree visitArrayType(J.ArrayType arrayType, ExecutionContext ctx) {
                if (!arrayType.getMarkers().findFirst(SearchResult.class).isPresent()) {
                    ArrayList<JRightPadded> dimensions = new ArrayList<JRightPadded>();
                    assert (arrayType.getDimension() != null);
                    dimensions.add(0, JRightPadded.build((Object)arrayType.getDimension().getBefore()).withAfter((Space)arrayType.getDimension().getElement()));
                    TypeTree elementType = arrayType.getElementType();
                    while (elementType instanceof J.ArrayType) {
                        J.ArrayType elementArrayType = (J.ArrayType)elementType;
                        assert (elementArrayType.getDimension() != null);
                        dimensions.add(0, JRightPadded.build((Object)elementArrayType.getDimension().getBefore()).withAfter((Space)elementArrayType.getDimension().getElement()));
                        elementType = elementArrayType.getElementType();
                    }
                    return J.ArrayType.create((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY.addIfAbsent((Marker)new SearchResult(Tree.randomId(), "arr")), (TypeTree)elementType, dimensions, null, null, null);
                }
                return arrayType;
            }
        })), new SourceSpecs[]{Assertions.java((String)"class Test {\n    Integer[ ] n1 = new Integer[0];\n    Integer[] [ ] n2 = new Integer[0][0];\n    Integer[][] [  ] n3 = new Integer[0][0][0];\n}\n", (String)"class Test {\n    /*~~(arr)~~>*/Integer[ ] n1 = new Integer[0];\n    /*~~(arr)~~>*/Integer[] [ ] n2 = new Integer[0][0];\n    /*~~(arr)~~>*/Integer[][] [  ] n3 = new Integer[0][0][0];\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Integer>(this){

            public J.ArrayType visitArrayType(J.ArrayType arrayType, Integer p) {
                org.assertj.core.api.Assertions.assertThat((Object)arrayType.getType()).isNotNull();
                org.assertj.core.api.Assertions.assertThat((Object)arrayType.getType()).isInstanceOf(JavaType.Array.class);
                org.assertj.core.api.Assertions.assertThat((Object)arrayType.getElementType().getType()).isEqualTo((Object)((JavaType.Array)arrayType.getType()).getElemType());
                return super.visitArrayType(arrayType, (Object)p);
            }
        }.visit((Tree)cu, (Object)0)))});
    }

    @ParameterizedTest
    @ValueSource(strings={"String [] [ ] s;", "String [] [ ] method() {\n    return null;\n}\n"})
    void arrayType(String input) {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)String.format("class Test {\n  %s\n}\n", input), spec -> spec.afterRecipe(cu -> {
            final AtomicBoolean firstDimension = new AtomicBoolean(false);
            final AtomicBoolean secondDimension = new AtomicBoolean(false);
            new JavaIsoVisitor<Object>(this){

                public J.ArrayType visitArrayType(J.ArrayType arrayType, Object o) {
                    if (arrayType.getElementType() instanceof J.ArrayType) {
                        org.assertj.core.api.Assertions.assertThat((String)arrayType.toString()).isEqualTo("String [] [ ]");
                        secondDimension.set(true);
                    } else {
                        org.assertj.core.api.Assertions.assertThat((String)arrayType.toString()).isEqualTo("String [ ]");
                        firstDimension.set(true);
                    }
                    return super.visitArrayType(arrayType, o);
                }
            }.visit((Tree)cu, (Object)0);
            org.assertj.core.api.Assertions.assertThat((boolean)firstDimension.get()).isTrue();
            org.assertj.core.api.Assertions.assertThat((boolean)secondDimension.get()).isTrue();
        }))});
    }

    @Test
    void arrayTypeWithoutDimensions() {
        J.Identifier elementType = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "String", (JavaType)JavaType.ShallowClass.build((String)"java.lang.String"), null);
        J.ArrayType migratedArrayType = J.ArrayType.create((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (TypeTree)elementType, Collections.emptyList(), null, null, null);
        org.assertj.core.api.Assertions.assertThat((String)migratedArrayType.toString()).isEqualTo("String");
    }

    @Disabled(value="Fails print idempotency test")
    @Test
    void annotatedVarargsParameter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void m1(String @Deprecated... s) {}\n}\n")});
    }

    @Disabled(value="Fails print idempotency test")
    @Test
    void annotatedCStyleArrayParameter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void m2(String  s @Deprecated[]) {}\n}\n")});
    }
}

