/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MinimumJava21;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class AnnotationTest
implements RewriteTest {
    AnnotationTest() {
    }

    @Test
    void annotationWithDefaultArgument() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@SuppressWarnings(\"ALL\")\npublic class A {}\n", spec -> spec.afterRecipe(cu -> {
            J.ClassDeclaration c = (J.ClassDeclaration)cu.getClasses().get(0);
            JavaType.Class type = (JavaType.Class)c.getType();
            JavaType.Annotation a = (JavaType.Annotation)type.getAnnotations().get(0);
            org.assertj.core.api.Assertions.assertThat((List)a.getValues()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((Object)((JavaType.Annotation.ElementValue)a.getValues().get(0)).getValue()).isEqualTo(Collections.singletonList("ALL"));
        }))});
    }

    @Test
    void annotationWithArgument() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@SuppressWarnings(value = \"ALL\")\npublic class A {}\n")});
    }

    @Test
    void preserveOptionalEmptyParentheses() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@Deprecated ( )\npublic class A {}\n")});
    }

    @Test
    void newArrayArgument() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target({ FIELD, PARAMETER })\npublic @interface Annotation {}\n")});
    }

    @Test
    void newArrayArgumentTrailingComma() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n\n@Target({ FIELD, PARAMETER , })\npublic @interface Annotation {}\n")});
    }

    @Test
    void annotationsInManyLocations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.*;\n@Ho\npublic @Ho final @Ho class Test {\n    @Ho private @Ho transient @Ho String s;\n    @Ho\n    public @Ho final @Ho <T> @Ho T merryChristmas() {\n        return null;\n    }\n    @Ho\n    public @Ho Test() {\n    }\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface Hos {\n    Ho[] value();\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@Repeatable(Hos.class)\n@interface Ho {\n}\n")});
    }

    @Test
    void multipleAnnotations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.*;\n@B\n@C\npublic class A {\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface B {\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface C {\n}\n")});
    }

    @Test
    void typeParameterAnnotations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\nimport java.lang.annotation.*;\nclass TypeAnnotationTest {\n    List<@A ? extends @A String> list;\n\n    @Target({ ElementType.FIELD, ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n    private @interface A {\n    }\n}\n")});
    }

    @Test
    void annotationsWithComments() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.*;\n@Yo\n// doc\n@Ho\npublic @Yo /* grumpy */ @Ho final @Yo\n// happy\n@Ho class Test {\n    @Yo /* sleepy */ @Ho private @Yo /* bashful */ @Ho transient @Yo /* sneezy */ @Ho String s;\n    @Yo /* dopey */ @Ho\n    public @Yo /* evil queen */ @Ho final @Yo /* mirror */ @Ho <T> @Yo /* apple */ @Ho T itsOffToWorkWeGo() {\n        return null;\n    }\n    @Yo /* snow white */ @Ho\n    public @Yo /* prince */ @Ho Test() {\n    }\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface Hos {\n    Ho[] value();\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@Repeatable(Hos.class)\n@interface Ho {\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@interface Yos {\n    Yo[] value();\n}\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n@Repeatable(Yos.class)\n@interface Yo {\n}\n")});
    }

    @Test
    void annotationOnConstructorName() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(this){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext p) {
                if ("A".equals(annotation.getSimpleName())) {
                    return null;
                }
                return super.visitAnnotation(annotation, (Object)p);
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.*;\npublic class TypeAnnotationTest {\n\n    public @Deprecated @A TypeAnnotationTest() {\n    }\n\n    @Target({ ElementType.TYPE, ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n    private @interface A {\n    }\n}\n", (String)"import java.lang.annotation.*;\npublic class TypeAnnotationTest {\n\n    public @Deprecated TypeAnnotationTest() {\n    }\n\n    @Target({ ElementType.TYPE, ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n    private @interface A {\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Object o) {
                AnnotationService service = (AnnotationService)this.service(AnnotationService.class);
                org.assertj.core.api.Assertions.assertThat((List)service.getAllAnnotations(this.getCursor())).hasSize(1);
                org.assertj.core.api.Assertions.assertThat((String)((J.Annotation)service.getAllAnnotations(this.getCursor()).get(0)).getSimpleName()).isEqualTo("Deprecated");
                return method;
            }
        }.visit((Tree)cu, (Object)0)))});
    }

    @Test
    void annotationAfterVariableTypePackageName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\nimport java.util.List;\n\nimport static java.lang.annotation.ElementType.*;\n\npublic class A {\n  @Leading java. util. @Multi1 @Multi2 List<String> l;\n  @Leading java. util. @Multi1 @Multi2 List<String> m() { return null; }\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target(value={FIELD, METHOD})\npublic @interface Leading {}\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target(value=TYPE_USE)\npublic @interface Multi1 {}\n\n@Retention(RetentionPolicy.RUNTIME)\n@Target(value=TYPE_USE)\npublic @interface Multi2 {}\n", spec -> spec.afterRecipe(cu -> {
            AnnotationService service = (AnnotationService)cu.service(AnnotationService.class);
            J.VariableDeclarations field = (J.VariableDeclarations)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            org.assertj.core.api.Assertions.assertThat((List)service.getAllAnnotations(new Cursor(null, (Object)field))).satisfiesExactly(new ThrowingConsumer[]{leading -> org.assertj.core.api.Assertions.assertThat((String)leading.getSimpleName()).isEqualTo("Leading")});
            J.ParameterizedType fieldType = (J.ParameterizedType)field.getTypeExpression();
            org.assertj.core.api.Assertions.assertThat((Object)fieldType).isNotNull();
            J.AnnotatedType annotatedType = (J.AnnotatedType)fieldType.getClazz();
            org.assertj.core.api.Assertions.assertThat((List)service.getAllAnnotations(new Cursor(null, (Object)annotatedType))).satisfiesExactly(new ThrowingConsumer[]{multi1 -> org.assertj.core.api.Assertions.assertThat((String)multi1.getSimpleName()).isEqualTo("Multi1"), multi2 -> org.assertj.core.api.Assertions.assertThat((String)multi2.getSimpleName()).isEqualTo("Multi2")});
            J.MethodDeclaration method = (J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(1);
            org.assertj.core.api.Assertions.assertThat((List)service.getAllAnnotations(new Cursor(null, (Object)method))).satisfiesExactly(new ThrowingConsumer[]{leading -> org.assertj.core.api.Assertions.assertThat((String)leading.getSimpleName()).isEqualTo("Leading")});
            J.ParameterizedType returnType = (J.ParameterizedType)method.getReturnTypeExpression();
            org.assertj.core.api.Assertions.assertThat((Object)returnType).isNotNull();
            annotatedType = (J.AnnotatedType)returnType.getClazz();
            org.assertj.core.api.Assertions.assertThat((List)service.getAllAnnotations(new Cursor(null, (Object)annotatedType))).satisfiesExactly(new ThrowingConsumer[]{multi1 -> org.assertj.core.api.Assertions.assertThat((String)multi1.getSimpleName()).isEqualTo("Multi1"), multi2 -> org.assertj.core.api.Assertions.assertThat((String)multi2.getSimpleName()).isEqualTo("Multi2")});
        }))});
    }

    @Test
    void annotatedArrayType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\nclass TypeAnnotationTest {\n    Integer @A1 [] @A2 [ ] integers;\n\n    @Target(ElementType.TYPE_USE)\n    private @interface A1 {\n    }\n\n    @Target(ElementType.TYPE_USE)\n    private @interface A2 {\n    }\n}\n", spec -> spec.afterRecipe(cu -> {
            final AtomicBoolean firstDimension = new AtomicBoolean(false);
            final AtomicBoolean secondDimension = new AtomicBoolean(false);
            new JavaIsoVisitor<Object>(this){

                public J.ArrayType visitArrayType(J.ArrayType arrayType, Object o) {
                    if (arrayType.getElementType() instanceof J.ArrayType) {
                        if (arrayType.getAnnotations() != null && !arrayType.getAnnotations().isEmpty()) {
                            org.assertj.core.api.Assertions.assertThat((String)((J.Annotation)arrayType.getAnnotations().get(0)).getAnnotationType().toString()).isEqualTo("A1");
                            org.assertj.core.api.Assertions.assertThat((String)arrayType.toString()).isEqualTo("Integer @A1 [] @A2 [ ]");
                            firstDimension.set(true);
                        }
                    } else if (arrayType.getAnnotations() != null && !arrayType.getAnnotations().isEmpty()) {
                        org.assertj.core.api.Assertions.assertThat((String)((J.Annotation)arrayType.getAnnotations().get(0)).getAnnotationType().toString()).isEqualTo("A2");
                        org.assertj.core.api.Assertions.assertThat((String)arrayType.toString()).isEqualTo("Integer @A2 [ ]");
                        secondDimension.set(true);
                    }
                    return super.visitArrayType(arrayType, o);
                }
            }.visit((Tree)cu, (Object)0);
            org.assertj.core.api.Assertions.assertThat((boolean)firstDimension.get()).isTrue();
            org.assertj.core.api.Assertions.assertThat((boolean)secondDimension.get()).isTrue();
        }))});
    }

    @Test
    void annotationOnSecondDimension() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\nclass TypeAnnotationTest {\n    Integer [] @A1 [ ] integers;\n\n    @Target(ElementType.TYPE_USE)\n    private @interface A1 {\n    }\n}\n", spec -> spec.afterRecipe(cu -> {
            final AtomicBoolean firstDimension = new AtomicBoolean(false);
            final AtomicBoolean secondDimension = new AtomicBoolean(false);
            new JavaIsoVisitor<Object>(this){

                public J.ArrayType visitArrayType(J.ArrayType arrayType, Object o) {
                    if (arrayType.getElementType() instanceof J.ArrayType) {
                        org.assertj.core.api.Assertions.assertThat((String)arrayType.toString()).isEqualTo("Integer [] @A1 [ ]");
                        firstDimension.set(true);
                    } else {
                        org.assertj.core.api.Assertions.assertThat((String)arrayType.toString()).isEqualTo("Integer @A1 [ ]");
                        secondDimension.set(true);
                    }
                    return super.visitArrayType(arrayType, o);
                }
            }.visit((Tree)cu, (Object)0);
            org.assertj.core.api.Assertions.assertThat((boolean)firstDimension.get()).isTrue();
            org.assertj.core.api.Assertions.assertThat((boolean)secondDimension.get()).isTrue();
        }))});
    }

    @Test
    void recursiveElementValue() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE)\n@A\nprivate @interface A {\n    A[] value() default @A;\n}\n\n@A({@A, @A(@A)})\nclass TypeAnnotationTest {\n}\n", spec -> spec.afterRecipe(cu -> {
            J.ClassDeclaration c = (J.ClassDeclaration)cu.getClasses().get(1);
            JavaType.Class type = (JavaType.Class)c.getType();
            JavaType.Annotation a = (JavaType.Annotation)type.getAnnotations().get(0);
            org.assertj.core.api.Assertions.assertThat((List)a.getValues()).satisfiesExactly(new ThrowingConsumer[]{v -> {
                org.assertj.core.api.Assertions.assertThat((Object)v.getElement()).isIn((Iterable)a.getMethods());
                org.assertj.core.api.Assertions.assertThat((List)((JavaType.Annotation.ArrayElementValue)v).getValues()).satisfiesExactly(new ThrowingConsumer[]{a1 -> {
                    org.assertj.core.api.Assertions.assertThat((Object)a1.getType()).isSameAs((Object)a.getType());
                    org.assertj.core.api.Assertions.assertThat((List)a1.getValues()).isEmpty();
                }, a2 -> {
                    org.assertj.core.api.Assertions.assertThat((Object)a2.getType()).isSameAs((Object)a.getType());
                    org.assertj.core.api.Assertions.assertThat((List)a2.getValues()).hasSize(1);
                }});
            }});
        }))});
    }

    @MinimumJava21
    @Test
    void annotationElementValues() {
        JavaParser p = JavaParser.fromJavaVersion().build();
        List sourceFiles = p.parse(new String[]{"package a.b;\n\npublic class Dummy {\n    @Deprecated(since = \"1.2\", forRemoval = true)\n    static void deprecatedWithParams() {\n    }\n\n    @Deprecated\n    static void deprecatedWithoutParams() {\n    }\n}\n", "import a.b.Dummy;\n\nclass Test {\n  public void test() {\n    Dummy.deprecatedWithParams();\n    Dummy.deprecatedWithoutParams();\n  }\n}\n"}).toList();
        J.CompilationUnit cu = (J.CompilationUnit)sourceFiles.get(1);
        J.MethodDeclaration md = (J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
        J.MethodInvocation mi = (J.MethodInvocation)md.getBody().getStatements().get(0);
        JavaType.Annotation annotation = (JavaType.Annotation)mi.getMethodType().getAnnotations().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java.lang.Deprecated", (Object)annotation.getType().getFullyQualifiedName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"since", (Object)((JavaType.Method)((JavaType.Annotation.ElementValue)annotation.getValues().get(0)).getElement()).getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.2", (Object)((JavaType.Annotation.ElementValue)annotation.getValues().get(0)).getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"forRemoval", (Object)((JavaType.Method)((JavaType.Annotation.ElementValue)annotation.getValues().get(1)).getElement()).getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.TRUE, (Object)((JavaType.Annotation.ElementValue)annotation.getValues().get(1)).getValue());
        mi = (J.MethodInvocation)md.getBody().getStatements().get(1);
        annotation = (JavaType.Annotation)mi.getMethodType().getAnnotations().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"java.lang.Deprecated", (Object)annotation.getType().getFullyQualifiedName());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)annotation.getValues().isEmpty());
    }

    @Test
    void arrayTypeAnnotationElementValues() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Annotation(type = int[].class)\nclass Test {\n}\n\n@Target(ElementType.TYPE)\n@interface Annotation {\n    Class<?> type();\n}\n", spec -> spec.afterRecipe(cu -> {
            J.ClassDeclaration c = (J.ClassDeclaration)cu.getClasses().get(0);
            JavaType.Class type = (JavaType.Class)c.getType();
            JavaType.Annotation a = (JavaType.Annotation)type.getAnnotations().get(0);
            org.assertj.core.api.Assertions.assertThat((List)a.getValues()).hasSize(1);
            JavaType.Annotation.SingleElementValue v = (JavaType.Annotation.SingleElementValue)a.getValues().get(0);
            org.assertj.core.api.Assertions.assertThat((Object)v.getElement()).isSameAs(a.getMethods().get(0));
            org.assertj.core.api.Assertions.assertThat((Object)v.getValue()).isInstanceOf(JavaType.Array.class);
            JavaType.Array array = (JavaType.Array)v.getValue();
            org.assertj.core.api.Assertions.assertThat((Object)array.getElemType()).isInstanceOf(JavaType.Primitive.class);
            org.assertj.core.api.Assertions.assertThat((String)((JavaType.Primitive)array.getElemType()).getKeyword()).isEqualTo("int");
        }))});
    }

    @Test
    void modifierNoSpaceThenAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public@jdk.jfr.Name(\"A\") void test() {\n    }\n}\n")});
    }

    @Test
    void modifierWithMultipleSpaceThenAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public   @jdk.jfr.Name(\"A\") void test() {\n    }\n}\n")});
    }

    @Test
    void modifierWithMultipleSpaceThenAnnotationScenario2() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public    @jdk.jfr.Name(\"A\") static   @jdk.jfr.Label(\"2nd\") void test() {\n    }\n}\n")});
    }

    @Test
    void modifierNoSpaceThenAnnotationScenario2() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public@jdk.jfr.Name(\"A\") static@jdk.jfr.Label(\"2nd\") void test() {\n    }\n}\n")});
    }

    @Test
    void modifierNoSpaceThenAnnotationScenario3() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public@jdk.jfr.Name(\"A\")   static  @jdk.jfr.Label(\"2nd\") void test() {\n    }\n}\n")});
    }

    @Test
    void modifierNoSpaceThenMultipleAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public@jdk.jfr.Name(\"A\")@jdk.jfr.Label(\"test\") void test() {\n    }\n}\n")});
    }

    @Test
    void multipleModifiersNoSpaceThenAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public static@jdk.jfr.Name(\"A\") void test() {\n    }\n}\n")});
    }

    @Test
    void modifierWithSpaceThenAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public static @jdk.jfr.Name(\"A\") void test() {\n    }\n}\n")});
    }

    @Test
    void arraysWithAnnotations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\nclass A {\n   @Target({ ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n   private static @interface C {\n   }\n   @Target({ ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n   private static @interface B {\n   }\n\n   Comparable<@C Object @C []> specialArray1;\n   Comparable<@C Object @B []> specialArray2;\n}\n")});
    }
}

