/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MinimumJava21;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class ConstructorTest
implements RewriteTest {
    ConstructorTest() {
    }

    @Test
    void noConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {}\n")});
    }

    @Test
    void defaultConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n}\n")});
    }

    @Test
    void multipleConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n    public A(String a) {}\n}\n")});
    }

    @Test
    void thisCallingConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n    public A(String a) {\n        this();\n    }\n}\n")});
    }

    @Test
    void superCallingConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n    public A(String a) {\n        super();\n    }\n}\n")});
    }

    @MinimumJava21
    @Test
    void validationBeforeThisConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n    public A(String a) {\n        if (a.equals(\"foo\")) {\n            throw new RuntimeException();\n        }\n        this();\n    }\n}\n")});
    }

    @MinimumJava21
    @Test
    void validationBeforeSuperConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A(String a) {\n        if (a.equals(\"foo\")) {\n            throw new RuntimeException();\n        }\n        super();\n    }\n}\n")});
    }

    @MinimumJava21
    @Test
    void assignmentBeforeThisConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    String stringA;\n    public A() {}\n    public A(String a) {\n        stringA = a;\n        this();\n    }\n}\n")});
    }

    @MinimumJava21
    @Test
    void assignmentBeforeSuperConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    String stringA;\n    public A(String a) {\n        stringA = a;\n        super();\n    }\n}\n")});
    }
}

