/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MinimumJava11;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class NewClassTest
implements RewriteTest {
    NewClassTest() {
    }

    @Test
    void anonymousInnerClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A { static class B {} }\nclass C {\n    A.B anonB = new A.B() {};\n}\n")});
    }

    @Test
    void concreteInnerClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A { static class B {} }\nclass C {\n    A.B anonB = new A.B();\n}\n")});
    }

    @Test
    void concreteClassWithParams() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n    Object l = new ArrayList < String > ( 0 ) { };\n}\n")});
    }

    @Test
    void rawType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n    List<String> l = new ArrayList < > ();\n}\n")});
    }

    @Test
    void delegate() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    private String name;\n    A() {\n      this(\"ABC\");\n    }\n    A(String name) {\n      this.name = name;\n    }\n}\n")});
    }

    @Test
    void parameterizedTypeAttribution() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n    List<String> l = new ArrayList<>();\n}\n", spec -> spec.afterRecipe(cu -> {
            J.VariableDeclarations.NamedVariable l = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0)).getVariables().get(0);
            J.NewClass arrayList = (J.NewClass)l.getInitializer();
            JavaType.Parameterized javaType = (JavaType.Parameterized)arrayList.getType();
            org.assertj.core.api.Assertions.assertThat((String)javaType.getType().getFullyQualifiedName()).isEqualTo("java.util.ArrayList");
            org.assertj.core.api.Assertions.assertThat((List)javaType.getTypeParameters()).satisfiesExactly(new ThrowingConsumer[]{p -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)p).getFullyQualifiedName()).isEqualTo("java.lang.String")});
        }))});
    }

    @Test
    @MinimumJava11
    void anonymousTypeAttribution() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n    List<String> l = new ArrayList<>() {};\n}\n", spec -> spec.afterRecipe(cu -> {
            J.VariableDeclarations.NamedVariable l = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0)).getVariables().get(0);
            J.NewClass arrayList = (J.NewClass)l.getInitializer();
            JavaType.Class javaType = (JavaType.Class)arrayList.getType();
            JavaType.Parameterized arrayListType = (JavaType.Parameterized)javaType.getSupertype();
            org.assertj.core.api.Assertions.assertThat((String)arrayListType.getType().getFullyQualifiedName()).isEqualTo("java.util.ArrayList");
            org.assertj.core.api.Assertions.assertThat((List)arrayListType.getTypeParameters()).satisfiesExactly(new ThrowingConsumer[]{p -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)p).getFullyQualifiedName()).isEqualTo("java.lang.String")});
        }))});
    }

    @Test
    void anonymousClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.ArrayList;\nimport java.util.List;\n\nclass Test {\n    List<Integer> l = new ArrayList<Integer>() {\n        /* Javadoc */\n        @Override\n        public boolean isEmpty() {\n            return false;\n        }\n    };\n}\n")});
    }

    @Test
    void anonymousClassWithMultipleVariableDeclarations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.File;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Comparator;\n\nclass Test {\n    void method() {\n        Arrays.sort(new ArrayList[]{new ArrayList<File>()}, new Comparator<Object>() {\n            long time1, time2;\n\n            @Override\n            public int compare(Object o1, Object o2) {\n                time1 = ((File) o1).lastModified();\n                time2 = ((File) o2).lastModified();\n                return time1 > time2 ? 1 : 0;\n            }\n        });\n    }\n}\n")});
    }

    @Test
    void unnecessarySemicolonInBody1() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    Object o = new Object() {;;;;;\n        @Override\n        public String toString() {\n            return super.toString();\n        }\n    };\n}\n")});
    }

    @Test
    void unnecessarySemicolonInBody1WithComment() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    Object o = new Object() {    /*~~>*/    ; /*<~~*/\n        @Override\n        public String toString() {\n            return super.toString();\n        }\n    };\n}\n")});
    }

    @Test
    void unnecessarySemicolonInBody2() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class B {\n    Object o = new Object() {\n        @Override\n        public String toString() {\n            return super.toString();\n        };;;;\n    };\n}\n")});
    }

    @Test
    void unnecessarySemicolonInBody2WithComment() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class B {\n    Object o = new Object() {\n        @Override\n        public String toString() {\n            return super.toString();\n        }     /*~~>*/    ; /*<~~*/\n    };\n}\n")});
    }
}

