/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AutoCloseableSoftAssertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.StringAssert;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

class TypeUtilsAssertions
extends AutoCloseableSoftAssertions {
    Map<String, List<JavaType>> types = new HashMap<String, List<JavaType>>();

    public TypeUtilsAssertions(J.CompilationUnit cu) {
        EnumSet.complementOf(EnumSet.of(JavaType.Primitive.String, JavaType.Primitive.None)).forEach(e -> this.types.put(e.getKeyword(), new ArrayList<JavaType.Primitive>(Collections.singletonList(e))));
        new JavaIsoVisitor<Integer>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, Integer o) {
                if (multiVariable.getTypeExpression() != null) {
                    String type = multiVariable.getTypeExpression().printTrimmed(this.getCursor());
                    TypeUtilsAssertions.this.types.computeIfAbsent(type, k -> new ArrayList(2)).add(Objects.requireNonNull(multiVariable.getTypeExpression().getType()));
                }
                for (J.VariableDeclarations.NamedVariable variable : multiVariable.getVariables()) {
                    TypeUtilsAssertions.this.types.computeIfAbsent(variable.getSimpleName(), k -> new ArrayList(2)).add((JavaType)Objects.requireNonNull(variable.getVariableType()));
                }
                return super.visitVariableDeclarations(multiVariable, (Object)o);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer o) {
                String type = method.printTrimmed(this.getCursor());
                TypeUtilsAssertions.this.types.computeIfAbsent(type, k -> new ArrayList(2)).add((JavaType)Objects.requireNonNull(method.getMethodType()));
                return super.visitMethodInvocation(method, (Object)o);
            }
        }.visit((Tree)cu, (Object)0);
    }

    public ObjectAssert<JavaType> type(String type) {
        JavaType javaType = this.getFirst(type);
        return this.assertThat(javaType);
    }

    public BooleanAssert isAssignableTo(String to, String from) {
        return this.isAssignableTo(to, from, false);
    }

    public BooleanAssert isAssignableTo(String to, String from, boolean capture) {
        JavaType toType = this.getFirst(to);
        JavaType fromType = this.getLast(from);
        return (BooleanAssert)this.assertThat(TypeUtils.isAssignableTo((JavaType)toType, (JavaType)fromType)).describedAs("isAssignableTo(%s, %s, %s)", new Object[]{to, from, capture});
    }

    public BooleanAssert isOfType(String to, String from) {
        return this.isOfType(to, from, false);
    }

    public BooleanAssert isOfType(String to, String from, boolean capture) {
        JavaType toType = this.getFirst(to);
        JavaType fromType = this.getLast(from);
        return (BooleanAssert)this.assertThat(TypeUtils.isOfType((JavaType)toType, (JavaType)fromType)).describedAs("isOfType(%s, %s, %s)", new Object[]{to, from, capture});
    }

    public StringAssert toString(String type) {
        JavaType javaType = this.getFirst(type);
        return (StringAssert)this.assertThat(TypeUtils.toString((JavaType)javaType)).describedAs("toString(%s)", new Object[]{type});
    }

    public StringAssert toGenericTypeString(String type) {
        JavaType javaType = this.getFirst(type);
        return (StringAssert)this.assertThat(TypeUtils.toGenericTypeString((JavaType.GenericTypeVariable)((JavaType.GenericTypeVariable)javaType))).describedAs("toGenericTypeString(%s)", new Object[]{type});
    }

    private JavaType getFirst(String type) {
        return (JavaType)Optional.ofNullable(this.types.get(type)).flatMap(list -> list.stream().findFirst()).orElseThrow(() -> new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Type not found: \u0001"}, (String)type))));
    }

    private JavaType getLast(String type) {
        return Optional.ofNullable(this.types.get(type)).map(list -> (JavaType)list.get(list.size() - 1)).orElseThrow(() -> new IllegalArgumentException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Type not found: \u0001"}, (String)type))));
    }
}

