/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MinimumJava17;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@MinimumJava17
public class SwitchExpressionTest
implements RewriteTest {
    @Test
    void switchExpressionsReturningEnums() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"enum Answer {\n    YES, MAYBE, NO\n}\n"), Assertions.java((String)"class Test {\n    private Answer run(String test) {\n        return switch (test) {\n            case \"test1\" -> Answer.NO;\n            case \"test2\" -> Answer.YES;\n            default -> Answer.MAYBE;\n        };\n    }\n}\n")});
    }

    @Test
    void basicSyntax() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n  int test(int i) {\n      return switch (i) {\n          case 1 -> 1;\n          case 2 -> 2;\n          default -> 3;\n      };\n  }\n}\n")});
    }

    @Test
    void multipleExpressions() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n  int test(int i) {\n      return switch (i) {\n          case 1, 2 -> 1;\n          default -> 3;\n      };\n  }\n}\n")});
    }

    @Test
    void yieldFromStatement() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n  int test(int i) {\n      return switch (i) {\n          case 1, 2:\n              yield 1;\n          default:\n              yield 3;\n      };\n  }\n}\n")});
    }

    @Test
    void yieldFromRule() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n  int test(int i) {\n      return switch (i) {\n          case 1, 2 -> { yield 1; }\n          default -> { yield 3; }\n      };\n  }\n}\n")});
    }

    @Test
    void visitSwitchExpressionAndGetType() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(JavaIsoVisitor::new)), new SourceSpecs[]{Assertions.java((String)"class Test {\n  int test(int i) {\n      return switch (i) {\n          case 1 -> 1;\n          case 2 -> 2;\n          default -> 3;\n      };\n  }\n}\n", spec -> spec.afterRecipe(cu -> {
            J.MethodDeclaration md = (J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            assert (md.getBody() != null);
            J.SwitchExpression s = (J.SwitchExpression)((J.Return)md.getBody().getStatements().get(0)).getExpression();
            assert (s != null);
            JavaType type = s.getType();
            org.assertj.core.api.Assertions.assertThat((Object)type).isEqualTo((Object)JavaType.Primitive.Int);
        }))});
    }
}

