/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.RemoveUnneededAssertion;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/cleanup/RemoveUnneededAssertionTest;", "Lorg/openrewrite/test/RewriteTest;", "assertFalse", "", "assertTrue", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "junit4AssertFalseWithFalseArgument", "junit4AssertTrueWithMessageAndFalseArgument", "junit4AssertTrueWithMessageAndTrueArgument", "junit4AssertTrueWithTrueArgument", "junitJupiterAssertFalse", "junitJupiterAssertFalseMessage", "junitJupiterAssertTrue", "junitJupiterAssertTrueMessage", "rewrite-java-tck"})
public interface RemoveUnneededAssertionTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void assertTrue();

    @Test
    public void assertFalse();

    @Test
    public void junitJupiterAssertTrue();

    @Test
    public void junitJupiterAssertFalse();

    @Test
    public void junitJupiterAssertTrueMessage();

    @Test
    public void junitJupiterAssertFalseMessage();

    @Test
    public void junit4AssertTrueWithTrueArgument();

    @Test
    public void junit4AssertFalseWithFalseArgument();

    @Test
    public void junit4AssertTrueWithMessageAndTrueArgument();

    @Test
    public void junit4AssertTrueWithMessageAndFalseArgument();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull RemoveUnneededAssertionTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new RemoveUnneededAssertion());
        }

        @Test
        public static void assertTrue(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                public class A {\n                    public void m() {\n                        System.out.println(\"Hello\");\n                        assert true;\n                        System.out.println(\"World\");\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                        System.out.println(\"Hello\");\n                        System.out.println(\"World\");\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void assertFalse(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                public class A {\n                    public void m() {\n                        System.out.println(\"Hello\");\n                        assert false;\n                        System.out.println(\"World\");\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void junitJupiterAssertTrue(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import static org.junit.jupiter.api.Assertions.assertTrue;\n                public class A {\n                    public void m() {\n                        assertTrue(true);\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::junitJupiterAssertTrue$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void junitJupiterAssertFalse(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import static org.junit.jupiter.api.Assertions.assertFalse;\n                public class A {\n                    public void m() {\n                        assertFalse(false);\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::junitJupiterAssertFalse$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void junitJupiterAssertTrueMessage(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import static org.junit.jupiter.api.Assertions.assertTrue;\n                public class A {\n                    public void m() {\n                        assertTrue(true, \"message\");\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::junitJupiterAssertTrueMessage$lambda$2, sourceSpecsArray);
        }

        @Test
        public static void junitJupiterAssertFalseMessage(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import static org.junit.jupiter.api.Assertions.assertFalse;\n                public class A {\n                    public void m() {\n                        assertFalse(false, \"message\");\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::junitJupiterAssertFalseMessage$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void junit4AssertTrueWithTrueArgument(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import static org.junit.Assert.assertTrue;\n                public class A {\n                    public void m() {\n                        assertTrue(true);\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::junit4AssertTrueWithTrueArgument$lambda$4, sourceSpecsArray);
        }

        @Test
        public static void junit4AssertFalseWithFalseArgument(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import static org.junit.Assert.assertFalse;\n                public class A {\n                    public void m() {\n                        assertFalse(false);\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::junit4AssertFalseWithFalseArgument$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void junit4AssertTrueWithMessageAndTrueArgument(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import static org.junit.Assert.assertTrue;\n                public class A {\n                    public void m() {\n                        assertTrue(\"message\", true);\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::junit4AssertTrueWithMessageAndTrueArgument$lambda$6, sourceSpecsArray);
        }

        @Test
        public static void junit4AssertTrueWithMessageAndFalseArgument(@NotNull RemoveUnneededAssertionTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import static org.junit.Assert.assertFalse;\n                public class A {\n                    public void m() {\n                        assertFalse(\"message\", false);\n                    }\n                }\n            ", (String)"\n                public class A {\n                    public void m() {\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::junit4AssertTrueWithMessageAndFalseArgument$lambda$7, sourceSpecsArray);
        }

        private static void junitJupiterAssertTrue$lambda$0(RecipeSpec spec) {
            String[] stringArray = new String[]{"junit-jupiter-api"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void junitJupiterAssertFalse$lambda$1(RecipeSpec spec) {
            String[] stringArray = new String[]{"junit-jupiter-api"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void junitJupiterAssertTrueMessage$lambda$2(RecipeSpec spec) {
            String[] stringArray = new String[]{"junit-jupiter-api"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void junitJupiterAssertFalseMessage$lambda$3(RecipeSpec spec) {
            String[] stringArray = new String[]{"junit-jupiter-api"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void junit4AssertTrueWithTrueArgument$lambda$4(RecipeSpec spec) {
            String[] stringArray = new String[]{"junit"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void junit4AssertFalseWithFalseArgument$lambda$5(RecipeSpec spec) {
            String[] stringArray = new String[]{"junit"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void junit4AssertTrueWithMessageAndTrueArgument$lambda$6(RecipeSpec spec) {
            String[] stringArray = new String[]{"junit"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }

        private static void junit4AssertTrueWithMessageAndFalseArgument$lambda$7(RecipeSpec spec) {
            String[] stringArray = new String[]{"junit"};
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(stringArray));
        }
    }
}

