/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.style.AutodetectTest;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u001e"}, d2={"Lorg/openrewrite/java/style/AutodetectTest;", "", "continuationIndents", "", "jp", "Lorg/openrewrite/java/JavaParser;", "defaultTabIndentSizeToOne", "detectAfterCommaInNewArray", "detectAfterTypeCast", "detectBeforeForSemicolon", "detectClrfLineFormat", "detectColonInForEachLoop", "detectElseOnNewLine", "detectElseWithNoNewLine", "detectImportCounts", "detectLfLineFormat", "detectMethodArgs", "detectMethodArgsAfterComma", "detectMethodArgsNoArgs", "detectMethodArgsNoSpaceForComma", "detectMethodArgsSpaceForComma", "detectNoSpacesWithinMethodCall", "detectSpacesWithinMethodCall", "detectStarImport", "mostCommonIndentTakesPrecedence", "rewriteImportLayout", "rewriteTabsAndIndents", "spinnakerTabsAndIndents", "springCloudTabsAndIndents", "springDemoApp", "rewrite-java-tck"})
public interface AutodetectTest {
    @Test
    public void springDemoApp(@NotNull JavaParser var1);

    @Test
    public void springCloudTabsAndIndents(@NotNull JavaParser var1);

    @Test
    public void spinnakerTabsAndIndents(@NotNull JavaParser var1);

    @Test
    public void rewriteTabsAndIndents(@NotNull JavaParser var1);

    @Test
    public void defaultTabIndentSizeToOne(@NotNull JavaParser var1);

    @Test
    public void rewriteImportLayout(@NotNull JavaParser var1);

    @Test
    public void detectStarImport(@NotNull JavaParser var1);

    @Test
    public void detectImportCounts(@NotNull JavaParser var1);

    @Test
    public void detectMethodArgs(@NotNull JavaParser var1);

    @Test
    public void detectMethodArgsAfterComma(@NotNull JavaParser var1);

    @Test
    public void detectColonInForEachLoop(@NotNull JavaParser var1);

    @Test
    public void detectAfterTypeCast(@NotNull JavaParser var1);

    @Test
    public void detectBeforeForSemicolon(@NotNull JavaParser var1);

    @Test
    public void detectMethodArgsNoArgs(@NotNull JavaParser var1);

    @Test
    public void detectMethodArgsNoSpaceForComma(@NotNull JavaParser var1);

    @Test
    public void detectMethodArgsSpaceForComma(@NotNull JavaParser var1);

    @Test
    public void detectAfterCommaInNewArray(@NotNull JavaParser var1);

    @Test
    public void detectNoSpacesWithinMethodCall(@NotNull JavaParser var1);

    @Test
    public void detectSpacesWithinMethodCall(@NotNull JavaParser var1);

    @Test
    public void detectElseWithNoNewLine(@NotNull JavaParser var1);

    @Test
    public void detectElseOnNewLine(@NotNull JavaParser var1);

    @Test
    public void detectClrfLineFormat(@NotNull JavaParser var1);

    @Test
    public void detectLfLineFormat(@NotNull JavaParser var1);

    @Test
    public void mostCommonIndentTakesPrecedence(@NotNull JavaParser var1);

    @Test
    public void continuationIndents(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void springDemoApp(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package com.kmccarpenter.demospring;\n\nimport org.springframework.boot.SpringApplication;\nimport org.springframework.boot.autoconfigure.SpringBootApplication;\n\n@SpringBootApplication\npublic class DemoSpringApplication {\n\n\tpublic static void main(String[] args) {\n\t\tSpringApplication.run(DemoSpringApplication.class, args);\n\t}\n\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)style;
            Boolean bl = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)bl).isTrue();
        }

        @Test
        public static void springCloudTabsAndIndents(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package org.springframework.cloud.netflix.eureka;\n\nimport static org.springframework.cloud.netflix.eureka.EurekaConstants.DEFAULT_PREFIX;\n\n@SuppressWarnings(\"ALL\")\n@ConfigurationProperties(EurekaClientConfigBean.PREFIX)\npublic class EurekaClientConfigBean implements EurekaClientConfig, Ordered {\n\tprivate static final int MINUTES = 60;\n\n\tpublic void setOrder(int order) {\n\t\tthis.order = order;\n\t}\n\n\t@Override\n\tpublic boolean equals(Object o) {\n\t\tEurekaClientConfigBean that = (EurekaClientConfigBean) o;\n\t\treturn Objects.equals(propertyResolver, that.propertyResolver) && enabled == that.enabled\n\t\t\t\t&& Objects.equals(transport, that.transport);\n\t}\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)style;
            Boolean bl = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)bl).isTrue();
            Integer n = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)n).intValue()).isEqualTo(1);
            Integer n2 = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)n2).intValue()).isEqualTo(1);
            Integer n3 = tabsAndIndents2.getContinuationIndent();
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"tabsAndIndents.continuationIndent");
            Assertions.assertThat((int)((Number)n3).intValue()).isEqualTo(2);
        }

        @Test
        public static void spinnakerTabsAndIndents(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package com.netflix.kayenta.orca.controllers;\n\n@SuppressWarnings(\"ALL\")\n@RestController\npublic class AdminController {\n  private final ApplicationEventPublisher publisher;\n\n  @Autowired\n  public AdminController(ApplicationEventPublisher publisher) {\n    this.publisher = publisher;\n  }\n\n  @RequestMapping(\n      method = RequestMethod.POST)\n  void setInstanceEnabled(@RequestBody Map<String, Boolean> enabledWrapper) {\n    Boolean enabled = enabledWrapper.get(\"enabled\");\n\n    if (enabled == null) {\n      throw new ValidationException(\"The field 'enabled' must be set.\", null);\n    }\n\n    setInstanceEnabled(enabled);\n  }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)style;
            Boolean bl = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)bl).isFalse();
            Integer n = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)n).intValue()).isEqualTo(2);
            Integer n2 = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)n2).intValue()).isEqualTo(2);
            Integer n3 = tabsAndIndents2.getContinuationIndent();
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"tabsAndIndents.continuationIndent");
            Assertions.assertThat((int)((Number)n3).intValue()).isEqualTo(4);
        }

        @Test
        public static void rewriteTabsAndIndents(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"public class Autodetect extends NamedStyles {\n    @Override\n    public J.Identifier visitIdentifier(J.Identifier ident, ExecutionContext ctx) {\n        J.Identifier i = super.visitIdentifier(ident, ctx);\n\n        if (TypeUtils.isOfClassType(i.getType(), oldPackageName)\n                && i.getSimpleName().equals(oldPackageType.getClassName())) {\n            i = i.withName((newPackageType).getClassName())\n                    .withType(newPackageType);\n        }\n\n        return i;\n    }\n\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)style;
            Boolean bl = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)bl).isFalse();
            Integer n = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)n).intValue()).isEqualTo(4);
            Integer n2 = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)n2).intValue()).isEqualTo(4);
            Integer n3 = tabsAndIndents2.getContinuationIndent();
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"tabsAndIndents.continuationIndent");
            Assertions.assertThat((int)((Number)n3).intValue()).isEqualTo(8);
        }

        @Test
        public static void defaultTabIndentSizeToOne(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"/**\n * \n */\npublic class Test {\n\tprivate final ApplicationEventPublisher publisher;\n\tpublic void method() {\n\t\tint value = 0;\n\t}\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)style;
            Boolean bl = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)bl).isTrue();
            Integer n = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)n).intValue()).isEqualTo(1);
            Integer n2 = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)n2).intValue()).isEqualTo(1);
        }

        @Test
        public static void rewriteImportLayout(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"import com.fasterxml.jackson.annotation.JsonCreator;\n\nimport org.openrewrite.internal.StringUtils;\nimport org.openrewrite.internal.ListUtils;\nimport org.openrewrite.internal.lang.Nullable;\n\nimport java.util.*;\nimport java.util.stream.Collectors;\n\nimport static java.util.Collections.*;\nimport static java.util.function.Function.identity;\n\npublic class Test {\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(ImportLayoutStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            ImportLayoutStyle importLayout = (ImportLayoutStyle)style;
            Assertions.assertThat(importLayout.getLayout().get(0)).isInstanceOf(ImportLayoutStyle.Block.AllOthers.class);
            Assertions.assertThat(importLayout.getLayout().get(1)).isInstanceOf(ImportLayoutStyle.Block.BlankLines.class);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(2)).isInstanceOf(ImportLayoutStyle.Block.ImportPackage.class)).matches(arg_0 -> DefaultImpls.rewriteImportLayout$lambda$0(rewriteImportLayout.1.INSTANCE, arg_0))).matches(arg_0 -> DefaultImpls.rewriteImportLayout$lambda$1(rewriteImportLayout.2.INSTANCE, arg_0));
            Assertions.assertThat(importLayout.getLayout().get(3)).isInstanceOf(ImportLayoutStyle.Block.BlankLines.class);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(4)).isInstanceOf(ImportLayoutStyle.Block.ImportPackage.class)).matches(arg_0 -> DefaultImpls.rewriteImportLayout$lambda$2(rewriteImportLayout.3.INSTANCE, arg_0))).matches(arg_0 -> DefaultImpls.rewriteImportLayout$lambda$3(rewriteImportLayout.4.INSTANCE, arg_0));
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(5)).isInstanceOf(ImportLayoutStyle.Block.ImportPackage.class)).matches(arg_0 -> DefaultImpls.rewriteImportLayout$lambda$4(rewriteImportLayout.5.INSTANCE, arg_0))).matches(arg_0 -> DefaultImpls.rewriteImportLayout$lambda$5(rewriteImportLayout.6.INSTANCE, arg_0));
            Assertions.assertThat(importLayout.getLayout().get(6)).isInstanceOf(ImportLayoutStyle.Block.BlankLines.class);
            ((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(7)).isInstanceOf(ImportLayoutStyle.Block.AllOthers.class)).matches(arg_0 -> DefaultImpls.rewriteImportLayout$lambda$6(rewriteImportLayout.7.INSTANCE, arg_0));
        }

        @Test
        public static void detectStarImport(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"import java.util.*;\n\npublic class Test {\n    List<Integer> l;\n    Set<Integer> s;\n    Map<Integer, Integer> m;\n    Collection<Integer> c;\n    LinkedHashMap<Integer, Integer> lhm;\n    HashSet<Integer> integer;\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(ImportLayoutStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            ImportLayoutStyle importLayout = (ImportLayoutStyle)style;
            Assertions.assertThat((int)importLayout.getClassCountToUseStarImport()).isEqualTo(6);
        }

        @Test
        public static void detectImportCounts(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"import java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.HashSet;\nimport java.util.List;\nimport java.util.Set;\n\nimport javax.persistence.Entity;\nimport javax.persistence.FetchType;\nimport javax.persistence.JoinColumn;\nimport javax.persistence.JoinTable;\nimport javax.persistence.ManyToMany;\nimport javax.persistence.Table;\nimport javax.xml.bind.annotation.XmlElement;\n\npublic class Test {\n    List<Integer> l;\n    Set<Integer> s;\n    Map<Integer, Integer> m;\n    Collection<Integer> c;\n    LinkedHashMap<Integer, Integer> lhm;\n    HashSet<Integer> integer;\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(ImportLayoutStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            ImportLayoutStyle importLayout = (ImportLayoutStyle)style;
            Assertions.assertThat((int)importLayout.getClassCountToUseStarImport()).isEqualTo(Integer.MAX_VALUE);
            Assertions.assertThat((int)importLayout.getNameCountToUseStarImport()).isEqualTo(Integer.MAX_VALUE);
        }

        @Test
        public static void detectMethodArgs(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void i() {\n        a(\"a\" ,\"b\" ,\"c\" ,\"d\");\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getBeforeComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.beforeComma");
            Assertions.assertThat((boolean)bl).isTrue();
            Boolean bl2 = spacesStyle.getOther().getAfterComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"spacesStyle.other.afterComma");
            Assertions.assertThat((boolean)bl2).isFalse();
        }

        @Test
        public static void detectMethodArgsAfterComma(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void i() {\n        a(\"a\", \"b\");\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getBeforeComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.beforeComma");
            Assertions.assertThat((boolean)bl).isFalse();
            Boolean bl2 = spacesStyle.getOther().getAfterComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"spacesStyle.other.afterComma");
            Assertions.assertThat((boolean)bl2).isTrue();
        }

        @Test
        public static void detectColonInForEachLoop(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void i() {\n        for (int i : new int[]{}) {}\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getBeforeColonInForEach();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.beforeColonInForEach");
            Assertions.assertThat((boolean)bl).isTrue();
        }

        @Test
        public static void detectAfterTypeCast(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                class T {\n                    {\n                        String s = (String) getString();\n                    }\n                }\n            "};
            List cu = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cu);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getAfterTypeCast();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.afterTypeCast");
            Assertions.assertThat((boolean)bl).isTrue();
        }

        @Test
        public static void detectBeforeForSemicolon(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            class T {\n                void m() {\n                    for (int i = 0; i < x; i++) {}\n                }\n            }\n            "};
            List cu = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cu);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getBeforeForSemicolon();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.beforeForSemicolon");
            Assertions.assertThat((boolean)bl).isFalse();
            Boolean bl2 = spacesStyle.getOther().getAfterForSemicolon();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"spacesStyle.other.afterForSemicolon");
            Assertions.assertThat((boolean)bl2).isTrue();
        }

        @Test
        public static void detectMethodArgsNoArgs(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void i() {\n        a();\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getBeforeComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.beforeComma");
            Assertions.assertThat((boolean)bl).isFalse();
            Boolean bl2 = spacesStyle.getOther().getAfterComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"spacesStyle.other.afterComma");
            Assertions.assertThat((boolean)bl2).isTrue();
        }

        @Test
        public static void detectMethodArgsNoSpaceForComma(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void i() {\n        a(\"a\",\"b\",\"c\");\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getBeforeComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.beforeComma");
            Assertions.assertThat((boolean)bl).isFalse();
            Boolean bl2 = spacesStyle.getOther().getAfterComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"spacesStyle.other.afterComma");
            Assertions.assertThat((boolean)bl2).isFalse();
        }

        @Test
        public static void detectMethodArgsSpaceForComma(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void i() {\n        a(\"a\" , \"b\" , \"c\");\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getBeforeComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.beforeComma");
            Assertions.assertThat((boolean)bl).isTrue();
            Boolean bl2 = spacesStyle.getOther().getAfterComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"spacesStyle.other.afterComma");
            Assertions.assertThat((boolean)bl2).isTrue();
        }

        @Test
        public static void detectAfterCommaInNewArray(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                class T {\n                    static {\n                        int[] i = new int[]{1, 2, 3, 4};\n                    }\n                }\n            "};
            List cu = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cu);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getOther().getBeforeComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.other.beforeComma");
            Assertions.assertThat((boolean)bl).isFalse();
            Boolean bl2 = spacesStyle.getOther().getAfterComma();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"spacesStyle.other.afterComma");
            Assertions.assertThat((boolean)bl2).isTrue();
        }

        @Test
        public static void detectNoSpacesWithinMethodCall(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void a(String a, String b, String c) {\n    }\n    void i() {\n        a(\"a\",\"b\",\"c\");\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getWithin().getMethodCallParentheses();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.within.methodCallParentheses");
            Assertions.assertThat((boolean)bl).isFalse();
        }

        @Test
        public static void detectSpacesWithinMethodCall(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void i() {\n        a( \"a\",\"b\",\"c\" );\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(SpacesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            SpacesStyle spacesStyle = (SpacesStyle)style;
            Boolean bl = spacesStyle.getWithin().getMethodCallParentheses();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"spacesStyle.within.methodCallParentheses");
            Assertions.assertThat((boolean)bl).isTrue();
        }

        @Test
        public static void detectElseWithNoNewLine(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void method(int n) {\n        if (n == 0) {\n        } else if (n == 1) {\n        } else {\n        }\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(WrappingAndBracesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            WrappingAndBracesStyle wrappingAndBracesStyle = (WrappingAndBracesStyle)style;
            Boolean bl = wrappingAndBracesStyle.getIfStatement().getElseOnNewLine();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"wrappingAndBracesStyle.ifStatement.elseOnNewLine");
            Assertions.assertThat((boolean)bl).isFalse();
        }

        @Test
        public static void detectElseOnNewLine(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    void method(int n) {\n        if (n == 0) {\n        }\n        else if (n == 1) {\n        }\n        else {\n        }\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(WrappingAndBracesStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            WrappingAndBracesStyle wrappingAndBracesStyle = (WrappingAndBracesStyle)style;
            Boolean bl = wrappingAndBracesStyle.getIfStatement().getElseOnNewLine();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"wrappingAndBracesStyle.ifStatement.elseOnNewLine");
            Assertions.assertThat((boolean)bl).isTrue();
        }

        @Test
        public static void detectClrfLineFormat(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            GeneralFormatStyle lineFormatStyle;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\r\n    // some comment\r\n    public void test() {\n        System.out.println();\n    }\r\n}\r\n"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            GeneralFormatStyle generalFormatStyle = lineFormatStyle = (GeneralFormatStyle)NamedStyles.merge(GeneralFormatStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)generalFormatStyle);
            Assertions.assertThat((boolean)generalFormatStyle.isUseCRLFNewLines()).isTrue();
        }

        @Test
        public static void detectLfLineFormat(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            GeneralFormatStyle lineFormatStyle;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    // some comment\r\n    public void test() {\n        System.out.println();\n    }\n}\r\n"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            GeneralFormatStyle generalFormatStyle = lineFormatStyle = (GeneralFormatStyle)NamedStyles.merge(GeneralFormatStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)generalFormatStyle);
            Assertions.assertThat((boolean)generalFormatStyle.isUseCRLFNewLines()).isFalse();
        }

        @Test
        public static void mostCommonIndentTakesPrecedence(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package com.test;\n\npublic class Foo {\n   private static final int underIndented;\n         int overIndented;\n      public void setOrder(int order) {\n            this.order = order;\n            System.out.print(\"One two-space indent shouldn't override predominant 4-space indent\");\n            Object o = new Object() {\n                  void fooBar() {\n                        System.out.print(\"fooBar\");\n                  }\n            };\n      }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)style;
            Boolean bl = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)bl).isFalse();
            Integer n = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)n).intValue()).isEqualTo(6);
            Integer n2 = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"tabsAndIndents.indentSize");
            ((AbstractIntegerAssert)Assertions.assertThat((int)((Number)n2).intValue()).as("While there are outlier 3 and 9 space indents, the most prevalent indentation is 6", new Object[0])).isEqualTo(6);
            Integer n3 = tabsAndIndents2.getContinuationIndent();
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"tabsAndIndents.continuationIndent");
            ((AbstractIntegerAssert)Assertions.assertThat((int)((Number)n3).intValue()).as("With no actual continuation indents to go off of, assume IntelliJ default of 2x the normal indent", new Object[0])).isEqualTo(12);
        }

        @Test
        public static void continuationIndents(@NotNull AutodetectTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"import java.util.stream.Stream;\n\nclass Continuations {\n    public void cont() {\n        Stream.of(\"foo\",\n                                \"continuation\")\n                    .map(it ->\n                                Stream.of(it)\n                                            .map(it2 ->\n                                                        Stream.of(it2)\n                                                                    .map(it3 ->\n                                                                                it3))\n                                            .flatMap(it4 ->\n                                                        it4));\n        int higherContIndent = 1 +\n                                        2;\n        int lowerContIndent = 1 +\n                2;\n        int sum = 1 +\n                    (2 +\n                    3) +\n                    Stream.of(\n                                2 + 4,\n                                4\n                    ).reduce(0,\n                                Integer::sum);\n    }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            Style style = NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Intrinsics.checkNotNull((Object)style);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)style;
            Boolean bl = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)bl).isFalse();
            Integer n = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)n).intValue()).isEqualTo(4);
            Integer n2 = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)n2).intValue()).isEqualTo(4);
            Integer n3 = tabsAndIndents2.getContinuationIndent();
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"tabsAndIndents.continuationIndent");
            Assertions.assertThat((int)((Number)n3).intValue()).isEqualTo(12);
        }

        private static boolean rewriteImportLayout$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static boolean rewriteImportLayout$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static boolean rewriteImportLayout$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static boolean rewriteImportLayout$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static boolean rewriteImportLayout$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static boolean rewriteImportLayout$lambda$5(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static boolean rewriteImportLayout$lambda$6(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

