/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.dataflow.ExternalSinkModels;
import org.openrewrite.java.dataflow.FindLocalFlowPaths;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.LocalTaintFlowSpec;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/dataflow/FindLocalTaintFlowToExternalSinkTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "taint from String through File to create-file", "taint from String to create-file", "rewrite-java-tck"})
public interface FindLocalTaintFlowToExternalSinkTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void taint from String to create-file();

    @Test
    public void taint from String through File to create-file();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull FindLocalTaintFlowToExternalSinkTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::defaults$lambda$0));
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        @Test
        public static void taint from String to create-file(@NotNull FindLocalTaintFlowToExternalSinkTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.io.FileOutputStream;\n                class Test {\n                    File source() { return null; }\n                    void test(String contents) {\n                        File f = source();\n                        try (FileOutputStream fos = new FileOutputStream(f)) {\n                            fos.write(contents.getBytes());\n                        }\n                    }\n                }\n                ", (String)"\n                import java.io.File;\n                import java.io.FileOutputStream;\n                class Test {\n                    File source() { return null; }\n                    void test(String contents) {\n                        File f = /*~~>*/source();\n                        try (FileOutputStream fos = new FileOutputStream(/*~~>*/f)) {\n                            fos.write(contents.getBytes());\n                        }\n                    }\n                }\n                ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint from String through File to create-file(@NotNull FindLocalTaintFlowToExternalSinkTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.io.FileOutputStream;\n                class Test {\n                    String source() { return null; }\n                    void test(String contents) {\n                        String s = source();\n                        File f = new File(s);\n                        try (FileOutputStream fos = new FileOutputStream(f)) {\n                            fos.write(contents.getBytes());\n                        }\n                    }\n                }\n                ", (String)"\n                import java.io.File;\n                import java.io.FileOutputStream;\n                class Test {\n                    String source() { return null; }\n                    void test(String contents) {\n                        String s = /*~~>*/source();\n                        File f = /*~~>*/new File(/*~~>*/s);\n                        try (FileOutputStream fos = new FileOutputStream(/*~~>*/f)) {\n                            fos.write(contents.getBytes());\n                        }\n                    }\n                }\n                ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        private static TreeVisitor defaults$lambda$0() {
            return (TreeVisitor)new FindLocalFlowPaths((LocalFlowSpec)new LocalTaintFlowSpec<J.MethodInvocation, Expression>(){

                public boolean isSource(@NotNull J.MethodInvocation source, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    return Intrinsics.areEqual((Object)source.getSimpleName(), (Object)"source");
                }

                public boolean isSink(@NotNull Expression sink, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    return ExternalSinkModels.getInstance().isSinkNode(sink, cursor, "create-file");
                }
            });
        }
    }
}

