/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.PrimitiveWrapperClassConstructorToValueOf;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017\u00a8\u0006\f"}, d2={"Lorg/openrewrite/java/cleanup/PrimitiveWrapperClassConstructorToValueOfTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doubleToFloat", "integerValueOf", "newClassToValueOf", "newIntegerToValueOfValueRef", "templateIsNewClassArgumentForNewClass", "withinEnum", "rewrite-java-tck"})
public interface PrimitiveWrapperClassConstructorToValueOfTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void integerValueOf();

    @Test
    public void newClassToValueOf();

    @Test
    public void newIntegerToValueOfValueRef();

    @Test
    public void templateIsNewClassArgumentForNewClass();

    @Test
    public void doubleToFloat();

    @Test
    public void withinEnum();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull PrimitiveWrapperClassConstructorToValueOfTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new PrimitiveWrapperClassConstructorToValueOf());
        }

        @Test
        public static void integerValueOf(@NotNull PrimitiveWrapperClassConstructorToValueOfTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                Integer i = Integer.valueOf(1);\n                String hello = new String(\"Hello\" + \" world \" + i);\n                Long l = 11L;\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void newClassToValueOf(@NotNull PrimitiveWrapperClassConstructorToValueOfTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                Boolean bool = new Boolean(true);\n                Byte b = new Byte(\"1\");\n                Character c = new Character('c');\n                Double d = new Double(1.0);\n                Float f = new Float(1.1f);\n                Long l = new Long(1);\n                Short sh = new Short(\"12\");\n                short s3 = 3;\n                Short sh3 = new Short(s3);\n                Integer i = new Integer(1);\n            }\n        ", (String)"\n            class A {\n                Boolean bool = Boolean.valueOf(true);\n                Byte b = Byte.valueOf(\"1\");\n                Character c = Character.valueOf('c');\n                Double d = Double.valueOf(1.0);\n                Float f = Float.valueOf(1.1f);\n                Long l = Long.valueOf(1);\n                Short sh = Short.valueOf(\"12\");\n                short s3 = 3;\n                Short sh3 = Short.valueOf(s3);\n                Integer i = Integer.valueOf(1);\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void newIntegerToValueOfValueRef(@NotNull PrimitiveWrapperClassConstructorToValueOfTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                boolean fls = true;\n                Boolean b2 = new Boolean(fls);\n                char ch = 'c';\n                Character c = new Character(ch);\n                double d1 = 1.1;\n                Double d = new Double(d1);\n                int k = 1;\n                Integer k2 = new Integer(k);\n            }\n        ", (String)"\n            class A {\n                boolean fls = true;\n                Boolean b2 = Boolean.valueOf(fls);\n                char ch = 'c';\n                Character c = Character.valueOf(ch);\n                double d1 = 1.1;\n                Double d = Double.valueOf(d1);\n                int k = 1;\n                Integer k2 = Integer.valueOf(k);\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void templateIsNewClassArgumentForNewClass(@NotNull PrimitiveWrapperClassConstructorToValueOfTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Date;\n            public class A {\n                public static void main(String[] args) {\n                    Date d = new Date(new Long(0));\n                    Long l = new Long(new Integer(0));\n                }\n            }\n        ", (String)"\n            import java.util.Date;\n            public class A {\n                public static void main(String[] args) {\n                    Date d = new Date(Long.valueOf(0));\n                    Long l = Long.valueOf(Integer.valueOf(0));\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doubleToFloat(@NotNull PrimitiveWrapperClassConstructorToValueOfTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                Double d1 = Double.valueOf(1.0);\n                void makeFloats() {\n                    Float f = new Float(2.0d);\n                    Float f2 = new Float(getD());\n                    Float f3 = new Float(d1);\n                }\n                Double getD() {\n                    return Double.valueOf(2.0d);\n                }\n            }\n        ", (String)"\n            class T {\n                Double d1 = Double.valueOf(1.0);\n                void makeFloats() {\n                    Float f = Float.valueOf(\"2.0\");\n                    Float f2 = Float.valueOf(getD().floatValue());\n                    Float f3 = Float.valueOf(d1.floatValue());\n                }\n                Double getD() {\n                    return Double.valueOf(2.0d);\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void withinEnum(@NotNull PrimitiveWrapperClassConstructorToValueOfTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public enum Options {\n            \n                JAR(\"instance.jar.file\"),\n                JVM_ARGUMENTS(\"instance.vm.args\"),\n                QUICKSTART_OPTIONS(\"instance.options\"),\n                INSTALLATIONS(\"instance.installations\"),\n                START_TIMEOUT(\"instance.timeout\");\n            \n                private String name;\n            \n                Options(String name) {\n                    this.name = name;\n                }\n            \n                public String asString() {\n                    return System.getProperty(name);\n                }\n                \n                public Integer asInteger(int defaultValue) {\n                    String string  = asString();\n            \n                    if (string == null) {\n                        return defaultValue;\n                    }\n            \n                    return new Integer(asString());\n                }\n            \n            }\n        ", (String)"\n            public enum Options {\n            \n                JAR(\"instance.jar.file\"),\n                JVM_ARGUMENTS(\"instance.vm.args\"),\n                QUICKSTART_OPTIONS(\"instance.options\"),\n                INSTALLATIONS(\"instance.installations\"),\n                START_TIMEOUT(\"instance.timeout\");\n            \n                private String name;\n            \n                Options(String name) {\n                    this.name = name;\n                }\n            \n                public String asString() {\n                    return System.getProperty(name);\n                }\n                \n                public Integer asInteger(int defaultValue) {\n                    String string  = asString();\n            \n                    if (string == null) {\n                        return defaultValue;\n                    }\n            \n                    return Integer.valueOf(asString());\n                }\n            \n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }
    }
}

