/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.ChangePackage;
import org.openrewrite.java.ChangePackageTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b \bf\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\bH\u0017J\b\u0010\n\u001a\u00020\bH\u0017J\b\u0010\u000b\u001a\u00020\bH\u0017J\b\u0010\f\u001a\u00020\bH\u0017J\b\u0010\r\u001a\u00020\bH\u0017J\b\u0010\u000e\u001a\u00020\bH\u0017J\b\u0010\u000f\u001a\u00020\bH\u0017J\b\u0010\u0010\u001a\u00020\bH\u0017J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\bH\u0017J\b\u0010\u0015\u001a\u00020\bH\u0017J\b\u0010\u0016\u001a\u00020\bH\u0017J\b\u0010\u0017\u001a\u00020\bH\u0017J\b\u0010\u0018\u001a\u00020\bH\u0017J\b\u0010\u0019\u001a\u00020\bH\u0017J\b\u0010\u001a\u001a\u00020\bH\u0017J\b\u0010\u001b\u001a\u00020\bH\u0017J\b\u0010\u001c\u001a\u00020\bH\u0017J\b\u0010\u001d\u001a\u00020\bH\u0017J\b\u0010\u001e\u001a\u00020\bH\u0017J\b\u0010\u001f\u001a\u00020\bH\u0017J\b\u0010 \u001a\u00020\bH\u0017J\b\u0010!\u001a\u00020\bH\u0017J\b\u0010\"\u001a\u00020\bH\u0017J\b\u0010#\u001a\u00020\bH\u0017J\b\u0010$\u001a\u00020\bH\u0017J\b\u0010%\u001a\u00020\bH\u0017J\b\u0010&\u001a\u00020\bH\u0017J\b\u0010'\u001a\u00020\bH\u0017J\b\u0010(\u001a\u00020\bH\u0017J\b\u0010)\u001a\u00020\bH\u0017J\b\u0010*\u001a\u00020\bH\u0017J\b\u0010+\u001a\u00020\bH\u0017J\b\u0010,\u001a\u00020\bH\u0017J\b\u0010-\u001a\u00020\bH\u0017J\b\u0010.\u001a\u00020\bH\u0017J\b\u0010/\u001a\u00020\bH\u0017J\b\u00100\u001a\u00020\bH\u0017J\b\u00101\u001a\u00020\bH\u0017R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00063"}, d2={"Lorg/openrewrite/java/ChangePackageTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "Lorg/openrewrite/test/RewriteTest;", "recipe", "Lorg/openrewrite/java/ChangePackage;", "getRecipe", "()Lorg/openrewrite/java/ChangePackage;", "annotation", "", "array", "assignment", "boundedGenericType", "changeTypeWithInnerClass", "checkValidation", "classDecl", "classReference", "classTypeParameter", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "dontAddImportWhenNoChangesWereMade", "lambda", "method", "methodInvocationTypeParametersAndWildcard", "methodSelect", "moveToSubPackageDoNotRemoveImport", "moveToSubPackageRemoveImport", "multiCatch", "multiDimensionalArray", "multiVariable", "newClass", "parameterizedType", "removePackage", "renameImport", "renamePackage", "renamePackageNonRecursive", "renamePackageRecursive", "renamePackageRecursiveImported", "renameSingleSegmentPackage", "staticImport", "staticImportEnumSamePackage", "typeCast", "typeParameter", "typesInUseContainsOneMethodTypeReference", "typesInUseContainsOneTypeReference", "updateClassPrefixWithEmptyPackage", "updateImportPrefixWithEmptyPackage", "updateMethodType", "updateVariableType", "updatesImplements", "Companion", "rewrite-java-tck"})
public interface ChangePackageTest
extends JavaRecipeTest,
RewriteTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangePackageTest$Companion.$$INSTANCE;

    @NotNull
    public ChangePackage getRecipe();

    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void renamePackageNonRecursive();

    @Test
    public void dontAddImportWhenNoChangesWereMade();

    @Test
    public void renameImport();

    @Test
    public void typesInUseContainsOneTypeReference();

    @Test
    public void typesInUseContainsOneMethodTypeReference();

    @Test
    public void updateMethodType();

    @Test
    public void updateVariableType();

    @Test
    public void renamePackage();

    @Test
    public void renamePackageRecursive();

    @Test
    public void renamePackageRecursiveImported();

    @Test
    public void typeParameter();

    @Test
    public void classTypeParameter();

    @Test
    public void boundedGenericType();

    @Test
    public void annotation();

    @Test
    public void array();

    @Test
    public void multiDimensionalArray();

    @Test
    public void classDecl();

    @Test
    public void updatesImplements();

    @Test
    public void moveToSubPackageRemoveImport();

    @Test
    public void moveToSubPackageDoNotRemoveImport();

    @Test
    public void lambda();

    @Test
    public void method();

    @Test
    public void methodInvocationTypeParametersAndWildcard();

    @Test
    public void multiCatch();

    @Test
    public void multiVariable();

    @Test
    public void assignment();

    @Test
    public void newClass();

    @Test
    public void parameterizedType();

    @Test
    public void typeCast();

    @Test
    public void classReference();

    @Test
    public void methodSelect();

    @Test
    public void staticImport();

    @Test
    public void changeTypeWithInnerClass();

    @Test
    public void updateImportPrefixWithEmptyPackage();

    @Test
    public void updateClassPrefixWithEmptyPackage();

    @Test
    public void renameSingleSegmentPackage();

    @Test
    public void removePackage();

    @Test
    public void staticImportEnumSamePackage();

    @Test
    public void checkValidation();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/ChangePackageTest$Companion;", "", "()V", "testClassAfter", "", "testClassBefore", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String testClassBefore;
        @NotNull
        private static final String testClassAfter;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            testClassBefore = "package org.openrewrite;\npublic class Test extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
            testClassAfter = "package org.openrewrite.test;\npublic class Test extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ChangePackage getRecipe(@NotNull ChangePackageTest $this) {
            return new ChangePackage("org.openrewrite", "org.openrewrite.test", null);
        }

        public static void defaults(@NotNull ChangePackageTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)$this.getRecipe());
        }

        @Test
        public static void renamePackageNonRecursive(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite.internal;\n            class Test {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::renamePackageNonRecursive$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void dontAddImportWhenNoChangesWereMade(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class B {}\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameImport(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public class Test {\n            }\n        ", (String)"\n            package org.openrewrite.test;\n            public class Test {\n            }\n        "), Assertions.java((String)"\n            import org.openrewrite.Test;\n            \n            class A {\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            \n            class A {\n            }\n        ", DefaultImpls::renameImport$lambda$2)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void typesInUseContainsOneTypeReference(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import org.openrewrite.Test;\n            \n            public class A {\n                Test a;\n                Test b;\n                Test c;\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                Test a;\n                Test b;\n                Test c;\n            }\n        ", DefaultImpls::typesInUseContainsOneTypeReference$lambda$4)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void typesInUseContainsOneMethodTypeReference(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import org.openrewrite.Test;\n            \n            public class A {\n                void method() {\n                    Test a = test(null);\n                    Test b = test(null);\n                    Test c = test(null);\n                }\n                \n                Test test(Test test) {\n                    return test;\n                }\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                void method() {\n                    Test a = test(null);\n                    Test b = test(null);\n                    Test c = test(null);\n                }\n                \n                Test test(Test test) {\n                    return test;\n                }\n            }\n        ", DefaultImpls::typesInUseContainsOneMethodTypeReference$lambda$6)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void updateMethodType(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public class Test {\n            }\n        ", (String)"\n            package org.openrewrite.test;\n            public class Test {\n            }\n        "), Assertions.java((String)"\n            package org.foo;\n            \n            import org.openrewrite.Test;\n            \n            public class Example {\n                public static Test method(Test test) {\n                    return test;\n                }\n            }\n        ", (String)"\n            package org.foo;\n            \n            import org.openrewrite.test.Test;\n            \n            public class Example {\n                public static Test method(Test test) {\n                    return test;\n                }\n            }\n        "), Assertions.java((String)"\n            import org.openrewrite.Test;\n            import org.foo.Example;\n            \n            public class A {\n                Test local = Example.method(null);\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            import org.foo.Example;\n            \n            public class A {\n                Test local = Example.method(null);\n            }\n        ", DefaultImpls::updateMethodType$lambda$8)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void updateVariableType(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import org.openrewrite.Test;\n            \n            public class A {\n                Test a;\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                Test a;\n            }\n        ", DefaultImpls::updateVariableType$lambda$10)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renamePackage(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            class Test {\n            }\n        ", (String)"\n            package org.openrewrite.test;\n            class Test {\n            }\n        ", DefaultImpls::renamePackage$lambda$12)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renamePackageRecursive(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite.internal;\n            class Test {\n            }\n        ", (String)"\n            package org.openrewrite.test.internal;\n            class Test {\n            }\n        ", DefaultImpls::renamePackageRecursive$lambda$14)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renamePackageRecursiveImported(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite.other;\n            public class Test {}\n        ", (String)"\n            package org.openrewrite.test.other;\n            public class Test {}\n        "), Assertions.java((String)"\n            import org.openrewrite.other.Test;\n            class A {\n                Test test = null;\n            }\n        ", (String)"\n            import org.openrewrite.test.other.Test;\n            class A {\n                Test test = null;\n            }\n        ", DefaultImpls::renamePackageRecursiveImported$lambda$17)};
            $this.rewriteRun(DefaultImpls::renamePackageRecursiveImported$lambda$15, sourceSpecsArray);
        }

        @Test
        public static void typeParameter(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public class Test {\n            }\n        ", (String)"\n            package org.openrewrite.test;\n            public class Test {\n            }\n        "), Assertions.java((String)"\n            import org.openrewrite.Test;\n            import java.util.List;\n            \n            class A {\n                List<Test> list;\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            import java.util.List;\n            \n            class A {\n                List<Test> list;\n            }\n        ", DefaultImpls::typeParameter$lambda$19)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void classTypeParameter(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.openrewrite;\n            public class Test {\n            }\n        ", (String)"\n            package org.openrewrite.test;\n            public class Test {\n            }\n        "), Assertions.java((String)"\n            import org.openrewrite.Test;\n            \n            class A<T extends Test> {\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            \n            class A<T extends Test> {\n            }\n        ", DefaultImpls::classTypeParameter$lambda$21)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void boundedGenericType(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import org.openrewrite.Test;\n            \n            public class A {\n                <T extends Test> T method(T t) {\n                    return t;\n                }\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                <T extends Test> T method(T t) {\n                    return t;\n                }\n            }\n        ", DefaultImpls::boundedGenericType$lambda$23)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotation(@NotNull ChangePackageTest $this) {
            String[] stringArray = new String[]{"\n                package org.openrewrite;\n                \n                import java.lang.annotation.ElementType;\n                import java.lang.annotation.Retention;\n                import java.lang.annotation.RetentionPolicy;\n                import java.lang.annotation.Target;\n                \n                @Target({ElementType.TYPE, ElementType.METHOD})\n                @Retention(RetentionPolicy.RUNTIME)\n                public @interface Test {}\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            import org.openrewrite.Test;\n            public class A {\n                @Test\n                void method() {}\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            public class A {\n                @Test\n                void method() {}\n            }\n        ", 0, 0, null, annotation.1.INSTANCE, 455, null);
        }

        @Test
        public static void array(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            public class B {\n               org.openrewrite.Test[] a = new org.openrewrite.Test[0];\n            }\n        ", (String)"\n            public class B {\n               org.openrewrite.test.Test[] a = new org.openrewrite.test.Test[0];\n            }\n        ", DefaultImpls::array$lambda$25)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multiDimensionalArray(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import org.openrewrite.Test;\n            \n            public class A {\n                Test[][] multiDimensionalArray;\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                Test[][] multiDimensionalArray;\n            }\n        ", DefaultImpls::multiDimensionalArray$lambda$27)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void classDecl(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"public interface I1 {}"), Assertions.java((String)"\n            public class B extends org.openrewrite.Test implements I1 {}\n        ", (String)"\n            public class B extends org.openrewrite.test.Test implements I1 {}\n        ", DefaultImpls::classDecl$lambda$29)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void updatesImplements(@NotNull ChangePackageTest $this) {
            String[] stringArray = new String[]{"\n                package org.openrewrite;\n                public interface Oi{}\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            package org.openrewrite;\n            \n            public class Mi implements org.openrewrite.Oi {\n            }\n        ", stringArray2, "\n            package org.openrewrite.test;\n            \n            public class Mi implements org.openrewrite.test.Oi {\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void moveToSubPackageRemoveImport(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product;\n\n            public class RunnableFactory {\n                public static Runnable getRunnable() {\n                    return null;\n                }\n            }\n        "), Assertions.java((String)"\n            package com.acme.project;\n\n            import com.acme.product.RunnableFactory;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    RunnableFactory.getRunnable().run();\n                }\n            }\n        ", (String)"\n            package com.acme.product;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    RunnableFactory.getRunnable().run();\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::moveToSubPackageRemoveImport$lambda$30, sourceSpecsArray);
        }

        @Test
        public static void moveToSubPackageDoNotRemoveImport(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product;\n\n            public class RunnableFactory {\n                public static Runnable getRunnable() {\n                    return null;\n                }\n            }\n        "), Assertions.java((String)"\n            package com.acme.project.other;\n\n            import com.acme.product.RunnableFactory;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    RunnableFactory.getRunnable().run();\n                }\n            }\n        ", (String)"\n            package com.acme.product.other;\n            \n            import com.acme.product.RunnableFactory;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    RunnableFactory.getRunnable().run();\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::moveToSubPackageDoNotRemoveImport$lambda$31, sourceSpecsArray);
        }

        @Test
        public static void lambda(@NotNull ChangePackageTest $this) {
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public interface Procedure {\n                void execute();\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            import org.openrewrite.Procedure;\n            public abstract class Worker {\n                void callWorker() {\n                    worker(() -> {});\n                }\n                abstract void worker(Procedure procedure);\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Procedure;\n            public abstract class Worker {\n                void callWorker() {\n                    worker(() -> {});\n                }\n                abstract void worker(Procedure procedure);\n            }\n        ", 0, 0, null, lambda.1.INSTANCE, 455, null);
        }

        @Test
        public static void method(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            public class A {\n               public org.openrewrite.Test foo() { return null; }\n            }\n        ", (String)"\n            public class A {\n               public org.openrewrite.test.Test foo() { return null; }\n            }\n        ", DefaultImpls::method$lambda$33)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            package org.openrewrite;\n            public class ThingOne {            \n            }\n        ", (String)"\n            package org.openrewrite.test;\n            public class ThingOne {            \n            }\n        "), Assertions.java((String)"\n            package org.openrewrite;\n            public class ThingTwo {\n                public static ThingOne getThingOne() {\n                    return new ThingOne();\n                }\n            }\n        ", (String)"\n            package org.openrewrite.test;\n            public class ThingTwo {\n                public static ThingOne getThingOne() {\n                    return new ThingOne();\n                }\n            }\n        "), Assertions.java((String)"\n            import java.util.List;\n            import org.openrewrite.ThingOne;\n            import org.openrewrite.ThingTwo;\n            public class B {\n                public <T extends org.openrewrite.Test> T generic(T n, List<? super org.openrewrite.Test> in) {\n                    return null;\n                }\n                public void test() {\n                    org.openrewrite.Test.stat();\n                    this.<org.openrewrite.Test>generic(null, null);\n                    ThingOne t1 = ThingTwo.getThingOne();\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            import org.openrewrite.test.ThingOne;\n            import org.openrewrite.test.ThingTwo;\n            public class B {\n                public <T extends org.openrewrite.test.Test> T generic(T n, List<? super org.openrewrite.test.Test> in) {\n                    return null;\n                }\n                public void test() {\n                    org.openrewrite.test.Test.stat();\n                    this.<org.openrewrite.test.Test>generic(null, null);\n                    ThingOne t1 = ThingTwo.getThingOne();\n                }\n            }\n        ", DefaultImpls::methodInvocationTypeParametersAndWildcard$lambda$35)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multiCatch(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            public class B {\n               public void test() {\n                   try {System.out.println();}\n                   catch(org.openrewrite.Test | RuntimeException ignored) {}\n               }\n            }\n        ", (String)"\n            public class B {\n               public void test() {\n                   try {System.out.println();}\n                   catch(org.openrewrite.test.Test | RuntimeException ignored) {}\n               }\n            }\n        ", DefaultImpls::multiCatch$lambda$37)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multiVariable(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            public class B {\n               org.openrewrite.Test f1, f2;\n            }\n        ", (String)"\n            public class B {\n               org.openrewrite.test.Test f1, f2;\n            }\n        ", DefaultImpls::multiVariable$lambda$39)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void assignment(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            public class B {\n               org.openrewrite.Test t;\n               void method(org.openrewrite.Test param) {\n                   t = param;\n               }\n            }\n        ", (String)"\n            public class B {\n               org.openrewrite.test.Test t;\n               void method(org.openrewrite.test.Test param) {\n                   t = param;\n               }\n            }\n        ", DefaultImpls::assignment$lambda$41)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void newClass(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            public class B {\n               org.openrewrite.Test test = new org.openrewrite.Test();\n            }\n        ", (String)"\n            public class B {\n               org.openrewrite.test.Test test = new org.openrewrite.test.Test();\n            }\n        ", DefaultImpls::newClass$lambda$43)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void parameterizedType(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import org.openrewrite.Test;\n            import java.util.Map;\n            public class B {\n               Map<Test, Test> m;\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            import java.util.Map;\n            public class B {\n               Map<Test, Test> m;\n            }\n        ", DefaultImpls::parameterizedType$lambda$45)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void typeCast(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import org.openrewrite.Test;\n            \n            public class A {\n                Test method(Object obj) {\n                    return (Test) obj;\n                }\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                Test method(Object obj) {\n                    return (Test) obj;\n                }\n            }\n        ", DefaultImpls::typeCast$lambda$47)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void classReference(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import org.openrewrite.Test;\n            public class Test {\n                Class<?> clazz = Test.class;\n            }\n        ", (String)"\n            import org.openrewrite.test.Test;\n            public class Test {\n                Class<?> clazz = Test.class;\n            }\n        ", DefaultImpls::classReference$lambda$49)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void methodSelect(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            public class B {\n               org.openrewrite.Test test = null;\n               public void getFoo() { test.foo(); }\n            }\n        ", (String)"\n            public class B {\n               org.openrewrite.test.Test test = null;\n               public void getFoo() { test.foo(); }\n            }\n        ", DefaultImpls::methodSelect$lambda$51)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void staticImport(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)org.openrewrite.java.ChangePackageTest$Companion.testClassBefore, (String)org.openrewrite.java.ChangePackageTest$Companion.testClassAfter), Assertions.java((String)"\n            import static org.openrewrite.Test.stat;\n\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", (String)"\n            import static org.openrewrite.test.Test.stat;\n\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", DefaultImpls::staticImport$lambda$53)};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void changeTypeWithInnerClass(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.acme.product;\n            \n            public class OuterClass {\n                public static class InnerClass {\n            \n                }\n            }\n        ", (String)"\n            package com.acme.product.v2;\n            \n            public class OuterClass {\n                public static class InnerClass {\n            \n                }\n            }\n        "), Assertions.java((String)"\n            package de;\n            \n            import com.acme.product.OuterClass.InnerClass;\n            import com.acme.product.OuterClass;\n            \n            public class UseInnerClass {\n                public String work() {\n                    return new InnerClass().toString();\n                }\n            \n                public String work2() {\n                    return new OuterClass().toString();\n                }\n            }\n        ", (String)"\n            package de;\n\n            import com.acme.product.v2.OuterClass.InnerClass;\n            import com.acme.product.v2.OuterClass;\n            \n            public class UseInnerClass {\n                public String work() {\n                    return new InnerClass().toString();\n                }\n            \n                public String work2() {\n                    return new OuterClass().toString();\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::changeTypeWithInnerClass$lambda$54, sourceSpecsArray);
        }

        @Test
        public static void updateImportPrefixWithEmptyPackage(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            \n            import java.util.List;\n            \n            class Test {\n            }\n        ", (String)"\n            import java.util.List;\n            \n            class Test {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::updateImportPrefixWithEmptyPackage$lambda$55, sourceSpecsArray);
        }

        @Test
        public static void updateClassPrefixWithEmptyPackage(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            \n            class Test {\n            }\n        ", (String)"\n            class Test {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::updateClassPrefixWithEmptyPackage$lambda$56, sourceSpecsArray);
        }

        @Test
        public static void renameSingleSegmentPackage(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package x;\n            \n            class A {\n            }\n        ", (String)"\n            package y;\n            \n            class A {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::renameSingleSegmentPackage$lambda$57, sourceSpecsArray);
        }

        @Test
        public static void removePackage(@NotNull ChangePackageTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package x.y.z;\n            \n            class A {\n            }\n        ", (String)"\n            package x;\n            \n            class A {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::removePackage$lambda$58, sourceSpecsArray);
        }

        @Test
        public static void staticImportEnumSamePackage(@NotNull ChangePackageTest $this) {
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public enum MyEnum {\n                A,\n                B\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            package org.openrewrite;\n            import static org.openrewrite.MyEnum.A;\n            import static org.openrewrite.MyEnum.B;\n            public class App {\n                public void test(String s) {\n                    if (s.equals(\" \" + A + B)) {\n                    }\n                }\n            }\n        ", stringArray2, "\n            package org.openrewrite.test;\n            import static org.openrewrite.test.MyEnum.A;\n            import static org.openrewrite.test.MyEnum.B;\n            public class App {\n                public void test(String s) {\n                    if (s.equals(\" \" + A + B)) {\n                    }\n                }\n            }\n        ", 0, 0, null, staticImportEnumSamePackage.1.INSTANCE, 455, null);
        }

        @Test
        public static void checkValidation(@NotNull ChangePackageTest $this) {
            ChangePackage recipe2 = new ChangePackage(null, null, null);
            Validated valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(2);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newPackageName");
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(1)).getProperty()).isEqualTo("oldPackageName");
            recipe2 = new ChangePackage(null, "java.lang.String", null);
            valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("oldPackageName");
            recipe2 = new ChangePackage("java.lang.String", null, null);
            valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newPackageName");
        }

        @NotNull
        public static JavaParser getParser(@NotNull ChangePackageTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ChangePackageTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ChangePackageTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ChangePackageTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull ChangePackageTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ChangePackageTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangePackageTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangePackageTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ChangePackageTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ChangePackageTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ChangePackageTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ChangePackageTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ChangePackageTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ChangePackageTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }

        private static void renamePackageNonRecursive$lambda$0(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("org.openrewrite", "org.openrewrite.test", Boolean.valueOf(false)));
        }

        private static void renameImport$lambda$2$lambda$1(J.CompilationUnit cu) {
            J.Import imported = (J.Import)cu.getImports().get(0);
            org.assertj.core.api.Assertions.assertThat((String)imported.getPackageName()).isEqualTo("org.openrewrite.test");
        }

        private static void renameImport$lambda$2(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::renameImport$lambda$2$lambda$1);
        }

        private static void typesInUseContainsOneTypeReference$lambda$4$lambda$3(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.getTypesInUse().getTypesInUse()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void typesInUseContainsOneTypeReference$lambda$4(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::typesInUseContainsOneTypeReference$lambda$4$lambda$3);
        }

        private static void typesInUseContainsOneMethodTypeReference$lambda$6$lambda$5(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.getTypesInUse().getUsedMethods()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void typesInUseContainsOneMethodTypeReference$lambda$6(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::typesInUseContainsOneMethodTypeReference$lambda$6$lambda$5);
        }

        private static void updateMethodType$lambda$8$lambda$7(J.CompilationUnit cu) {
            Set set = cu.getTypesInUse().getUsedMethods();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"cu.typesInUse.usedMethods");
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JavaType.Method methodType = thisCollection$iv.toArray(new JavaType.Method[0])[0];
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(methodType.getReturnType());
            Intrinsics.checkNotNull((Object)fullyQualified);
            org.assertj.core.api.Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.test.Test");
            JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified((JavaType)methodType.getParameterTypes().get(0));
            Intrinsics.checkNotNull((Object)fullyQualified2);
            org.assertj.core.api.Assertions.assertThat((String)fullyQualified2.getFullyQualifiedName()).isEqualTo("org.openrewrite.test.Test");
        }

        private static void updateMethodType$lambda$8(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::updateMethodType$lambda$8$lambda$7);
        }

        private static void updateVariableType$lambda$10$lambda$9(J.CompilationUnit cu) {
            Set set = cu.getTypesInUse().getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"cu.typesInUse.variables");
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(thisCollection$iv.toArray(new JavaType.Variable[0])[0].getType());
            Intrinsics.checkNotNull((Object)fullyQualified);
            org.assertj.core.api.Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.test.Test");
        }

        private static void updateVariableType$lambda$10(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::updateVariableType$lambda$10$lambda$9);
        }

        private static void renamePackage$lambda$12$lambda$11(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void renamePackage$lambda$12(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::renamePackage$lambda$12$lambda$11);
        }

        private static void renamePackageRecursive$lambda$14$lambda$13(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Path)cu.getSourcePath()).isEqualTo((Object)Paths.get("org/openrewrite/test/internal/Test.java", new String[0]));
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.internal.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.internal.Test")).isNotEmpty();
        }

        private static void renamePackageRecursive$lambda$14(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::renamePackageRecursive$lambda$14$lambda$13);
        }

        private static void renamePackageRecursiveImported$lambda$15(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("org.openrewrite", "org.openrewrite.test", Boolean.valueOf(true)));
        }

        private static void renamePackageRecursiveImported$lambda$17$lambda$16(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.other.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.other.Test")).isNotEmpty();
        }

        private static void renamePackageRecursiveImported$lambda$17(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::renamePackageRecursiveImported$lambda$17$lambda$16);
        }

        private static void typeParameter$lambda$19$lambda$18(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void typeParameter$lambda$19(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::typeParameter$lambda$19$lambda$18);
        }

        private static void classTypeParameter$lambda$21$lambda$20(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void classTypeParameter$lambda$21(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::classTypeParameter$lambda$21$lambda$20);
        }

        private static void boundedGenericType$lambda$23$lambda$22(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void boundedGenericType$lambda$23(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::boundedGenericType$lambda$23$lambda$22);
        }

        private static void array$lambda$25$lambda$24(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void array$lambda$25(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::array$lambda$25$lambda$24);
        }

        private static void multiDimensionalArray$lambda$27$lambda$26(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void multiDimensionalArray$lambda$27(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::multiDimensionalArray$lambda$27$lambda$26);
        }

        private static void classDecl$lambda$29$lambda$28(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void classDecl$lambda$29(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::classDecl$lambda$29$lambda$28);
        }

        private static void moveToSubPackageRemoveImport$lambda$30(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("com.acme.project", "com.acme.product", null));
        }

        private static void moveToSubPackageDoNotRemoveImport$lambda$31(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("com.acme.project", "com.acme.product", Boolean.valueOf(true)));
        }

        private static void method$lambda$33$lambda$32(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void method$lambda$33(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::method$lambda$33$lambda$32);
        }

        private static void methodInvocationTypeParametersAndWildcard$lambda$35$lambda$34(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void methodInvocationTypeParametersAndWildcard$lambda$35(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::methodInvocationTypeParametersAndWildcard$lambda$35$lambda$34);
        }

        private static void multiCatch$lambda$37$lambda$36(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void multiCatch$lambda$37(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::multiCatch$lambda$37$lambda$36);
        }

        private static void multiVariable$lambda$39$lambda$38(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void multiVariable$lambda$39(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::multiVariable$lambda$39$lambda$38);
        }

        private static void assignment$lambda$41$lambda$40(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void assignment$lambda$41(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::assignment$lambda$41$lambda$40);
        }

        private static void newClass$lambda$43$lambda$42(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void newClass$lambda$43(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::newClass$lambda$43$lambda$42);
        }

        private static void parameterizedType$lambda$45$lambda$44(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void parameterizedType$lambda$45(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::parameterizedType$lambda$45$lambda$44);
        }

        private static void typeCast$lambda$47$lambda$46(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void typeCast$lambda$47(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::typeCast$lambda$47$lambda$46);
        }

        private static void classReference$lambda$49$lambda$48(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void classReference$lambda$49(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::classReference$lambda$49$lambda$48);
        }

        private static void methodSelect$lambda$51$lambda$50(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void methodSelect$lambda$51(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::methodSelect$lambda$51$lambda$50);
        }

        private static void staticImport$lambda$53$lambda$52(J.CompilationUnit cu) {
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.Test")).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Collection)cu.findType("org.openrewrite.test.Test")).isNotEmpty();
        }

        private static void staticImport$lambda$53(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::staticImport$lambda$53$lambda$52);
        }

        private static void changeTypeWithInnerClass$lambda$54(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("com.acme.product", "com.acme.product.v2", null));
        }

        private static void updateImportPrefixWithEmptyPackage$lambda$55(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("a.b", "", Boolean.valueOf(false)));
        }

        private static void updateClassPrefixWithEmptyPackage$lambda$56(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("a.b", "", Boolean.valueOf(false)));
        }

        private static void renameSingleSegmentPackage$lambda$57(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("x", "y", Boolean.valueOf(false)));
        }

        private static void removePackage$lambda$58(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("x.y.z", "x", Boolean.valueOf(false)));
        }
    }
}

