/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.ReplaceDuplicateStringLiterals;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0017\u00a8\u0006\u0019"}, d2={"Lorg/openrewrite/java/cleanup/ReplaceDuplicateStringLiteralsTest;", "Lorg/openrewrite/test/RewriteTest;", "constantAlreadyExists", "", "constantExistsWithInnerClass", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotChangeLiteralsInAnnotations", "doesNotApplyToTest", "doesNotMeetCharacterLimit", "enum", "enumCannotReplaceConstructorArgument", "multiVariableDeclaration", "multipleRedundantValues", "preventNamespaceShadowingOnExistingConstant", "preventNamespaceShadowingOnNewConstant", "preventNamespaceShadowingWithNonStringConstant", "replaceMixedRedundantLiterals", "replaceRedundantFinalStrings", "replaceRedundantLiteralInMethodInvocation", "replaceRedundantLiteralsInNewClass", "testSourcesEnabled", "transformStringValue", "unicodeCharacterEquivalents", "rewrite-java-tck"})
public interface ReplaceDuplicateStringLiteralsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doesNotMeetCharacterLimit();

    @Test
    public void doesNotApplyToTest();

    @Test
    public void testSourcesEnabled();

    @Test
    public void doNotChangeLiteralsInAnnotations();

    @Test
    public void replaceRedundantFinalStrings();

    @Test
    public void replaceRedundantLiteralInMethodInvocation();

    @Test
    public void replaceRedundantLiteralsInNewClass();

    @Test
    public void multipleRedundantValues();

    @Test
    public void transformStringValue();

    @Test
    public void constantAlreadyExists();

    @Test
    public void constantExistsWithInnerClass();

    @Test
    public void preventNamespaceShadowingWithNonStringConstant();

    @Test
    public void preventNamespaceShadowingOnExistingConstant();

    @Test
    public void preventNamespaceShadowingOnNewConstant();

    @Test
    public void multiVariableDeclaration();

    @Test
    public void replaceMixedRedundantLiterals();

    @Test
    public void unicodeCharacterEquivalents();

    @Test
    public void enum();

    @Test
    public void enumCannotReplaceConstructorArgument();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ReplaceDuplicateStringLiterals(Boolean.valueOf(true)));
        }

        @Test
        public static void doesNotMeetCharacterLimit(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                final String val1 = \"val\";\n                final String val2 = \"val\";\n                final String val3 = \"val\";\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doesNotApplyToTest(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[1];
            SourceSpecs[] sourceSpecsArray2 = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    final String val1 = \"value\";\n                    final String val2 = \"value\";\n                    final String val3 = \"value\";\n                }\n            ")};
            sourceSpecsArray[0] = Assertions.srcTestJava((SourceSpecs[])sourceSpecsArray2);
            this_.rewriteRun(DefaultImpls::doesNotApplyToTest$lambda-0, sourceSpecsArray);
        }

        @Test
        public static void testSourcesEnabled(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[1];
            SourceSpecs[] sourceSpecsArray2 = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    final String val1 = \"value\";\n                    final String val2 = \"value\";\n                    final String val3 = \"value\";\n                }\n            ", (String)"\n                class A {\n                    private static final String VALUE = \"value\";\n                    final String val1 = VALUE;\n                    final String val2 = VALUE;\n                    final String val3 = VALUE;\n                }\n            ")};
            sourceSpecsArray[0] = Assertions.srcTestJava((SourceSpecs[])sourceSpecsArray2);
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeLiteralsInAnnotations(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public @interface Example {\n                String value() default \"\";\n            }\n        "), Assertions.java((String)"\n            class A {\n                @Example(value = \"value\")\n                void method1() {}\n                @Example(value = \"value\")\n                void method2() {}\n                @Example(value = \"value\")\n                void method3() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceRedundantFinalStrings(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.foo;\n            class A {\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n            }\n        ", (String)"\n            package org.foo;\n            class A {\n                private static final String VALUE = \"value\";\n                final String val1 = VALUE;\n                final String val2 = VALUE;\n                final String val3 = VALUE;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceRedundantLiteralInMethodInvocation(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                String method(String val) {\n                    return null;\n                }\n                String val1 = method(\"value\");\n                String val2 = method(\"value\");\n                String val3 = method(\"value\");\n            }\n        ", (String)"\n            class A {\n                private static final String VALUE = \"value\";\n                String method(String val) {\n                    return null;\n                }\n                String val1 = method(VALUE);\n                String val2 = method(VALUE);\n                String val3 = method(VALUE);\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceRedundantLiteralsInNewClass(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                void method() {\n                    B b1 = new B(\"value\");\n                    B b2 = new B(\"value\");\n                    B b3 = new B(\"value\");\n                }\n                private static class B {\n                    B(String val) {\n                    }\n                }\n            }\n        ", (String)"\n            class A {\n                private static final String VALUE = \"value\";\n                void method() {\n                    B b1 = new B(VALUE);\n                    B b2 = new B(VALUE);\n                    B b3 = new B(VALUE);\n                }\n                private static class B {\n                    B(String val) {\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multipleRedundantValues(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                final String a1 = \"value a\";\n                final String a2 = \"value a\";\n                final String a3 = \"value a\";\n                final String b1 = \"value b\";\n                final String b2 = \"value b\";\n                final String b3 = \"value b\";\n            }\n        ", (String)"\n            class A {\n                private static final String VALUE_A = \"value a\";\n                private static final String VALUE_B = \"value b\";\n                final String a1 = VALUE_A;\n                final String a2 = VALUE_A;\n                final String a3 = VALUE_A;\n                final String b1 = VALUE_B;\n                final String b2 = VALUE_B;\n                final String b3 = VALUE_B;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void transformStringValue(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                final String val1 = \"An example,, of a :: String with `` special __ characters.\";\n                final String val2 = \"An example,, of a :: String with `` special __ characters.\";\n                final String val3 = \"An example,, of a :: String with `` special __ characters.\";\n            }\n        ", (String)"\n            class A {\n                private static final String AN_EXAMPLE_OF_A_STRING_WITH_SPECIAL_CHARACTERS = \"An example,, of a :: String with `` special __ characters.\";\n                final String val1 = AN_EXAMPLE_OF_A_STRING_WITH_SPECIAL_CHARACTERS;\n                final String val2 = AN_EXAMPLE_OF_A_STRING_WITH_SPECIAL_CHARACTERS;\n                final String val3 = AN_EXAMPLE_OF_A_STRING_WITH_SPECIAL_CHARACTERS;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void constantAlreadyExists(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                private static final String CONSTANT = \"value\";\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n            }\n        ", (String)"\n            class A {\n                private static final String CONSTANT = \"value\";\n                final String val1 = CONSTANT;\n                final String val2 = CONSTANT;\n                final String val3 = CONSTANT;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void constantExistsWithInnerClass(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                private static final String CONSTANT = \"value\";\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n                \n                private static class B {\n                    // Do not change inner class value.\n                    private static final String CONSTANT = \"value\";\n                }\n            }\n        ", (String)"\n            class A {\n                private static final String CONSTANT = \"value\";\n                final String val1 = CONSTANT;\n                final String val2 = CONSTANT;\n                final String val3 = CONSTANT;\n                \n                private static class B {\n                    // Do not change inner class value.\n                    private static final String CONSTANT = \"value\";\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void preventNamespaceShadowingWithNonStringConstant(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.foo;\n            class A {\n                private static final int VALUE = 1;\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n            }\n        ", (String)"\n            package org.foo;\n            class A {\n                private static final String VALUE_1 = \"value\";\n                private static final int VALUE = 1;\n                final String val1 = VALUE_1;\n                final String val2 = VALUE_1;\n                final String val3 = VALUE_1;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void preventNamespaceShadowingOnExistingConstant(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                // Change field name to prevent potential namespace conflicts.\n                private static final String VALUE = \"value\";\n                void newScope() {\n                    final String VALUE = \"name already exists\";\n                    final String val1 = \"value\";\n                    final String val2 = \"value\";\n                    final String val3 = \"value\";\n                }\n                void method() {\n                    // Change existing method reference.\n                    String valueRef = VALUE;\n                }\n                private static class B {\n                    // Change existing inner class reference.\n                    String innerClass = VALUE;\n                }\n            }\n        ", (String)"\n            class A {\n                // Change field name to prevent potential namespace conflicts.\n                private static final String VALUE_1 = \"value\";\n                void newScope() {\n                    final String VALUE = \"name already exists\";\n                    final String val1 = VALUE_1;\n                    final String val2 = VALUE_1;\n                    final String val3 = VALUE_1;\n                }\n                void method() {\n                    // Change existing method reference.\n                    String valueRef = VALUE_1;\n                }\n                private static class B {\n                    // Change existing inner class reference.\n                    String innerClass = VALUE_1;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void preventNamespaceShadowingOnNewConstant(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n                final String VALUE = \"name space conflict\";\n            }\n        ", (String)"\n            class A {\n                private static final String VALUE_1 = \"value\";\n                final String val1 = VALUE_1;\n                final String val2 = VALUE_1;\n                final String val3 = VALUE_1;\n                final String VALUE = \"name space conflict\";\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multiVariableDeclaration(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                final String val1 = \"value\", val2 = \"value\", diff = \"here\";\n                final String val3 = \"value\";\n                final String VALUE = \"name space conflict\";\n            }\n        ", (String)"\n            class A {\n                private static final String VALUE_1 = \"value\";\n                final String val1 = VALUE_1, val2 = VALUE_1, diff = \"here\";\n                final String val3 = VALUE_1;\n                final String VALUE = \"name space conflict\";\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceMixedRedundantLiterals(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                final String val1 = \"value\";\n                void methodA() {\n                    methodB(\"value\");\n                }\n                void methodB(String val) {\n                    B b = new B(\"value\");\n                }\n                private static class B {\n                    B(String val) {\n                    }\n                }\n            }\n        ", (String)"\n            class A {\n                private static final String VALUE = \"value\";\n                final String val1 = VALUE;\n                void methodA() {\n                    methodB(VALUE);\n                }\n                void methodB(String val) {\n                    B b = new B(VALUE);\n                }\n                private static class B {\n                    B(String val) {\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void unicodeCharacterEquivalents(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                final String val1 = \"\u0101\u0103\u0105\u0113\u00ee\u00ef\u0129\u00ed\u011d\u0121\u0144\u00f1\u0161\u015d\u015b\u00fb\u016f\u0177\";\n                final String val2 = \"\u0101\u0103\u0105\u0113\u00ee\u00ef\u0129\u00ed\u011d\u0121\u0144\u00f1\u0161\u015d\u015b\u00fb\u016f\u0177\";\n                final String val3 = \"\u0101\u0103\u0105\u0113\u00ee\u00ef\u0129\u00ed\u011d\u0121\u0144\u00f1\u0161\u015d\u015b\u00fb\u016f\u0177\";\n            }\n        ", (String)"\n            class A {\n                private static final String AAAEIIIIGGNNSSSUUY = \"\u0101\u0103\u0105\u0113\u00ee\u00ef\u0129\u00ed\u011d\u0121\u0144\u00f1\u0161\u015d\u015b\u00fb\u016f\u0177\";\n                final String val1 = AAAEIIIIGGNNSSSUUY;\n                final String val2 = AAAEIIIIGGNNSSSUUY;\n                final String val3 = AAAEIIIIGGNNSSSUUY;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void enum(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            enum A {\n                /**/\n                ONE, TWO, THREE;\n                \n                public void example() {\n                    final String val1 = \"value\";\n                    final String val2 = \"value\";\n                    final String val3 = \"value\";\n                }\n                \n                public void bar() {}\n            }\n        ", (String)"\n            enum A {\n                /**/\n                ONE, TWO, THREE;\n                private static final String VALUE = \"value\";\n                \n                public void example() {\n                    final String val1 = VALUE;\n                    final String val2 = VALUE;\n                    final String val3 = VALUE;\n                }\n                \n                public void bar() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void enumCannotReplaceConstructorArgument(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            enum Scratch {\n                A(\"value\"),\n                B(\"value\"),\n                C(\"value\");\n                Scratch(String s) {\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        private static void doesNotApplyToTest$lambda-0(RecipeSpec spec) {
            spec.recipe((Recipe)new ReplaceDuplicateStringLiterals(Boolean.valueOf(false)));
        }
    }
}

