/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.RenamePrivateFieldsToCamelCase;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017\u00a8\u0006\u0016"}, d2={"Lorg/openrewrite/java/cleanup/RenamePrivateFieldsToCamelCaseTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotChangeExistsInOnlyOneMethod", "doNotChangeIfToNameExists", "doNotChangeInheritedFields", "doNotChangeStaticImports", "doNotChangeWhenSameMethodParam", "doNotRenameAnonymousInnerClasses", "doNotRenameInnerClassesMembers", "doesNotRenameAssociatedIdentifiers", "handleStaticMethods", "nameConflict", "renameFinalMembers", "renamePrivateMembers", "renameUsageInInnerClasses", "renameWhenSameMethodExists", "renameWithFieldAccess", "upperSnakeToLowerCamel", "rewrite-java-tck"})
public interface RenamePrivateFieldsToCamelCaseTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void upperSnakeToLowerCamel();

    @Test
    public void nameConflict();

    @Test
    public void doesNotRenameAssociatedIdentifiers();

    @Test
    public void doNotChangeStaticImports();

    @Test
    public void doNotChangeInheritedFields();

    @Test
    public void doNotChangeIfToNameExists();

    @Test
    public void doNotChangeExistsInOnlyOneMethod();

    @Test
    public void renamePrivateMembers();

    @Test
    public void renameWithFieldAccess();

    @Test
    public void doNotRenameInnerClassesMembers();

    @Test
    public void renameUsageInInnerClasses();

    @Test
    public void doNotRenameAnonymousInnerClasses();

    @Test
    public void handleStaticMethods();

    @Test
    public void renameFinalMembers();

    @Test
    public void doNotChangeWhenSameMethodParam();

    @Test
    public void renameWhenSameMethodExists();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull RenamePrivateFieldsToCamelCaseTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new RenamePrivateFieldsToCamelCase());
        }

        @Test
        public static void upperSnakeToLowerCamel(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private String D_TYPE_CONNECT = \"\";\n            }\n        ", (String)"\n            class Test {\n                private String dTypeConnect = \"\";\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void nameConflict(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                private final String _val = \"\";\n                private void a() {\n                    if (true) {\n                        Thread t = new Thread(){\n                            public void run() {\n                                String val = _val;\n                            }\n                        };\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doesNotRenameAssociatedIdentifiers(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                private static String MY_STRING = \"VAR\";\n                void doSomething() {\n                    MY_STRING.toLowerCase();\n                    AB.INNER_STRING.toLowerCase();\n                }\n            \n                private static class AB {\n                    private static String INNER_STRING = \"var\";\n                    void doSomething() {\n                        MY_STRING.toLowerCase();\n                    }\n                }\n            }\n        ", (String)"\n            class A {\n                private static String myString = \"VAR\";\n                void doSomething() {\n                    myString.toLowerCase();\n                    AB.INNER_STRING.toLowerCase();\n                }\n            \n                private static class AB {\n                    private static String INNER_STRING = \"var\";\n                    void doSomething() {\n                        myString.toLowerCase();\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeStaticImports(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class B {\n                public static int _staticImport_ = 0;\n            }\n        "), Assertions.java((String)"\n            import static B._staticImport_;\n\n            class Test {\n                private int member = _staticImport_;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeInheritedFields(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                public int _inheritedField_ = 0;\n            }\n        "), Assertions.java((String)"\n            class Test extends A {\n                private int _inheritedField_ = super._inheritedField_;\n            }\n        ", (String)"\n            class Test extends A {\n                private int inheritedField = super._inheritedField_;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeIfToNameExists(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int test_value;\n\n                public int addTen(int testValue) {\n                    return test_value + testValue;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeExistsInOnlyOneMethod(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private int DoNoTChange;\n                \n                public int addTwenty(String doNoTChange) {\n                    return DoNoTChange + 20;\n                }\n                public int addTen(String value) {\n                    return DoNoTChange + 10;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renamePrivateMembers(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private int DoChange = 10;\n                public int DoNotChangePublicMember;\n                int DoNotChangeDefaultMember;\n\n                public int getTen() {\n                    return DoChange;\n                }\n\n                public int getTwenty() {\n                    return this.DoChange * 2;\n                }\n\n                public int getThirty() {\n                    return DoChange * 3;\n                }\n            }\n        ", (String)"\n            class Test {\n                private int doChange = 10;\n                public int DoNotChangePublicMember;\n                int DoNotChangeDefaultMember;\n\n                public int getTen() {\n                    return doChange;\n                }\n\n                public int getTwenty() {\n                    return this.doChange * 2;\n                }\n\n                public int getThirty() {\n                    return doChange * 3;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameWithFieldAccess(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class ClassWithPublicField {\n                public int publicField = 10;\n            }\n        "), Assertions.java((String)"\n            class Test {\n                private ClassWithPublicField DoChange = new ClassWithPublicField();\n\n                public int getTen() {\n                    return DoChange.publicField;\n                }\n            }\n        ", (String)"\n            class Test {\n                private ClassWithPublicField doChange = new ClassWithPublicField();\n\n                public int getTen() {\n                    return doChange.publicField;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotRenameInnerClassesMembers(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private int test = new InnerClass().DoNotChange + new InnerClass().DoNotChange2;\n                \n                private class InnerClass{\n                    public int DoNotChange = 10;\n                    private int DoNotChange2 = 10;\n                }\n            }\n       ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameUsageInInnerClasses(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private int DoChange = 10;\n                \n                private class InnerClass{\n                    private int test = DoChange + 1;\n                }\n            }\n        ", (String)"\n            class Test {\n                private int doChange = 10;\n                \n                private class InnerClass{\n                    private int test = doChange + 1;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotRenameAnonymousInnerClasses(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                interface Book{}\n            "), Assertions.java((String)"\n                class B {\n                    B(){\n                        new Book() {\n                          private String DoChange;\n\n                          @Override\n                          public String toString() {\n                            return DoChange;\n                          }\n                        };\n                    }\n                }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void handleStaticMethods(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    private int _variable;\n                    public static A getInstance(){\n                        A a = new A();\n                        a._variable = 12;\n                        return a;\n                    }\n                }\n        ", (String)"\n                class A {\n                    private int variable;\n                    public static A getInstance(){\n                        A a = new A();\n                        a.variable = 12;\n                        return a;\n                    }\n                }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameFinalMembers(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    private final int _final_variable;\n                    private static int _static_variable;\n                    private static final int DO_NOT_CHANGE;\n                }\n        ", (String)"\n                class A {\n                    private final int finalVariable;\n                    private static int staticVariable;\n                    private static final int DO_NOT_CHANGE;\n                }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeWhenSameMethodParam(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    private int _variable;\n                    public void getInstance(int _variable) {\n                        this._variable = _variable;\n                    }\n                }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameWhenSameMethodExists(@NotNull RenamePrivateFieldsToCamelCaseTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    private boolean _hasMethod;\n                    public boolean hasMethod() {\n                        return _hasMethod;\n                    }\n                }\n        ", (String)"\n                class A {\n                    private boolean hasMethod;\n                    public boolean hasMethod() {\n                        return hasMethod;\n                    }\n                }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

