/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.RenameJavaDocParamNameVisitor;
import org.openrewrite.java.cleanup.RenameJavaDocParamNameVisitorTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/cleanup/RenameJavaDocParamNameVisitorTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "noJavaDocParamMatch", "renameParamName", "rewrite-java-tck"})
public interface RenameJavaDocParamNameVisitorTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void noJavaDocParamMatch();

    @Test
    public void renameParamName();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull RenameJavaDocParamNameVisitorTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::defaults$lambda-0));
        }

        @Test
        public static void noJavaDocParamMatch(@NotNull RenameJavaDocParamNameVisitorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 * @param noMatch\n                 */\n                void method(String oldName) {\n                }\n            }\n          ", (String)"\n            class Test {\n                /**\n                 * @param noMatch\n                 */\n                void method(String newName) {\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameParamName(@NotNull RenameJavaDocParamNameVisitorTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 * @param oldName\n                 */\n                void method(String oldName) {\n                }\n            }\n          ", (String)"\n            class Test {\n                /**\n                 * @param newName\n                 */\n                void method(String newName) {\n                }\n            }\n          ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        private static TreeVisitor defaults$lambda-0() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodDeclaration md = method2;
                    if (Intrinsics.areEqual((Object)"method", (Object)md.getName().getSimpleName()) && md.getParameters().stream().anyMatch(defaults.1.1::visitMethodDeclaration$lambda-1)) {
                        J.MethodDeclaration methodDeclaration2 = new RenameJavaDocParamNameVisitor(md, "oldName", "newName").visitMethodDeclaration(md, (Object)p);
                        Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"RenameJavaDocParamNameVi\u2026tMethodDeclaration(md, p)");
                        md = methodDeclaration2;
                    }
                    J.MethodDeclaration methodDeclaration3 = super.visitMethodDeclaration(md, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration3, (String)"super.visitMethodDeclaration(md, p)");
                    return methodDeclaration3;
                }

                @NotNull
                public J.VariableDeclarations.NamedVariable visitVariable(@NotNull J.VariableDeclarations.NamedVariable variable, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)p);
                    if (Intrinsics.areEqual((Object)"oldName", (Object)variable.getSimpleName())) {
                        v = v.withName(v.getName().withSimpleName("newName"));
                    }
                    J.VariableDeclarations.NamedVariable namedVariable = v;
                    Intrinsics.checkNotNullExpressionValue((Object)namedVariable, (String)"v");
                    return namedVariable;
                }

                private static final boolean visitMethodDeclaration$lambda-1$lambda-0(J.VariableDeclarations.NamedVariable it2) {
                    return Intrinsics.areEqual((Object)"oldName", (Object)it2.getName().getSimpleName());
                }

                private static final boolean visitMethodDeclaration$lambda-1(Statement it) {
                    return it instanceof J.VariableDeclarations && ((J.VariableDeclarations)it).getVariables().stream().anyMatch(defaults.1.1::visitMethodDeclaration$lambda-1$lambda-0);
                }
            };
        }
    }
}

