/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0017J\b\u0010\u001a\u001a\u00020\u0003H\u0017J\b\u0010\u001b\u001a\u00020\u0003H\u0017J\b\u0010\u001c\u001a\u00020\u0003H\u0017J\b\u0010\u001d\u001a\u00020\u0003H\u0017J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\u0003H\u0017J\b\u0010!\u001a\u00020\u0003H\u0017J\b\u0010\"\u001a\u00020\u0003H\u0017\u00a8\u0006#"}, d2={"Lorg/openrewrite/java/JavaTypeMappingTest;", "", "array", "", "className", "classType", "Lorg/openrewrite/java/tree/JavaType$FullyQualified;", "fqn", "", "constructor", "enumTypeA", "enumTypeB", "extendsJavaLangObject", "firstMethodParameter", "Lorg/openrewrite/java/tree/JavaType;", "methodName", "generic", "genericArray", "genericContravariant", "genericIntersectionType", "genericMultipleBounds", "genericRecursive", "genericUnbounded", "goatType", "Lorg/openrewrite/java/tree/JavaType$Parameterized;", "ignoreSourceRetentionAnnotations", "inheritedJavaTypeGoat", "innerClass", "interfacesContainImplicitAbstractFlag", "javaLangObjectHasNoSupertype", "methodType", "Lorg/openrewrite/java/tree/JavaType$Method;", "parameterized", "primitive", "recursiveIntersection", "rewrite-java-tck"})
public interface JavaTypeMappingTest {
    @NotNull
    public JavaType.FullyQualified classType(@NotNull String var1);

    @NotNull
    public JavaType.Parameterized goatType();

    @NotNull
    public JavaType.Method methodType(@NotNull String var1);

    @NotNull
    public JavaType firstMethodParameter(@NotNull String var1);

    @Test
    public void javaLangObjectHasNoSupertype();

    @Test
    public void interfacesContainImplicitAbstractFlag();

    @Test
    public void extendsJavaLangObject();

    @Test
    public void constructor();

    @Test
    public void array();

    @Test
    public void className();

    @Test
    public void primitive();

    @Test
    public void parameterized();

    @Test
    public void generic();

    @Test
    public void genericContravariant();

    @Test
    public void genericMultipleBounds();

    @Test
    public void genericUnbounded();

    @Test
    public void genericRecursive();

    @Test
    public void genericArray();

    @Test
    public void innerClass();

    @Test
    public void inheritedJavaTypeGoat();

    @Test
    public void genericIntersectionType();

    @Test
    public void enumTypeA();

    @Test
    public void enumTypeB();

    @Test
    public void ignoreSourceRetentionAnnotations();

    @Test
    public void recursiveIntersection();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static JavaType.Parameterized goatType(@NotNull JavaTypeMappingTest this_) {
            JavaType.Parameterized parameterized = TestKt.asParameterized((JavaType)this_.classType("org.openrewrite.java.JavaTypeGoat"));
            Intrinsics.checkNotNull((Object)parameterized);
            return parameterized;
        }

        @NotNull
        public static JavaType.Method methodType(@NotNull JavaTypeMappingTest this_, @NotNull String methodName) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                List list = this_.goatType().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"goatType().methods");
                Iterable iterable = list;
                for (Object t : iterable) {
                    JavaType.Method it = (JavaType.Method)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)methodName)) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            Intrinsics.checkNotNull(v1);
            JavaType.Method type = v1;
            Assertions.assertThat((String)type.getDeclaringType().toString()).isEqualTo("org.openrewrite.java.JavaTypeGoat");
            return type;
        }

        @NotNull
        public static JavaType firstMethodParameter(@NotNull JavaTypeMappingTest this_, @NotNull String methodName) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Object e = this_.methodType(methodName).getParameterTypes().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"methodType(methodName).parameterTypes[0]");
            return (JavaType)e;
        }

        @Test
        public static void javaLangObjectHasNoSupertype(@NotNull JavaTypeMappingTest this_) {
            Assertions.assertThat((Object)this_.goatType().getSupertype().getSupertype()).isNull();
        }

        @Test
        public static void interfacesContainImplicitAbstractFlag(@NotNull JavaTypeMappingTest this_) {
            JavaType.Class clazz = (JavaType.Class)this_.firstMethodParameter("clazz");
            JavaType.Method methodType = this_.methodType("clazz");
            Assertions.assertThat((boolean)clazz.getFlags().contains(Flag.Abstract));
            Assertions.assertThat((boolean)methodType.getFlags().contains(Flag.Abstract));
        }

        @Test
        public static void extendsJavaLangObject(@NotNull JavaTypeMappingTest this_) {
            Assertions.assertThat((String)this_.goatType().getSupertype().getFullyQualifiedName()).isEqualTo("java.lang.Object");
        }

        @Test
        public static void constructor(@NotNull JavaTypeMappingTest this_) {
            JavaType.Method ctor = this_.methodType("<constructor>");
            Assertions.assertThat((String)ctor.getDeclaringType().getFullyQualifiedName()).isEqualTo("org.openrewrite.java.JavaTypeGoat");
        }

        @Test
        public static void array(@NotNull JavaTypeMappingTest this_) {
            JavaType.Array arr = (JavaType.Array)this_.firstMethodParameter("array");
            Assertions.assertThat((Object)TestKt.asArray(arr.getElemType())).isNotNull();
            JavaType.Array array2 = TestKt.asArray(arr.getElemType());
            Intrinsics.checkNotNull((Object)array2);
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(array2.getElemType());
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
        }

        @Test
        public static void className(@NotNull JavaTypeMappingTest this_) {
            JavaType.Class clazz = (JavaType.Class)this_.firstMethodParameter("clazz");
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified((JavaType)clazz);
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
        }

        @Test
        public static void primitive(@NotNull JavaTypeMappingTest this_) {
            JavaType.Primitive primitive = (JavaType.Primitive)this_.firstMethodParameter("primitive");
            Assertions.assertThat((Comparable)((Comparable)primitive)).isSameAs((Object)JavaType.Primitive.Int);
        }

        @Test
        public static void parameterized(@NotNull JavaTypeMappingTest this_) {
            JavaType.Parameterized parameterized = (JavaType.Parameterized)this_.firstMethodParameter("parameterized");
            Assertions.assertThat((String)parameterized.getType().getFullyQualifiedName()).isEqualTo("org.openrewrite.java.PT");
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified((JavaType)parameterized.getTypeParameters().get(0));
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
        }

        @Test
        public static void generic(@NotNull JavaTypeMappingTest this_) {
            JavaType.Parameterized parameterized = TestKt.asParameterized(this_.firstMethodParameter("generic"));
            Intrinsics.checkNotNull((Object)parameterized);
            Object e = parameterized.getTypeParameters().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            }
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)e;
            Assertions.assertThat((String)generic.getName()).isEqualTo("?");
            Assertions.assertThat((Comparable)((Comparable)generic.getVariance())).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.COVARIANT);
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified((JavaType)generic.getBounds().get(0));
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
        }

        @Test
        public static void genericContravariant(@NotNull JavaTypeMappingTest this_) {
            JavaType.Parameterized parameterized = TestKt.asParameterized(this_.firstMethodParameter("genericContravariant"));
            Intrinsics.checkNotNull((Object)parameterized);
            Object e = parameterized.getTypeParameters().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            }
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)e;
            Assertions.assertThat((String)generic.getName()).isEqualTo("?");
            Assertions.assertThat((Comparable)((Comparable)generic.getVariance())).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.CONTRAVARIANT);
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified((JavaType)generic.getBounds().get(0));
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
        }

        @Test
        public static void genericMultipleBounds(@NotNull JavaTypeMappingTest this_) {
            List list = this_.goatType().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"goatType().typeParameters");
            JavaType.GenericTypeVariable genericTypeVariable = TestKt.asGeneric((JavaType)CollectionsKt.last((List)list));
            Intrinsics.checkNotNull((Object)genericTypeVariable);
            JavaType.GenericTypeVariable generic = genericTypeVariable;
            Assertions.assertThat((String)generic.getName()).isEqualTo("S");
            Assertions.assertThat((Comparable)((Comparable)generic.getVariance())).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.COVARIANT);
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified((JavaType)generic.getBounds().get(0));
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.PT");
            JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified((JavaType)generic.getBounds().get(1));
            Intrinsics.checkNotNull((Object)fullyQualified2);
            Assertions.assertThat((String)fullyQualified2.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
        }

        @Test
        public static void genericUnbounded(@NotNull JavaTypeMappingTest this_) {
            JavaType.Parameterized parameterized = TestKt.asParameterized(this_.firstMethodParameter("genericUnbounded"));
            Intrinsics.checkNotNull((Object)parameterized);
            Object e = parameterized.getTypeParameters().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            }
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)e;
            Assertions.assertThat((String)generic.getName()).isEqualTo("U");
            Assertions.assertThat((Comparable)((Comparable)generic.getVariance())).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.INVARIANT);
            Assertions.assertThat((List)generic.getBounds()).isEmpty();
        }

        @Test
        public static void genericRecursive(@NotNull JavaTypeMappingTest this_) {
            JavaType typeParam;
            JavaType param = this_.firstMethodParameter("genericRecursive");
            JavaType.Parameterized parameterized = TestKt.asParameterized(param);
            Intrinsics.checkNotNull((Object)parameterized);
            JavaType javaType = typeParam = (JavaType)parameterized.getTypeParameters().get(0);
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            }
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)javaType;
            Assertions.assertThat((String)generic.getName()).isEqualTo("?");
            Assertions.assertThat((Comparable)((Comparable)generic.getVariance())).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.COVARIANT);
            Assertions.assertThat((Object)TestKt.asArray((JavaType)generic.getBounds().get(0))).isNotNull();
            JavaType.Array array2 = TestKt.asArray((JavaType)generic.getBounds().get(0));
            Intrinsics.checkNotNull((Object)array2);
            JavaType.GenericTypeVariable genericTypeVariable = TestKt.asGeneric(array2.getElemType());
            Intrinsics.checkNotNull((Object)genericTypeVariable);
            JavaType.GenericTypeVariable elemType = genericTypeVariable;
            Assertions.assertThat((String)elemType.getName()).isEqualTo("U");
            Assertions.assertThat((Comparable)((Comparable)elemType.getVariance())).isEqualTo((Object)JavaType.GenericTypeVariable.Variance.COVARIANT);
            Assertions.assertThat((List)elemType.getBounds()).hasSize(1);
        }

        @Test
        public static void genericArray(@NotNull JavaTypeMappingTest this_) {
            JavaType param = this_.firstMethodParameter("genericArray");
            JavaType.Array arr = (JavaType.Array)param;
            JavaType.Parameterized parameterized = TestKt.asParameterized(arr.getElemType());
            Assertions.assertThat((Object)parameterized).isNotNull();
            JavaType.Parameterized parameterized2 = parameterized;
            Intrinsics.checkNotNull((Object)parameterized2);
            Assertions.assertThat((String)parameterized2.getType().getFullyQualifiedName()).isEqualTo("org.openrewrite.java.PT");
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified((JavaType)parameterized.getTypeParameters().get(0));
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C");
        }

        @Test
        public static void innerClass(@NotNull JavaTypeMappingTest this_) {
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(this_.firstMethodParameter("inner"));
            Intrinsics.checkNotNull((Object)fullyQualified);
            JavaType.FullyQualified clazz = fullyQualified;
            Assertions.assertThat((String)clazz.getFullyQualifiedName()).isEqualTo("org.openrewrite.java.C$Inner");
        }

        @Test
        public static void inheritedJavaTypeGoat(@NotNull JavaTypeMappingTest this_) {
            JavaType.Parameterized clazz = (JavaType.Parameterized)this_.firstMethodParameter("inheritedJavaTypeGoat");
            Assertions.assertThat((String)clazz.getTypeParameters().get(0).toString()).isEqualTo("Generic{T}");
            Assertions.assertThat((String)clazz.getTypeParameters().get(1).toString()).isEqualTo("Generic{U extends org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}");
            Assertions.assertThat((String)clazz.toString()).isEqualTo("org.openrewrite.java.JavaTypeGoat$InheritedJavaTypeGoat<Generic{T}, Generic{U extends org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}>");
        }

        @Test
        public static void genericIntersectionType(@NotNull JavaTypeMappingTest this_) {
            JavaType.GenericTypeVariable clazz = (JavaType.GenericTypeVariable)this_.firstMethodParameter("genericIntersection");
            Assertions.assertThat((String)clazz.getBounds().get(0).toString()).isEqualTo("org.openrewrite.java.JavaTypeGoat$TypeA");
            Assertions.assertThat((String)clazz.getBounds().get(1).toString()).isEqualTo("org.openrewrite.java.PT<Generic{U extends org.openrewrite.java.JavaTypeGoat$TypeA & org.openrewrite.java.C}>");
            Assertions.assertThat((String)clazz.getBounds().get(2).toString()).isEqualTo("org.openrewrite.java.C");
            Assertions.assertThat((String)clazz.toString()).isEqualTo("Generic{U extends org.openrewrite.java.JavaTypeGoat$TypeA & org.openrewrite.java.PT<Generic{U}> & org.openrewrite.java.C}");
        }

        @Test
        public static void enumTypeA(@NotNull JavaTypeMappingTest this_) {
            Object v1;
            JavaType.Class clazz;
            block1: {
                clazz = (JavaType.Class)this_.firstMethodParameter("enumTypeA");
                List list = clazz.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"clazz.methods");
                Iterable iterable = list;
                for (Object t : iterable) {
                    JavaType.Method it = (JavaType.Method)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"<constructor>")) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            JavaType.Method type = v1;
            Assertions.assertThat((String)String.valueOf(type)).isEqualTo("org.openrewrite.java.JavaTypeGoat$EnumTypeA{name=<constructor>,return=org.openrewrite.java.JavaTypeGoat$EnumTypeA,parameters=[]}");
            JavaType.FullyQualified supertype = clazz.getSupertype();
            Assertions.assertThat((Object)supertype).isNotNull();
            JavaType.FullyQualified fullyQualified = supertype;
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.toString()).isEqualTo("java.lang.Enum<org.openrewrite.java.JavaTypeGoat$EnumTypeA>");
        }

        @Test
        public static void enumTypeB(@NotNull JavaTypeMappingTest this_) {
            Object v1;
            JavaType.Class clazz;
            block1: {
                clazz = (JavaType.Class)this_.firstMethodParameter("enumTypeB");
                List list = clazz.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"clazz.methods");
                Iterable iterable = list;
                for (Object t : iterable) {
                    JavaType.Method it = (JavaType.Method)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"<constructor>")) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            JavaType.Method type = v1;
            Assertions.assertThat((String)String.valueOf(type)).isEqualTo("org.openrewrite.java.JavaTypeGoat$EnumTypeB{name=<constructor>,return=org.openrewrite.java.JavaTypeGoat$EnumTypeB,parameters=[org.openrewrite.java.JavaTypeGoat$TypeA]}");
            JavaType.FullyQualified supertype = clazz.getSupertype();
            Assertions.assertThat((Object)supertype).isNotNull();
            JavaType.FullyQualified fullyQualified = supertype;
            Intrinsics.checkNotNull((Object)fullyQualified);
            Assertions.assertThat((String)fullyQualified.toString()).isEqualTo("java.lang.Enum<org.openrewrite.java.JavaTypeGoat$EnumTypeB>");
        }

        @Test
        public static void ignoreSourceRetentionAnnotations(@NotNull JavaTypeMappingTest this_) {
            JavaType.Parameterized goat = this_.goatType();
            Assertions.assertThat((goat.getAnnotations().size() == 1 ? 1 : 0) != 0);
            List list = goat.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"goat.annotations");
            Assertions.assertThat((boolean)Intrinsics.areEqual((Object)((JavaType.FullyQualified)CollectionsKt.first((List)list)).getClassName(), (Object)"AnnotationWithRuntimeRetention"));
            JavaType.Method clazzMethod = this_.methodType("clazz");
            Assertions.assertThat((clazzMethod.getAnnotations().size() == 1 ? 1 : 0) != 0);
            List list2 = clazzMethod.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"clazzMethod.annotations");
            Assertions.assertThat((boolean)Intrinsics.areEqual((Object)((JavaType.FullyQualified)CollectionsKt.first((List)list2)).getClassName(), (Object)"AnnotationWithRuntimeRetention"));
        }

        @Test
        public static void recursiveIntersection(@NotNull JavaTypeMappingTest this_) {
            JavaType.GenericTypeVariable clazz = (JavaType.GenericTypeVariable)this_.firstMethodParameter("recursiveIntersection");
            Assertions.assertThat((String)clazz.toString()).isEqualTo("Generic{U extends org.openrewrite.java.JavaTypeGoat$Extension<Generic{U}> & org.openrewrite.java.Intersection<Generic{U}>}");
        }
    }
}

