/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.ReplaceDuplicateStringLiterals;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\bf\u0018\u00002\u00020\u0001J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\rH\u0017J\b\u0010\u000f\u001a\u00020\rH\u0017J\b\u0010\u0010\u001a\u00020\rH\u0017J\b\u0010\u0011\u001a\u00020\rH\u0017J\b\u0010\u0012\u001a\u00020\rH\u0017J\b\u0010\u0013\u001a\u00020\rH\u0017J\b\u0010\u0014\u001a\u00020\rH\u0017J\b\u0010\u0015\u001a\u00020\rH\u0017J\b\u0010\u0016\u001a\u00020\rH\u0017J\b\u0010\u0017\u001a\u00020\rH\u0017J\b\u0010\u0018\u001a\u00020\rH\u0017J\b\u0010\u0019\u001a\u00020\rH\u0017J\b\u0010\u001a\u001a\u00020\rH\u0017J\b\u0010\u001b\u001a\u00020\rH\u0017J\b\u0010\u001c\u001a\u00020\rH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\u00a8\u0006\u001d"}, d2={"Lorg/openrewrite/java/cleanup/ReplaceDuplicateStringLiteralsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "parser", "Lorg/openrewrite/java/JavaParser;", "getParser", "()Lorg/openrewrite/java/JavaParser;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "testParser", "getTestParser", "constantAlreadyExists", "", "constantExistsWithInnerClass", "doNotChangeLiteralsInAnnotations", "doesNotApplyToTest", "doesNotMeetCharacterLimit", "multiVariableDeclaration", "multipleRedundantValues", "preventNamespaceShadowingOnExistingConstant", "preventNamespaceShadowingOnNewConstant", "preventNamespaceShadowingWithNonStringConstant", "replaceMixedRedundantLiterals", "replaceRedundantFinalStrings", "replaceRedundantLiteralInMethodInvocation", "replaceRedundantLiteralsInNewClass", "testSourcesEnabled", "transformStringValue", "rewrite-java-tck"})
public interface ReplaceDuplicateStringLiteralsTest
extends JavaRecipeTest {
    @Nullable
    public Recipe getRecipe();

    @Override
    @NotNull
    public JavaParser getParser();

    @NotNull
    public JavaParser getTestParser();

    @Test
    public void doesNotMeetCharacterLimit();

    @Test
    public void doesNotApplyToTest();

    @Test
    public void testSourcesEnabled();

    @Test
    public void doNotChangeLiteralsInAnnotations();

    @Test
    public void replaceRedundantFinalStrings();

    @Test
    public void replaceRedundantLiteralInMethodInvocation();

    @Test
    public void replaceRedundantLiteralsInNewClass();

    @Test
    public void multipleRedundantValues();

    @Test
    public void transformStringValue();

    @Test
    public void constantAlreadyExists();

    @Test
    public void constantExistsWithInnerClass();

    @Test
    public void preventNamespaceShadowingWithNonStringConstant();

    @Test
    public void preventNamespaceShadowingOnExistingConstant();

    @Test
    public void preventNamespaceShadowingOnNewConstant();

    @Test
    public void multiVariableDeclaration();

    @Test
    public void replaceMixedRedundantLiterals();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            return (Recipe)new ReplaceDuplicateStringLiterals(Boolean.valueOf(false));
        }

        @NotNull
        public static JavaParser getParser(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaParser jp = JavaParser.fromJavaVersion().build();
            jp.setSourceSet("main");
            Intrinsics.checkNotNullExpressionValue((Object)jp, (String)"jp");
            return jp;
        }

        @NotNull
        public static JavaParser getTestParser(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaParser jp = JavaParser.fromJavaVersion().build();
            jp.setSourceSet("test");
            Intrinsics.checkNotNullExpressionValue((Object)jp, (String)"jp");
            return jp;
        }

        @Test
        public static void doesNotMeetCharacterLimit(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class A {\n                final String val1 = \"val\";\n                final String val2 = \"val\";\n                final String val3 = \"val\";\n            }\n        ", null, 23, null);
        }

        @Test
        public static void doesNotApplyToTest(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, this_.getTestParser(), null, null, "\n            class A {\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n            }\n        ", null, 22, null);
        }

        @Test
        public static void testSourcesEnabled(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, this_.getTestParser(), (Recipe)new ReplaceDuplicateStringLiterals(Boolean.valueOf(true)), null, "\n            class A {\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n            }\n        ", null, "\n            class A {\n                private static final String VALUE = \"value\";\n                final String val1 = VALUE;\n                final String val2 = VALUE;\n                final String val3 = VALUE;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void doNotChangeLiteralsInAnnotations(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            String[] stringArray = new String[]{"\n            public @interface Example {\n                String value() default \"\";\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class A {\n                @Example(value = \"value\")\n                void method1() {}\n                @Example(value = \"value\")\n                void method2() {}\n                @Example(value = \"value\")\n                void method3() {}\n            }\n        ", stringArray2, 7, null);
        }

        @Test
        public static void replaceRedundantFinalStrings(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package org.foo;\n            class A {\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n            }\n        ", null, "\n            package org.foo;\n            class A {\n                private static final String VALUE = \"value\";\n                final String val1 = VALUE;\n                final String val2 = VALUE;\n                final String val3 = VALUE;\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void replaceRedundantLiteralInMethodInvocation(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                String method(String val) {\n                    return null;\n                }\n                String val1 = method(\"value\");\n                String val2 = method(\"value\");\n                String val3 = method(\"value\");\n            }\n        ", null, "\n            class A {\n                private static final String VALUE = \"value\";\n                String method(String val) {\n                    return null;\n                }\n                String val1 = method(VALUE);\n                String val2 = method(VALUE);\n                String val3 = method(VALUE);\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void replaceRedundantLiteralsInNewClass(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                void method() {\n                    B b1 = new B(\"value\");\n                    B b2 = new B(\"value\");\n                    B b3 = new B(\"value\");\n                }\n                private static class B {\n                    B(String val) {\n                    }\n                }\n            }\n        ", null, "\n            class A {\n                private static final String VALUE = \"value\";\n                void method() {\n                    B b1 = new B(VALUE);\n                    B b2 = new B(VALUE);\n                    B b3 = new B(VALUE);\n                }\n                private static class B {\n                    B(String val) {\n                    }\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void multipleRedundantValues(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                final String a1 = \"value a\";\n                final String a2 = \"value a\";\n                final String a3 = \"value a\";\n                final String b1 = \"value b\";\n                final String b2 = \"value b\";\n                final String b3 = \"value b\";\n            }\n        ", null, "\n            class A {\n                private static final String VALUE_A = \"value a\";\n                private static final String VALUE_B = \"value b\";\n                final String a1 = VALUE_A;\n                final String a2 = VALUE_A;\n                final String a3 = VALUE_A;\n                final String b1 = VALUE_B;\n                final String b2 = VALUE_B;\n                final String b3 = VALUE_B;\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void transformStringValue(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                final String val1 = \"An example,, of a :: String with `` special __ characters.\";\n                final String val2 = \"An example,, of a :: String with `` special __ characters.\";\n                final String val3 = \"An example,, of a :: String with `` special __ characters.\";\n            }\n        ", null, "\n            class A {\n                private static final String AN_EXAMPLE_OF_A_STRING_WITH_SPECIAL_CHARACTERS = \"An example,, of a :: String with `` special __ characters.\";\n                final String val1 = AN_EXAMPLE_OF_A_STRING_WITH_SPECIAL_CHARACTERS;\n                final String val2 = AN_EXAMPLE_OF_A_STRING_WITH_SPECIAL_CHARACTERS;\n                final String val3 = AN_EXAMPLE_OF_A_STRING_WITH_SPECIAL_CHARACTERS;\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void constantAlreadyExists(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                private static final String CONSTANT = \"value\";\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n            }\n        ", null, "\n            class A {\n                private static final String CONSTANT = \"value\";\n                final String val1 = CONSTANT;\n                final String val2 = CONSTANT;\n                final String val3 = CONSTANT;\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void constantExistsWithInnerClass(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                private static final String CONSTANT = \"value\";\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n                \n                private static class B {\n                    // Do not change inner class value.\n                    private static final String CONSTANT = \"value\";\n                }\n            }\n        ", null, "\n            class A {\n                private static final String CONSTANT = \"value\";\n                final String val1 = CONSTANT;\n                final String val2 = CONSTANT;\n                final String val3 = CONSTANT;\n                \n                private static class B {\n                    // Do not change inner class value.\n                    private static final String CONSTANT = \"value\";\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void preventNamespaceShadowingWithNonStringConstant(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package org.foo;\n            class A {\n                private static final int VALUE = 1;\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n            }\n        ", null, "\n            package org.foo;\n            class A {\n                private static final String VALUE_1 = \"value\";\n                private static final int VALUE = 1;\n                final String val1 = VALUE_1;\n                final String val2 = VALUE_1;\n                final String val3 = VALUE_1;\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void preventNamespaceShadowingOnExistingConstant(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                // Change field name to prevent potential namespace conflicts.\n                private static final String VALUE = \"value\";\n                void newScope() {\n                    final String VALUE = \"name already exists\";\n                    final String val1 = \"value\";\n                    final String val2 = \"value\";\n                    final String val3 = \"value\";\n                }\n                void method() {\n                    // Change existing method reference.\n                    String valueRef = VALUE;\n                }\n                private static class B {\n                    // Change existing inner class reference.\n                    String innerClass = VALUE;\n                }\n            }\n        ", null, "\n            class A {\n                // Change field name to prevent potential namespace conflicts.\n                private static final String VALUE_1 = \"value\";\n                void newScope() {\n                    final String VALUE = \"name already exists\";\n                    final String val1 = VALUE_1;\n                    final String val2 = VALUE_1;\n                    final String val3 = VALUE_1;\n                }\n                void method() {\n                    // Change existing method reference.\n                    String valueRef = VALUE_1;\n                }\n                private static class B {\n                    // Change existing inner class reference.\n                    String innerClass = VALUE_1;\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void preventNamespaceShadowingOnNewConstant(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                final String val1 = \"value\";\n                final String val2 = \"value\";\n                final String val3 = \"value\";\n                final String VALUE = \"name space conflict\";\n            }\n        ", null, "\n            class A {\n                private static final String VALUE_1 = \"value\";\n                final String val1 = VALUE_1;\n                final String val2 = VALUE_1;\n                final String val3 = VALUE_1;\n                final String VALUE = \"name space conflict\";\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void multiVariableDeclaration(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                final String val1 = \"value\", val2 = \"value\", diff = \"here\";\n                final String val3 = \"value\";\n                final String VALUE = \"name space conflict\";\n            }\n        ", null, "\n            class A {\n                private static final String VALUE_1 = \"value\";\n                final String val1 = VALUE_1, val2 = VALUE_1, diff = \"here\";\n                final String val3 = VALUE_1;\n                final String VALUE = \"name space conflict\";\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void replaceMixedRedundantLiterals(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            class A {\n                final String val1 = \"value\";\n                void methodA() {\n                    methodB(\"value\");\n                }\n                void methodB(String val) {\n                    B b = new B(\"value\");\n                }\n                private static class B {\n                    B(String val) {\n                    }\n                }\n            }\n        ", null, "\n            class A {\n                private static final String VALUE = \"value\";\n                final String val1 = VALUE;\n                void methodA() {\n                    methodB(VALUE);\n                }\n                void methodB(String val) {\n                    B b = new B(VALUE);\n                }\n                private static class B {\n                    B(String val) {\n                    }\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ReplaceDuplicateStringLiteralsTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ReplaceDuplicateStringLiteralsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

