/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/tree/MethodInvocationTest;", "", "genericMethodInvocation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "methodInvocation", "methodThatDoesNotExist", "staticMethodInvocation", "allInvs", "", "Lorg/openrewrite/java/tree/J$MethodInvocation;", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "rewrite-java-tck"})
public interface MethodInvocationTest {
    @Test
    public void methodInvocation(@NotNull JavaParser var1);

    @Test
    public void genericMethodInvocation(@NotNull JavaParser var1);

    @Test
    public void staticMethodInvocation(@NotNull JavaParser var1);

    @Test
    public void methodThatDoesNotExist(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        private static List<J.MethodInvocation> allInvs(MethodInvocationTest this_, J.CompilationUnit receiver) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            List list = ((J.ClassDeclaration)receiver.getClasses().get(0)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classes[0].body\n        .statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.VariableDeclarations)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Expression expression = ((J.VariableDeclarations.NamedVariable)it.getVariables().get(0)).getInitializer();
                if (expression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
                }
                collection.add((J.MethodInvocation)expression);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void methodInvocation(@NotNull MethodInvocationTest this_, @NotNull JavaParser jp) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public class A {\n                Integer m = foo ( 0, 1, 2 );\n    \n                public Integer foo(Integer n, Integer... ns) { return n; }\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(stringArray).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
            J.MethodInvocation inv = DefaultImpls.allInvs(this_, a).get(0);
            Assertions.assertEquals((Object)"foo", (Object)inv.getSimpleName());
            JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(inv.getType());
            Assertions.assertEquals((Object)"java.lang.Integer", (Object)(fullyQualified != null ? fullyQualified.getFullyQualifiedName() : null));
            Object object = new JavaType.Primitive[]{JavaType.Primitive.Int, JavaType.Primitive.Int, JavaType.Primitive.Int};
            List list = CollectionsKt.listOf((Object[])object);
            List list2 = inv.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"inv.arguments");
            object = list2;
            List list3 = list;
            boolean $i$f$filterIsInstance = false;
            void var7_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.Literal)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.Literal literal2 = (J.Literal)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getType());
            }
            Assertions.assertEquals((Object)list3, (Object)((List)destination$iv$iv));
            JavaType.Method method2 = inv.getMethodType();
            Intrinsics.checkNotNull((Object)method2);
            List effectParams = method2.getParameterTypes();
            JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified((JavaType)effectParams.get(0));
            Assertions.assertEquals((Object)"java.lang.Integer", (Object)(fullyQualified2 != null ? fullyQualified2.getFullyQualifiedName() : null));
            JavaType.Array array2 = TestKt.asArray((JavaType)effectParams.get(1));
            JavaType.FullyQualified fullyQualified3 = TestKt.asFullyQualified((JavaType)(array2 != null ? array2.getElemType() : null));
            Assertions.assertEquals((Object)"java.lang.Integer", (Object)(fullyQualified3 != null ? fullyQualified3.getFullyQualifiedName() : null));
            JavaType.Method method3 = inv.getMethodType();
            Assertions.assertEquals((Object)"A", method3 != null && (method3 = method3.getDeclaringType()) != null ? method3.getFullyQualifiedName() : null);
            Assertions.assertEquals((Object)"foo ( 0, 1, 2 )", (Object)inv.printTrimmed());
        }

        @Test
        public static void genericMethodInvocation(@NotNull MethodInvocationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n            public class A {\n                Integer o = generic ( 0, 1, 2 );\n                Integer p = this . < Integer > generic ( 0, 1, 2 );\n    \n                public <TTTT> TTTT generic(TTTT n, TTTT... ns) { return n; }\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
            object = DefaultImpls.allInvs(this_, a);
            J.MethodInvocation genericInv = (J.MethodInvocation)object.get(0);
            J.MethodInvocation explicitGenericInv = (J.MethodInvocation)object.get(1);
            Object[] objectArray = new J.MethodInvocation[]{genericInv, explicitGenericInv};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JavaType.Method methType;
                J.MethodInvocation test = (J.MethodInvocation)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)test.getMethodType());
                JavaType.FullyQualified fullyQualified = TestKt.asFullyQualified(methType.getReturnType());
                Assertions.assertEquals((Object)"java.lang.Integer", (Object)(fullyQualified != null ? fullyQualified.getFullyQualifiedName() : null));
                JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified((JavaType)methType.getParameterTypes().get(0));
                Assertions.assertEquals((Object)"java.lang.Integer", (Object)(fullyQualified2 != null ? fullyQualified2.getFullyQualifiedName() : null));
                JavaType.Array array2 = TestKt.asArray((JavaType)methType.getParameterTypes().get(1));
                Intrinsics.checkNotNull((Object)array2);
                JavaType.FullyQualified fullyQualified3 = TestKt.asFullyQualified(array2.getElemType());
                Assertions.assertEquals((Object)"java.lang.Integer", (Object)(fullyQualified3 != null ? fullyQualified3.getFullyQualifiedName() : null));
            }
            Assertions.assertEquals((Object)"this . < Integer > generic ( 0, 1, 2 )", (Object)explicitGenericInv.printTrimmed());
        }

        @Test
        public static void staticMethodInvocation(@NotNull MethodInvocationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n            public class A {\n                Integer n = staticFoo ( 0 );\n                Integer o = staticFoo ( );\n    \n                public static int staticFoo(int... args) { return 0; }\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
            object = DefaultImpls.allInvs(this_, a);
            J.MethodInvocation staticInv = (J.MethodInvocation)object.get(0);
            J.MethodInvocation parameterlessStaticInv = (J.MethodInvocation)object.get(1);
            Assertions.assertEquals((Object)"staticFoo", (Object)staticInv.getSimpleName());
            JavaType.Method method2 = staticInv.getMethodType();
            Assertions.assertEquals((Object)"A", method2 != null && (method2 = method2.getDeclaringType()) != null ? method2.getFullyQualifiedName() : null);
            Assertions.assertEquals((Object)"staticFoo ( 0 )", (Object)staticInv.printTrimmed());
            Assertions.assertEquals((Object)"staticFoo ( )", (Object)parameterlessStaticInv.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void methodThatDoesNotExist(@NotNull MethodInvocationTest this_, @NotNull JavaParser jp) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public class A {\n                Integer n = doesNotExist();\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((ExecutionContext)new InMemoryExecutionContext(DefaultImpls::methodThatDoesNotExist$lambda-3), stringArray).get(0);
            List list = ((J.ClassDeclaration)a.getClasses().get(0)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"a.classes[0].body.statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.VariableDeclarations)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)CollectionsKt.first((List)((List)destination$iv$iv))).getVariables().get(0)).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation inv = (J.MethodInvocation)expression;
            JavaType.Method method2 = inv.getMethodType();
            Assertions.assertNull((Object)(method2 != null ? method2.getDeclaringType() : null));
            Assertions.assertNull((Object)inv.getType());
            Assertions.assertNull((Object)inv.getType());
        }

        private static void methodThatDoesNotExist$lambda-3(Throwable t) {
            Assertions.fail((Throwable)t);
        }
    }
}

