/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.ReplaceLambdaWithMethodReference;
import org.openrewrite.java.cleanup.UseLambdaForFunctionalInterface;
import org.openrewrite.java.cleanup.UseLambdaForFunctionalInterfaceTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0015"}, d2={"Lorg/openrewrite/java/cleanup/UseLambdaForFunctionalInterfaceTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "dontUseLambdaWhenShadowsClassField", "", "jp", "Lorg/openrewrite/java/JavaParser;", "dontUseLambdaWhenShadowsLocalVariable", "dontUseLambdaWhenShadowsMethodDeclarationParam", "dontUseLambdaWhenThis", "emptyLambda", "finalParameters", "nestedLambdaInMethodArgument", "rawParameterizedType", "useLambda", "useLambdaNoParameters", "useLambdaThenRemoveUnusedImports", "useLambdaThenSimplifyFurther", "rewrite-java-tck"})
public interface UseLambdaForFunctionalInterfaceTest
extends JavaRecipeTest {
    @NotNull
    public Recipe getRecipe();

    @Disabled(value="The recipe currently avoids simplifying anonymous classes that use the this keyword.")
    @Test
    public void useLambdaThenSimplifyFurther(@NotNull JavaParser var1);

    @Test
    public void useLambda(@NotNull JavaParser var1);

    @Test
    public void useLambdaNoParameters(@NotNull JavaParser var1);

    @Test
    public void emptyLambda(@NotNull JavaParser var1);

    @Test
    public void nestedLambdaInMethodArgument(@NotNull JavaParser var1);

    @Test
    public void dontUseLambdaWhenThis(@NotNull JavaParser var1);

    @Test
    public void dontUseLambdaWhenShadowsLocalVariable(@NotNull JavaParser var1);

    @Test
    public void dontUseLambdaWhenShadowsClassField(@NotNull JavaParser var1);

    @Test
    public void dontUseLambdaWhenShadowsMethodDeclarationParam(@NotNull JavaParser var1);

    @Test
    public void finalParameters(@NotNull JavaParser var1);

    @Test
    public void useLambdaThenRemoveUnusedImports(@NotNull JavaParser var1);

    @Test
    @Disabled
    public void rawParameterizedType(@NotNull JavaParser var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull UseLambdaForFunctionalInterfaceTest this_) {
            return (Recipe)new UseLambdaForFunctionalInterface();
        }

        @Disabled(value="The recipe currently avoids simplifying anonymous classes that use the this keyword.")
        @Test
        public static void useLambdaThenSimplifyFurther(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            Recipe recipe2 = new UseLambdaForFunctionalInterface().doNext((Recipe)new ReplaceLambdaWithMethodReference());
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"UseLambdaForFunctionalIn\u2026bdaWithMethodReference())");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, null, "\n        class Test {\n            Runnable r = new Runnable() {\n                @Override public void run() {\n                    Test.this.execute();\n                }\n            };\n            \n            void execute() {}\n        }\n    ", null, "\n        class Test {\n            Runnable r = Test.this::execute;\n            \n            void execute() {}\n        }\n    ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void useLambda(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.Function;\n            class Test {\n                Function<Integer, Integer> f = new Function<Integer, Integer>() {\n                    @Override \n                    public Integer apply(Integer n) {\n                        return n + 1;\n                    }\n                };\n            }\n        ", null, "\n            import java.util.function.Function;\n            class Test {\n                Function<Integer, Integer> f = n -> n + 1;\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void useLambdaNoParameters(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.Supplier;\n            class Test {\n                Supplier<Integer> s = new Supplier<Integer>() {\n                    @Override \n                    public Integer get() {\n                        return 1;\n                    }\n                };\n            }\n        ", null, "\n            import java.util.function.Supplier;\n            class Test {\n                Supplier<Integer> s = () -> 1;\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void emptyLambda(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.Consumer;\n            \n            class Test {\n                void foo() {\n                    Consumer<Integer> s;\n                    s = new Consumer<Integer>() {\n                        @Override\n                        public void accept(Integer i) {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            import java.util.function.Consumer;\n            \n            class Test {\n                void foo() {\n                    Consumer<Integer> s;\n                    s = i -> {\n                    };\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void nestedLambdaInMethodArgument(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.Consumer;\n            \n            class Test {\n                void bar(Consumer<Integer> c) {\n                }\n                void foo() {\n                    bar(new Consumer<Integer>() {\n                        @Override\n                        public void accept(Integer i) {\n                            bar(new Consumer<Integer>() {\n                                @Override\n                                public void accept(Integer i2) {\n                                }\n                            });\n                        }\n                    });\n                }\n            }\n        ", null, "\n            import java.util.function.Consumer;\n            \n            class Test {\n                void bar(Consumer<Integer> c) {\n                }\n                void foo() {\n                    bar(i -> {\n                        bar(i2 -> {\n                        });\n                    });\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void dontUseLambdaWhenThis(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.Function;\n            class Test {\n                int n;\n                Function<Integer, Integer> f = new Function<Integer, Integer>() {\n                    @Override \n                    public Integer apply(Integer n) {\n                        return this.n;\n                    }\n                };\n            }\n        ", null, 22, null);
        }

        @Test
        public static void dontUseLambdaWhenShadowsLocalVariable(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.Supplier;\n            class Test {\n                void test() {\n                    int n = 1;\n                    Supplier<Integer> f = new Supplier<Integer>() {\n                        @Override\n                        public Integer get() {\n                            int n = 0;\n                            return n;\n                        }\n                    };\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void dontUseLambdaWhenShadowsClassField(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.Supplier;\n            class Test {\n                int n = 1;\n                void test() {\n                    Supplier<Integer> f = new Supplier<Integer>() {\n                        @Override\n                        public Integer get() {\n                            int n = 0;\n                            return n;\n                        }\n                    };\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void dontUseLambdaWhenShadowsMethodDeclarationParam(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            import java.util.function.Supplier;\n            class Test {\n                void test(int n) {\n                    Supplier<Integer> f = new Supplier<Integer>() {\n                        @Override\n                        public Integer get() {\n                            int n = 0;\n                            return n;\n                        }\n                    };\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void finalParameters(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.function.Function;\n            class Test {\n                Function<Integer, Integer> f = new Function<Integer, Integer>() {\n                    @Override \n                    public Integer apply(final Integer n) {\n                        return n + 1;\n                    }\n                };\n            }\n        ", null, "\n            import java.util.function.Function;\n            class Test {\n                Function<Integer, Integer> f = n -> n + 1;\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void useLambdaThenRemoveUnusedImports(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n        import java.util.HashMap;\n        import java.util.function.Function;\n\n        public class Temp {\n            public static void foo(){\n                new HashMap<Integer, String>().computeIfAbsent(3, new Function<Integer, String>() {\n                    @Override\n                    public String apply(Integer integer) {\n                        return String.valueOf(integer + 1);\n                    }\n                });\n            }\n        }\n        ", null, "\n        import java.util.HashMap;\n\n        public class Temp {\n            public static void foo(){\n                new HashMap<Integer, String>().computeIfAbsent(3, integer -> String.valueOf(integer + 1));\n            }\n        }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        @Disabled
        public static void rawParameterizedType(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package javafx.beans.value;\n\n                public interface ObservableValue<T> {\n                    void addListener(ChangeListener<? super T> listener);\n                }\n            ", "\n                package javafx.beans.value;\n                \n                @FunctionalInterface\n                public interface ChangeListener<T> {\n                    void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n                }                \n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import javafx.beans.value.ObservableValue;\n            import javafx.beans.value.ChangeListener;\n            \n            class Test {\n                ChangeListener listener = new ChangeListener<String>() {\n                    @Override\n                    public void changed(ObservableValue ov, String oldState, String newState) {\n                    }\n                };\n            }\n        ", stringArray2, "\n            import javafx.beans.value.ObservableValue;\n            import javafx.beans.value.ChangeListener;\n\n            class Test {\n                ChangeListener listener = (ov, oldState, newState) -> {\n                };\n            }\n        ", 0, 0, null, rawParameterizedType.1.INSTANCE, 454, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull UseLambdaForFunctionalInterfaceTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull UseLambdaForFunctionalInterfaceTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull UseLambdaForFunctionalInterfaceTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull UseLambdaForFunctionalInterfaceTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull UseLambdaForFunctionalInterfaceTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

