/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.ReplaceLambdaWithMethodReference;
import org.openrewrite.java.cleanup.ReplaceLambdaWithMethodReferenceTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0010\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017J\b\u0010\u0010\u001a\u00020\u0007H\u0017J\b\u0010\u0011\u001a\u00020\u0007H\u0017J\b\u0010\u0012\u001a\u00020\u0007H\u0017J\b\u0010\u0013\u001a\u00020\u0007H\u0017J\b\u0010\u0014\u001a\u00020\u0007H\u0017J\b\u0010\u0015\u001a\u00020\u0007H\u0017J\b\u0010\u0016\u001a\u00020\u0007H\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lorg/openrewrite/java/cleanup/ReplaceLambdaWithMethodReferenceTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "castType", "", "containsMultipleStatements", "functionMultiParamReference", "functionReference", "instanceOf", "isEqualToNull", "labmdaReturnsFunctionalInterface", "multipleMethodInvocations", "nonStaticMethods", "notEqualToNull", "returnExpressionIsNotAMethodInvocation", "staticMethods", "systemOutPrint", "systemOutPrintInBlock", "typeCastOnMethodInvocationReturnType", "voidMethodReference", "rewrite-java-tck"})
public interface ReplaceLambdaWithMethodReferenceTest
extends JavaRecipeTest {
    @Nullable
    public Recipe getRecipe();

    @Test
    public void multipleMethodInvocations();

    @Test
    public void containsMultipleStatements();

    @Test
    public void typeCastOnMethodInvocationReturnType();

    @Test
    public void instanceOf();

    @Test
    public void functionMultiParamReference();

    @Test
    public void nonStaticMethods();

    @Test
    public void staticMethods();

    @Test
    public void systemOutPrint();

    @Test
    public void systemOutPrintInBlock();

    @Test
    public void castType();

    @Test
    public void notEqualToNull();

    @Test
    public void isEqualToNull();

    @Test
    public void voidMethodReference();

    @Test
    public void functionReference();

    @Test
    public void returnExpressionIsNotAMethodInvocation();

    @Test
    public void labmdaReturnsFunctionalInterface();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            return (Recipe)new ReplaceLambdaWithMethodReference();
        }

        @Test
        public static void multipleMethodInvocations(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "import java.nio.file.Path;\nimport java.nio.file.Paths;\nimport java.util.List;import java.util.stream.Collectors;\n\nclass Test {\n    Path path = Paths.get(\"\");\n    List<String> method(List<String> l) {\n        return l.stream()\n            .filter(s -> path.getFileName().toString().equals(s))\n            .collect(Collectors.toList());\n    }\n}", null, 23, null);
        }

        @Test
        public static void containsMultipleStatements(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            class Test {\n                List<Integer> even(List<Integer> l) {\n                    return l.stream().map(n -> {\n                        if (n % 2 == 0) return n;\n                        return n * 2;\n                    }).collect(Collectors.toList());\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void typeCastOnMethodInvocationReturnType(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            import java.util.List;\n            import java.util.stream.Collectors;\n            import java.util.stream.Stream;\n\n            class Test {\n                public void foo() {\n                    List<String> bar = Stream.of(\"A\", \"b\")\n                            .map(s -> (String) s.toLowerCase())\n                            .collect(Collectors.toList());\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void instanceOf(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            String[] stringArray = new String[]{"\n            package org.test;\n            public class CheckType {\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            import org.test.CheckType;\n\n            class Test {\n                List<Object> method(List<Object> input) {\n                    return input.stream().filter(n -> n instanceof CheckType).collect(Collectors.toList());\n                }\n            }\n        ", stringArray2, "\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            import org.test.CheckType;\n\n            class Test {\n                List<Object> method(List<Object> input) {\n                    return input.stream().filter(CheckType.class::isInstance).collect(Collectors.toList());\n                }\n            }\n        ", 0, 0, null, instanceOf.1.INSTANCE, 455, null);
        }

        @Test
        public static void functionMultiParamReference(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            String[] stringArray = new String[]{"\n                public interface ObservableValue<T> {\n                }\n            ", "@FunctionalInterface\npublic interface ChangeListener<T> {\n    void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n}"};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.function.Function;\n            class Test {\n            \n                ChangeListener listener = (o, oldVal, newVal) -> {\n                    onChange(o, oldVal, newVal);\n                };\n                \n                protected void onChange(ObservableValue<?> o, Object oldVal, Object newVal) {\n                    String strVal = newVal.toString();\n                    System.out.println(strVal);\n                }\n            }\n        ", stringArray2, "\n            import java.util.function.Function;\n            class Test {\n            \n                ChangeListener listener = this::onChange;\n                \n                protected void onChange(ObservableValue<?> o, Object oldVal, Object newVal) {\n                    String strVal = newVal.toString();\n                    System.out.println(strVal);\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void nonStaticMethods(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.Collections;\n            class Test {\n                Runnable r = () -> run();\n                public void run() {\n                    Collections.singletonList(1).forEach(n -> run());\n                }\n            }\n            \n            class Test2 {\n                Test t = new Test();\n                Runnable r = () -> t.run();\n            }\n        ", null, "\n            import java.util.Collections;\n            class Test {\n                Runnable r = this::run;\n                public void run() {\n                    Collections.singletonList(1).forEach(n -> run());\n                }\n            }\n            \n            class Test2 {\n                Test t = new Test();\n                Runnable r = t::run;\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void staticMethods(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.Collections;\n            class Test {\n                Runnable r = () -> run();\n                public static void run() {\n                    Collections.singletonList(1).forEach(n -> run());\n                }\n            }\n            \n            class Test2 {\n                Runnable r = () -> Test.run();\n            }\n        ", null, "\n            import java.util.Collections;\n            class Test {\n                Runnable r = Test::run;\n                public static void run() {\n                    Collections.singletonList(1).forEach(n -> run());\n                }\n            }\n            \n            class Test2 {\n                Runnable r = Test::run;\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void systemOutPrint(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.List;\n\n            class Test {\n                void method(List<Integer> input) {\n                    return input.forEach(x -> System.out.println(x));\n                }\n            }\n        ", null, "\n            import java.util.List;\n\n            class Test {\n                void method(List<Integer> input) {\n                    return input.forEach(System.out::println);\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void systemOutPrintInBlock(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.List;\n\n            class Test {\n                void method(List<Integer> input) {\n                    return input.forEach(x -> { System.out.println(x); });\n                }\n            }\n        ", null, "\n            import java.util.List;\n\n            class Test {\n                void method(List<Integer> input) {\n                    return input.forEach(System.out::println);\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void castType(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            String[] stringArray = new String[]{"\n            package org.test;\n            public class CheckType {\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            import org.test.CheckType;\n\n            class Test {\n                List<Object> filter(List<Object> l) {\n                    return l.stream()\n                        .filter(CheckType.class::isInstance)\n                        .map(o -> (CheckType) o)\n                        .collect(Collectors.toList());\n                }\n            }\n        ", stringArray2, "\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            import org.test.CheckType;\n\n            class Test {\n                List<Object> filter(List<Object> l) {\n                    return l.stream()\n                        .filter(CheckType.class::isInstance)\n                        .map(CheckType.class::cast)\n                        .collect(Collectors.toList());\n                }\n            }\n        ", 0, 0, null, castType.1.INSTANCE, 455, null);
        }

        @Test
        public static void notEqualToNull(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            class Test {\n                List<Object> filter(List<Object> l) {\n                    return l.stream()\n                        .filter(o -> o != null)\n                        .collect(Collectors.toList());\n                }\n            }\n        ", null, "\n            import java.util.List;\n            import java.util.Objects;\n            import java.util.stream.Collectors;\n\n            class Test {\n                List<Object> filter(List<Object> l) {\n                    return l.stream()\n                        .filter(Objects::nonNull)\n                        .collect(Collectors.toList());\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void isEqualToNull(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            class Test {\n                boolean containsNull(List<Object> l) {\n                    return l.stream()\n                        .anyMatch(o -> o == null);\n                }\n            }\n        ", null, "\n            import java.util.List;\n            import java.util.Objects;\n            import java.util.stream.Collectors;\n\n            class Test {\n                boolean containsNull(List<Object> l) {\n                    return l.stream()\n                        .anyMatch(Objects::isNull);\n                }\n            }\n        ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void voidMethodReference(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n                class Test {\n                    Runnable r = () -> {\n                        this.execute();\n                    };\n\n                    void execute() {}\n                }\n            ", null, "\n                class Test {\n                    Runnable r = this::execute;\n\n                    void execute() {}\n                }\n            ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void functionReference(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n                import java.util.function.Function;\n\n                class Test {\n                    Function<Integer, String> f = (i) -> {\n                        return this.execute(i);\n                    };\n                    \n                    String execute(Integer i) {\n                        return i.toString();\n                    }\n                }\n            ", null, "\n                import java.util.function.Function;\n\n                class Test {\n                    Function<Integer, String> f = this::execute;\n                    \n                    String execute(Integer i) {\n                        return i.toString();\n                    }\n                }\n            ", 0, 0, null, null, 983, null);
        }

        @Test
        public static void returnExpressionIsNotAMethodInvocation(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            class T {\n                public void killBatchJob() {\n                    return deleteSparkBatchRequest()\n                            .map(resp -> {\n                                return this;\n                            })\n                            .defaultIfEmpty(this);\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void labmdaReturnsFunctionalInterface(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            String[] stringArray = new String[]{"\n            package abc;\n            @FunctionalInterface\n            public interface MyFunction {\n                String get();\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, null, "\n            package abc;\n            \n            class M {\n                MyFunction getFunction(String fcn) {\n                    return () -> fcn;\n                }\n            }\n        ", stringArray2, 7, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

