/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.CombineSemanticallyEqualCatchBlocks;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0014"}, d2={"Lorg/openrewrite/java/cleanup/CombineSemanticallyEqualCatchBlocksTest;", "Lorg/openrewrite/test/RewriteTest;", "blocksContainDifferentComments", "", "jp", "Lorg/openrewrite/java/JavaParser;", "blocksContainSameComments", "childClassIsCaughtBeforeParentClass", "combineCatchesIntoNewMultiCatch", "combineSameSemanticallyEquivalentMethodTypes", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotCombineDifferentCatchBlocks", "fromCatchCombineWithMultiCatch", "fromMultiCatchCombineWithCatch", "fromMultiCatchCombineWithMultiCatch", "preserveOrderOfCatchesWhenPossible", "removeRedundantChildClasses", "removeRedundantChildClassesWithExistingMultiCatches", "rewrite-java-tck"})
public interface CombineSemanticallyEqualCatchBlocksTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doNotCombineDifferentCatchBlocks(@NotNull JavaParser var1);

    @Test
    public void childClassIsCaughtBeforeParentClass(@NotNull JavaParser var1);

    @Test
    public void blocksContainDifferentComments(@NotNull JavaParser var1);

    @Test
    public void blocksContainSameComments(@NotNull JavaParser var1);

    @Test
    public void combineSameSemanticallyEquivalentMethodTypes(@NotNull JavaParser var1);

    @Test
    public void combineCatchesIntoNewMultiCatch(@NotNull JavaParser var1);

    @Test
    public void fromMultiCatchCombineWithCatch(@NotNull JavaParser var1);

    @Test
    public void fromCatchCombineWithMultiCatch(@NotNull JavaParser var1);

    @Test
    public void fromMultiCatchCombineWithMultiCatch(@NotNull JavaParser var1);

    @Test
    public void preserveOrderOfCatchesWhenPossible(@NotNull JavaParser var1);

    @Test
    public void removeRedundantChildClasses(@NotNull JavaParser var1);

    @Test
    public void removeRedundantChildClassesWithExistingMultiCatches(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new CombineSemanticallyEqualCatchBlocks());
        }

        @Test
        public static void doNotCombineDifferentCatchBlocks(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n            String s = \"foo\";\n        } catch (B ex) {\n            String s = \"bar\";\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.doNotCombineDifferentCatchBlocks$lambda-0(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void childClassIsCaughtBeforeParentClass(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends BaseException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B ex) { // Is subtype of BaseException with a unique block.\n            String diff;\n        } catch (BaseException ex) {\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.childClassIsCaughtBeforeParentClass$lambda-1(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void blocksContainDifferentComments(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n            // Comment 1\n        } catch (B ex) {\n            // Comment 2\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.blocksContainDifferentComments$lambda-2(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void blocksContainSameComments(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n            // Same\n        } catch (B ex) {\n            // Same\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n            // Same\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.blocksContainSameComments$lambda-3(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void combineSameSemanticallyEquivalentMethodTypes(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends BaseException {}"), Assertions.java((String)"class B extends BaseException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n            base(ex);\n        } catch (B ex) {\n            base(ex);\n        }\n    }\n    void base(BaseException ex) {}\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n            base(ex);\n        }\n    }\n    void base(BaseException ex) {}\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.combineSameSemanticallyEquivalentMethodTypes$lambda-4(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void combineCatchesIntoNewMultiCatch(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.combineCatchesIntoNewMultiCatch$lambda-5(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void fromMultiCatchCombineWithCatch(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class C extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B | C ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B | C ex) {\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.fromMultiCatchCombineWithCatch$lambda-6(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void fromCatchCombineWithMultiCatch(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class C extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n        } catch (C ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B | C ex) {\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.fromCatchCombineWithMultiCatch$lambda-7(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void fromMultiCatchCombineWithMultiCatch(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class C extends RuntimeException {}"), Assertions.java((String)"class D extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n        } catch (C | D ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | B | C | D ex) {\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.fromMultiCatchCombineWithMultiCatch$lambda-8(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void preserveOrderOfCatchesWhenPossible(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends RuntimeException {}"), Assertions.java((String)"class B extends BaseException {}"), Assertions.java((String)"class C extends BaseException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B ex) {\n            String diff;\n        } catch (C ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (A | C ex) {\n        } catch (B ex) {\n            String diff;\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.preserveOrderOfCatchesWhenPossible$lambda-9(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void removeRedundantChildClasses(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends BaseException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A ex) {\n        } catch (B ex) {\n        } catch (BaseException ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (B | BaseException ex) {\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.removeRedundantChildClasses$lambda-10(jp, arg_0), sourceSpecsArray);
        }

        @Test
        public static void removeRedundantChildClassesWithExistingMultiCatches(@NotNull CombineSemanticallyEqualCatchBlocksTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class A extends BaseException {}"), Assertions.java((String)"class B extends RuntimeException {}"), Assertions.java((String)"class BaseException extends RuntimeException {}"), Assertions.java((String)"class Other extends RuntimeException {}"), Assertions.java((String)"class Test {\n    void method() {\n        try {\n        } catch (A | B ex) {\n        } catch (BaseException | Other ex) {\n        }\n    }\n}", (String)"class Test {\n    void method() {\n        try {\n        } catch (B | BaseException | Other ex) {\n        }\n    }\n}")};
            this_.rewriteRun(arg_0 -> DefaultImpls.removeRedundantChildClassesWithExistingMultiCatches$lambda-11(jp, arg_0), sourceSpecsArray);
        }

        private static void doNotCombineDifferentCatchBlocks$lambda-0(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void childClassIsCaughtBeforeParentClass$lambda-1(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void blocksContainDifferentComments$lambda-2(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void blocksContainSameComments$lambda-3(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void combineSameSemanticallyEquivalentMethodTypes$lambda-4(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void combineCatchesIntoNewMultiCatch$lambda-5(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void fromMultiCatchCombineWithCatch$lambda-6(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void fromCatchCombineWithMultiCatch$lambda-7(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void fromMultiCatchCombineWithMultiCatch$lambda-8(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void preserveOrderOfCatchesWhenPossible$lambda-9(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void removeRedundantChildClasses$lambda-10(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }

        private static void removeRedundantChildClassesWithExistingMultiCatches$lambda-11(JavaParser $jp, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)$jp, (String)"$jp");
            spec.parser((Parser)$jp);
        }
    }
}

