/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.ReloadableJava8TypeMapping;
import org.openrewrite.java.marker.LeadingBrace;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class ReloadableJava8JavadocVisitor
extends DocTreeScanner<Tree, java.util.List<Javadoc>> {
    private final Attr attr;
    private final  @Nullable Symbol.TypeSymbol symbol;
    private final @Nullable Type enclosingClassType;
    private final ReloadableJava8TypeMapping typeMapping;
    private final TreeScanner<J, Space> javaVisitor = new JavaVisitor();
    private final Map<Integer, Javadoc.LineBreak> lineBreaks = new HashMap<Integer, Javadoc.LineBreak>();
    private String firstPrefix = "";
    private String source;
    private int cursor = 0;

    public ReloadableJava8JavadocVisitor(Context context, TreePath scope, ReloadableJava8TypeMapping typeMapping, String source, JCTree tree) {
        this.attr = Attr.instance(context);
        this.typeMapping = typeMapping;
        this.source = source;
        if (scope.getLeaf() instanceof JCTree.JCCompilationUnit) {
            this.enclosingClassType = tree.type;
            this.symbol = ((JCTree.JCClassDecl)tree).sym;
        } else {
            com.sun.source.tree.Tree classDecl = scope.getLeaf();
            if (classDecl instanceof JCTree.JCClassDecl) {
                this.enclosingClassType = ((JCTree.JCClassDecl)classDecl).type;
                this.symbol = ((JCTree.JCClassDecl)classDecl).sym;
            } else if (classDecl instanceof JCTree.JCNewClass) {
                this.enclosingClassType = ((JCTree.JCNewClass)classDecl).def.type;
                this.symbol = ((JCTree.JCNewClass)classDecl).def.sym;
            } else {
                this.enclosingClassType = null;
                this.symbol = null;
            }
        }
    }

    private void init() {
        StringBuilder firstPrefixBuilder = new StringBuilder();
        StringBuilder javadocContent = new StringBuilder();
        StringBuilder marginBuilder = null;
        boolean inFirstPrefix = true;
        boolean isPrefixAsterisk = true;
        for (int i = 3; i < this.source.length(); ++i) {
            char c = this.source.charAt(i);
            if (inFirstPrefix) {
                if (Character.isWhitespace(c) || c == '*' && isPrefixAsterisk) {
                    if (isPrefixAsterisk && i + 1 <= this.source.length() - 1 && this.source.charAt(i + 1) != '*') {
                        isPrefixAsterisk = false;
                    }
                    firstPrefixBuilder.append(c);
                } else {
                    this.firstPrefix = firstPrefixBuilder.toString();
                    inFirstPrefix = false;
                }
            }
            if (c == '\r') continue;
            if (c == '\n') {
                String newLine;
                char prev = this.source.charAt(i - 1);
                if (inFirstPrefix) {
                    this.firstPrefix = firstPrefixBuilder.toString();
                    inFirstPrefix = false;
                } else {
                    if (prev == '\n' || prev == '\r' && this.source.charAt(i - 2) == '\n') {
                        String prevLineLine = prev == '\n' ? "\n" : "\r\n";
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), prevLineLine, Markers.EMPTY));
                    } else if (marginBuilder != null) {
                        newLine = prev == '\r' ? "\r\n" : "\n";
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), newLine, Markers.EMPTY));
                        javadocContent.append(marginBuilder.substring(marginBuilder.indexOf("\n") + 1));
                    }
                    javadocContent.append(c);
                }
                newLine = prev == '\r' ? "\r\n" : "\n";
                marginBuilder = new StringBuilder(newLine);
                continue;
            }
            if (marginBuilder != null) {
                if (!Character.isWhitespace(c)) {
                    if (c == '*') {
                        marginBuilder.append(c);
                        if (i + 1 > this.source.length() - 1 || this.source.charAt(i + 1) == '*') continue;
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), marginBuilder.toString(), Markers.EMPTY));
                        marginBuilder = null;
                        continue;
                    }
                    if (c == '@') {
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), marginBuilder.toString(), Markers.EMPTY));
                        javadocContent.append(c);
                    } else {
                        String newLine = marginBuilder.charAt(0) == '\r' ? "\r\n" : "\n";
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), newLine, Markers.EMPTY));
                        String margin = marginBuilder.toString();
                        javadocContent.append(margin.substring(margin.indexOf("\n") + 1)).append(c);
                    }
                    marginBuilder = null;
                    continue;
                }
                marginBuilder.append(c);
                continue;
            }
            if (inFirstPrefix) continue;
            javadocContent.append(c);
        }
        if (inFirstPrefix) {
            javadocContent.append((CharSequence)firstPrefixBuilder);
        }
        this.source = javadocContent.toString();
        if (marginBuilder != null && marginBuilder.length() > 0) {
            if (javadocContent.length() > 0 && javadocContent.charAt(0) != '\n') {
                this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), marginBuilder.toString(), Markers.EMPTY));
                this.source = this.source.substring(0, this.source.length() - 1);
            } else {
                this.lineBreaks.put(this.source.length(), new Javadoc.LineBreak(Tree.randomId(), marginBuilder.toString(), Markers.EMPTY));
            }
        }
    }

    @Override
    public Tree visitAttribute(AttributeTree node, java.util.List<Javadoc> body) {
        java.util.List value;
        java.util.List beforeEqual;
        String name = node.getName().toString();
        this.cursor += name.length();
        if (node.getValueKind() == AttributeTree.ValueKind.EMPTY) {
            beforeEqual = Collections.emptyList();
            value = Collections.emptyList();
        } else {
            Javadoc.LineBreak lineBreak;
            beforeEqual = new ArrayList();
            value = new ArrayList();
            while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
                ++this.cursor;
                beforeEqual.add(lineBreak);
            }
            String whitespaceBeforeEqual = this.whitespaceBeforeAsString();
            beforeEqual.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, whitespaceBeforeEqual));
            this.sourceBefore("=");
            while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
                ++this.cursor;
                value.add(lineBreak);
            }
            switch (node.getValueKind()) {
                case UNQUOTED: {
                    value.addAll(this.convertMultiline(node.getValue()));
                    break;
                }
                case SINGLE: {
                    value.addAll(this.sourceBefore("'"));
                    value.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "'"));
                    value.addAll(this.convertMultiline(node.getValue()));
                    value.addAll(this.sourceBefore("'"));
                    value.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "'"));
                    break;
                }
                default: {
                    value.addAll(this.sourceBefore("\""));
                    value.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "\""));
                    value.addAll(this.convertMultiline(node.getValue()));
                    value.addAll(this.sourceBefore("\""));
                    value.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "\""));
                }
            }
        }
        return new Javadoc.Attribute(Tree.randomId(), Markers.EMPTY, name, beforeEqual, value);
    }

    @Override
    public Tree visitAuthor(AuthorTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("@author"));
        return new Javadoc.Author(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getName()));
    }

    @Override
    public Tree visitComment(CommentTree node, java.util.List<Javadoc> body) {
        this.cursor += node.getBody().length();
        return new Javadoc.Text(Tree.randomId(), Markers.EMPTY, node.getBody());
    }

    @Override
    public Tree visitDeprecated(DeprecatedTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("@deprecated"));
        return new Javadoc.Deprecated(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getBody()));
    }

    @Override
    public Tree visitDocComment(DocCommentTree node, java.util.List<Javadoc> body) {
        this.init();
        Javadoc.LineBreak leadingLineBreak = this.lineBreaks.remove(0);
        if (leadingLineBreak != null) {
            if (!this.firstPrefix.isEmpty()) {
                body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, this.firstPrefix.substring(0, this.firstPrefix.length() - (this.firstPrefix.endsWith("\r\n") ? 2 : 1))));
                this.firstPrefix = "";
            }
            body.add((Javadoc)leadingLineBreak);
        }
        if (!this.firstPrefix.isEmpty()) {
            body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, this.firstPrefix));
        }
        java.util.List<? extends DocTree> firstSentence = node.getFirstSentence();
        for (int i = 0; i < firstSentence.size(); ++i) {
            DocTree docTree = firstSentence.get(i);
            if (!(docTree instanceof DCTree.DCText) || i <= 0) {
                body.addAll(this.whitespaceBefore());
            }
            if (docTree instanceof DCTree.DCText) {
                body.addAll(this.visitText(((DCTree.DCText)docTree).getBody()));
                continue;
            }
            if (docTree instanceof DCTree.DCComment) {
                body.addAll(this.visitText(((DCTree.DCComment)docTree).getBody()));
                continue;
            }
            body.add((Javadoc)this.scan(docTree, body));
        }
        java.util.List<? extends DocTree> restOfBody = node.getBody();
        for (int i = 0; i < restOfBody.size(); ++i) {
            DocTree docTree = restOfBody.get(i);
            if (!(docTree instanceof DCTree.DCText) || i <= 0) {
                body.addAll(this.whitespaceBefore());
            }
            if (docTree instanceof DCTree.DCText) {
                body.addAll(this.visitText(((DCTree.DCText)docTree).getBody()));
                continue;
            }
            body.add((Javadoc)this.scan(docTree, this.whitespaceBefore()));
        }
        for (DocTree docTree : node.getBlockTags()) {
            Javadoc.LineBreak lineBreak;
            block3: do {
                if ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
                    body.add((Javadoc)lineBreak);
                }
                StringBuilder whitespaceBeforeNewLine = new StringBuilder();
                for (int j = ++this.cursor; j < this.source.length(); ++j) {
                    char ch = this.source.charAt(j);
                    if (ch == '\r') {
                        ++this.cursor;
                        continue;
                    }
                    if (ch == '\n') {
                        if (whitespaceBeforeNewLine.length() > 0) {
                            body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, whitespaceBeforeNewLine.toString()));
                        }
                        this.cursor += whitespaceBeforeNewLine.length();
                        continue block3;
                    }
                    if (Character.isWhitespace(ch)) {
                        whitespaceBeforeNewLine.append(ch);
                        continue;
                    }
                    if (whitespaceBeforeNewLine.length() > 0) {
                        body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, whitespaceBeforeNewLine.toString()));
                        this.cursor += whitespaceBeforeNewLine.length();
                    }
                    break block3;
                }
            } while (lineBreak != null);
            body.addAll(this.whitespaceBefore());
            body.addAll(this.convertMultiline(Collections.singletonList(docTree)));
        }
        if (this.cursor < this.source.length()) {
            String trailingWhitespace = this.source.substring(this.cursor);
            if (trailingWhitespace.contains("\n")) {
                String[] stringArray;
                for (String part : stringArray = trailingWhitespace.split("\n")) {
                    int pos;
                    if (!part.isEmpty()) {
                        body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, part));
                    }
                    if (this.lineBreaks.isEmpty() || !this.lineBreaks.containsKey(pos = Collections.min(this.lineBreaks.keySet()).intValue())) continue;
                    body.add((Javadoc)this.lineBreaks.get(pos));
                    this.lineBreaks.remove(pos);
                }
            } else {
                body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, trailingWhitespace));
            }
        }
        if (!this.lineBreaks.isEmpty()) {
            this.lineBreaks.keySet().stream().sorted().forEach(o -> body.add((Javadoc)this.lineBreaks.get(o)));
        }
        return new Javadoc.DocComment(Tree.randomId(), Markers.EMPTY, body, "");
    }

    @Override
    public Tree visitDocRoot(DocRootTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@docRoot"));
        return new Javadoc.DocRoot(Tree.randomId(), Markers.EMPTY, this.endBrace());
    }

    @Override
    public Tree visitEndElement(EndElementTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("</"));
        String name = node.getName().toString();
        this.cursor += name.length();
        return new Javadoc.EndElement(Tree.randomId(), Markers.EMPTY, name, this.sourceBefore(">"));
    }

    @Override
    public Tree visitEntity(EntityTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("&"));
        this.cursor += node.getName().length() + 1;
        return new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "&" + node.getName().toString() + ";");
    }

    @Override
    public Tree visitErroneous(ErroneousTree node, java.util.List<Javadoc> body) {
        return new Javadoc.Erroneous(Tree.randomId(), Markers.EMPTY, this.visitText(node.getBody()));
    }

    @Override
    public J.Identifier visitIdentifier(IdentifierTree node, java.util.List<Javadoc> body) {
        String name = node.getName().toString();
        this.sourceBefore(name);
        return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), name, null, null);
    }

    @Override
    public Tree visitInheritDoc(InheritDocTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@inheritDoc"));
        return new Javadoc.InheritDoc(Tree.randomId(), Markers.EMPTY, this.endBrace());
    }

    @Override
    public Tree visitLink(LinkTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore(node.getKind() == DocTree.Kind.LINK ? "{@link" : "{@linkplain"));
        java.util.List<Javadoc> spaceBeforeRef = this.whitespaceBefore();
        Javadoc.Reference reference = null;
        J ref = this.visitReference(node.getReference(), body);
        if (ref != null) {
            reference = new Javadoc.Reference(Tree.randomId(), Markers.EMPTY, ref, this.lineBreaksInMultilineJReference());
        }
        java.util.List<Javadoc> label = this.convertMultiline(node.getLabel());
        return new Javadoc.Link(Tree.randomId(), Markers.EMPTY, node.getKind() != DocTree.Kind.LINK, spaceBeforeRef, null, reference, label, this.endBrace());
    }

    @Override
    public Tree visitLiteral(LiteralTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore(node.getKind() == DocTree.Kind.CODE ? "{@code" : "{@literal"));
        java.util.List<Javadoc> description = this.whitespaceBefore();
        description.addAll(this.visitText(node.getBody().getBody()));
        return new Javadoc.Literal(Tree.randomId(), Markers.EMPTY, node.getKind() == DocTree.Kind.CODE, description, this.endBrace());
    }

    @Override
    public Tree visitParam(ParamTree node, java.util.List<Javadoc> body) {
        J typeName;
        java.util.List<Javadoc> spaceBefore;
        body.addAll(this.sourceBefore("@param"));
        DCTree.DCParam param = (DCTree.DCParam)node;
        if (param.isTypeParameter) {
            spaceBefore = this.sourceBefore("<");
            String beforeName = this.whitespaceBeforeAsString();
            Space namePrefix = beforeName.isEmpty() ? Space.EMPTY : Space.build((String)beforeName, Collections.emptyList());
            typeName = new J.TypeParameter(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), (Expression)this.visitIdentifier(node.getName(), this.whitespaceBefore()).withPrefix(namePrefix), null);
            this.sourceBefore(">");
        } else {
            spaceBefore = this.whitespaceBefore();
            typeName = (J)this.scan(node.getName(), body);
        }
        java.util.List<Javadoc> beforeReference = this.lineBreaksInMultilineJReference();
        Javadoc.Reference reference = new Javadoc.Reference(Tree.randomId(), Markers.EMPTY, typeName, beforeReference);
        return new Javadoc.Parameter(Tree.randomId(), Markers.EMPTY, spaceBefore, null, reference, this.convertMultiline(param.getDescription()));
    }

    @Override
    public @Nullable J visitReference(@Nullable ReferenceTree node, java.util.List<Javadoc> body) {
        JavaType qualifierType;
        TypedTree qualifier;
        DCTree.DCReference ref = (DCTree.DCReference)node;
        if (node == null) {
            return null;
        }
        if (ref.qualifierExpression != null) {
            try {
                this.attr.attribType(ref.qualifierExpression, this.symbol);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (ref.qualifierExpression != null) {
            qualifier = (TypedTree)this.javaVisitor.scan(ref.qualifierExpression, Space.EMPTY);
            qualifierType = qualifier.getType();
            if (ref.memberName != null) {
                ++this.cursor;
            }
        } else {
            qualifierType = this.typeMapping.type(this.enclosingClassType);
            if (this.source.charAt(this.cursor) == '#') {
                qualifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "", qualifierType, null);
                ++this.cursor;
            } else {
                qualifier = null;
            }
        }
        if (ref.memberName != null) {
            JavaType.Variable fieldRefType;
            J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), ((Name)ref.memberName).toString(), null, null);
            this.cursor += ((Name)ref.memberName).toString().length();
            JavaType.Method methodRefType = this.methodReferenceType(ref, qualifierType);
            JavaType.Variable variable = fieldRefType = methodRefType == null ? this.fieldReferenceType(ref, qualifierType) : null;
            if (ref.paramTypes != null) {
                JContainer paramContainer;
                this.sourceBeforeAsString("(");
                if (((List)ref.paramTypes).isEmpty()) {
                    paramContainer = JContainer.build((Space)Space.EMPTY, Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.build((String)this.sourceBeforeAsString(")"), Collections.emptyList()), Markers.EMPTY))), (Markers)Markers.EMPTY);
                } else {
                    ArrayList<JRightPadded> parameters = new ArrayList<JRightPadded>(((List)ref.paramTypes).size());
                    java.util.List<JCTree> paramTypes = ref.paramTypes;
                    for (int i = 0; i < paramTypes.size(); ++i) {
                        JCTree param = paramTypes.get(i);
                        Expression paramExpr = (Expression)this.javaVisitor.scan(param, Space.build((String)this.whitespaceBeforeAsString(), Collections.emptyList()));
                        Space rightFmt = Space.format((String)(i == paramTypes.size() - 1 ? this.sourceBeforeAsString(")") : this.sourceBeforeAsString(",")));
                        parameters.add(new JRightPadded((Object)paramExpr, rightFmt, Markers.EMPTY));
                    }
                    paramContainer = JContainer.build((Space)Space.EMPTY, parameters, (Markers)Markers.EMPTY);
                }
                return new J.MethodInvocation(Tree.randomId(), qualifier == null ? Space.EMPTY : qualifier.getPrefix(), Markers.EMPTY, qualifier == null ? null : JRightPadded.build((Object)qualifier.withPrefix(Space.EMPTY)), null, name, paramContainer, methodRefType);
            }
            if (qualifier == null) {
                return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), name.getSimpleName(), qualifierType, fieldRefType);
            }
            return new J.MemberReference(Tree.randomId(), qualifier.getPrefix(), Markers.EMPTY, JRightPadded.build((Object)qualifier.withPrefix(Space.EMPTY)), JContainer.empty(), JLeftPadded.build((Object)name), null, methodRefType, fieldRefType);
        }
        assert (qualifier != null);
        return qualifier;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable JavaType.Method methodReferenceType(DCTree.DCReference ref, @Nullable JavaType type) {
        if (type instanceof JavaType.Class) {
            JavaType.Class classType = (JavaType.Class)type;
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Method method = this.methodReferenceType(ref, classType.getMethods());
            if (method != null) {
                return method;
            }
            method = this.methodReferenceType(ref, (JavaType)classType.getSupertype());
            if (method == null) {
                for (JavaType.FullyQualified interface_ : classType.getInterfaces()) {
                    method = this.methodReferenceType(ref, interface_.getMethods());
                    if (method == null) continue;
                    return method;
                }
            }
            return method;
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)type;
            for (JavaType bound : generic.getBounds()) {
                JavaType.Method method = this.methodReferenceType(ref, bound);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable JavaType.Method methodReferenceType(DCTree.DCReference ref, java.util.List<JavaType.Method> methods) {
        block0: for (JavaType.Method method : methods) {
            if (!((Name)ref.memberName).toString().equals(method.getName()) && !((Name)ref.memberName).toString().equals(method.getConstructorName())) continue;
            if (ref.paramTypes != null) {
                java.util.List parameterTypes = method.getParameterTypes();
                if (((List)ref.paramTypes).size() != parameterTypes.size()) continue;
                for (int i = 0; i < ((List)ref.paramTypes).size(); ++i) {
                    Type paramType;
                    JCTree param = (JCTree)((List)ref.paramTypes).get(i);
                    JavaType testParamType = (JavaType)parameterTypes.get(i);
                    if (!this.paramTypeMatches(testParamType, paramType = this.attr.attribType(param, this.symbol))) continue block0;
                }
            }
            return method;
        }
        return null;
    }

    private boolean paramTypeMatches(JavaType parameterType, Type javadocType) {
        return ReloadableJava8JavadocVisitor.paramTypeMatches(parameterType, this.typeMapping.type(javadocType));
    }

    private static boolean paramTypeMatches(JavaType parameterType, JavaType mappedJavadocType) {
        if (parameterType instanceof JavaType.Array && mappedJavadocType instanceof JavaType.Array) {
            if (((JavaType.Array)parameterType).getElemType() instanceof JavaType.Primitive) {
                return TypeUtils.isAssignableTo((JavaType)parameterType, (JavaType)mappedJavadocType);
            }
            return ReloadableJava8JavadocVisitor.paramTypeMatches(((JavaType.Array)parameterType).getElemType(), ((JavaType.Array)mappedJavadocType).getElemType());
        }
        if (parameterType instanceof JavaType.GenericTypeVariable && !((JavaType.GenericTypeVariable)parameterType).getBounds().isEmpty()) {
            return ReloadableJava8JavadocVisitor.paramTypeMatches((JavaType)((JavaType.GenericTypeVariable)parameterType).getBounds().get(0), mappedJavadocType);
        }
        if (parameterType instanceof JavaType.GenericTypeVariable) {
            return TypeUtils.isObject((JavaType)mappedJavadocType);
        }
        if (parameterType instanceof JavaType.Parameterized && !(mappedJavadocType instanceof JavaType.Parameterized)) {
            return ReloadableJava8JavadocVisitor.paramTypeMatches((JavaType)((JavaType.Parameterized)parameterType).getType(), mappedJavadocType);
        }
        return TypeUtils.isAssignableTo((JavaType)parameterType, (JavaType)mappedJavadocType);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable JavaType.Variable fieldReferenceType(DCTree.DCReference ref, @Nullable JavaType type) {
        JavaType.Class classType = TypeUtils.asClass((JavaType)type);
        if (classType == null) {
            return null;
        }
        for (JavaType.Variable member : classType.getMembers()) {
            if (!member.getName().equals(((Name)ref.memberName).toString())) continue;
            return member;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Variable refType = this.fieldReferenceType(ref, (JavaType)classType.getSupertype());
        if (refType == null) {
            for (JavaType.FullyQualified interface_ : classType.getInterfaces()) {
                for (JavaType.Variable member : interface_.getMembers()) {
                    if (!member.getName().equals(((Name)ref.memberName).toString())) continue;
                    return member;
                }
            }
        }
        return refType;
    }

    @Override
    public Tree visitReturn(ReturnTree node, java.util.List<Javadoc> body) {
        java.util.List<Javadoc> before;
        Markers markers = Markers.EMPTY;
        if (this.source.startsWith("{", this.cursor)) {
            markers = markers.addIfAbsent((Marker)new LeadingBrace(Tree.randomId()));
            before = this.sourceBefore("{@return");
        } else {
            before = this.sourceBefore("@return");
        }
        body.addAll(before);
        return new Javadoc.Return(Tree.randomId(), markers, this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitSee(SeeTree node, java.util.List<Javadoc> body) {
        java.util.List<Javadoc> docs;
        body.addAll(this.sourceBefore("@see"));
        Javadoc.Reference reference = null;
        java.util.List<Javadoc> spaceBeforeTree = this.whitespaceBefore();
        if (node.getReference().get(0) instanceof DCTree.DCReference) {
            J ref = this.visitReference((ReferenceTree)node.getReference().get(0), body);
            if (ref != null) {
                reference = new Javadoc.Reference(Tree.randomId(), Markers.EMPTY, ref, this.lineBreaksInMultilineJReference());
            }
            docs = this.convertMultiline(node.getReference().subList(1, node.getReference().size()));
        } else {
            docs = this.convertMultiline(node.getReference());
        }
        return new Javadoc.See(Tree.randomId(), Markers.EMPTY, spaceBeforeTree, null, reference, docs);
    }

    @Override
    public Tree visitSerial(SerialTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("@serial"));
        return new Javadoc.Serial(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitSerialData(SerialDataTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("@serialData"));
        return new Javadoc.SerialData(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitSerialField(SerialFieldTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("@serialField"));
        return new Javadoc.SerialField(Tree.randomId(), Markers.EMPTY, this.visitIdentifier(node.getName(), this.whitespaceBefore()), this.visitReference(node.getType(), this.whitespaceBefore()), this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitSince(SinceTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("@since"));
        return new Javadoc.Since(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getBody()));
    }

    @Override
    public Tree visitStartElement(StartElementTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("<"));
        String name = node.getName().toString();
        this.cursor += name.length();
        return new Javadoc.StartElement(Tree.randomId(), Markers.EMPTY, name, this.convertMultiline(node.getAttributes()), node.isSelfClosing(), node.isSelfClosing() ? this.sourceBefore("/>") : this.sourceBefore(">"));
    }

    @Override
    public Tree visitVersion(VersionTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("@version"));
        return new Javadoc.Version(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getBody()));
    }

    @Override
    public Tree visitText(TextTree node, java.util.List<Javadoc> body) {
        throw new UnsupportedOperationException("Anywhere text can occur, we need to call the visitText override that returns a list of Javadoc elements.");
    }

    public java.util.List<Javadoc> visitText(String node) {
        ArrayList<Javadoc> texts = new ArrayList<Javadoc>();
        if (!node.isEmpty() && Character.isWhitespace(node.charAt(0)) && !Character.isWhitespace(this.source.charAt(this.cursor))) {
            int i;
            for (i = 0; i < node.length() && Character.isWhitespace(node.charAt(i)); ++i) {
            }
            node = node.substring(i);
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < node.length(); ++i) {
            char c = node.charAt(i);
            if (c == '\n') {
                if (text.length() > 0) {
                    texts.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, text.toString()));
                    text = new StringBuilder();
                }
                ++this.cursor;
                Javadoc.LineBreak lineBreak = this.lineBreaks.remove(this.cursor);
                texts.add((Javadoc)lineBreak);
                continue;
            }
            if (this.source.charAt(this.cursor) != c && (this.source.startsWith(ReloadableJava8JavadocVisitor.unicodeEscaped(c), this.cursor) || this.source.startsWith(ReloadableJava8JavadocVisitor.unicodeEscaped(c).toLowerCase(), this.cursor))) {
                int escapedCharLength = ReloadableJava8JavadocVisitor.unicodeEscaped(c).length();
                text.append(this.source, this.cursor, this.cursor + escapedCharLength);
                this.cursor += escapedCharLength;
                continue;
            }
            text.append(c);
            ++this.cursor;
        }
        if (text.length() > 0) {
            texts.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, text.toString()));
        }
        return texts;
    }

    private static String unicodeEscaped(char c) {
        return String.format("\\u%04X", c);
    }

    @Override
    public Tree visitThrows(ThrowsTree node, java.util.List<Javadoc> body) {
        boolean throwsKeyword = this.source.startsWith("@throws", this.cursor);
        this.sourceBefore(throwsKeyword ? "@throws" : "@exception");
        java.util.List<Javadoc> spaceBeforeExceptionName = this.whitespaceBefore();
        return new Javadoc.Throws(Tree.randomId(), Markers.EMPTY, throwsKeyword, spaceBeforeExceptionName, this.visitReference(node.getExceptionName(), body), this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitUnknownBlockTag(UnknownBlockTagTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("@" + node.getTagName()));
        return new Javadoc.UnknownBlock(Tree.randomId(), Markers.EMPTY, node.getTagName(), this.convertMultiline(node.getContent()));
    }

    @Override
    public Tree visitUnknownInlineTag(UnknownInlineTagTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@" + node.getTagName()));
        return new Javadoc.UnknownInline(Tree.randomId(), Markers.EMPTY, node.getTagName(), this.convertMultiline(node.getContent()), this.endBrace());
    }

    @Override
    public Tree visitValue(ValueTree node, java.util.List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@value"));
        return new Javadoc.InlinedValue(Tree.randomId(), Markers.EMPTY, this.whitespaceBefore(), node.getReference() == null ? null : this.visitReference(node.getReference(), body), this.endBrace());
    }

    private String sourceBeforeAsString(String delim) {
        if (this.cursor >= this.source.length()) {
            return "";
        }
        int endIndex = this.source.indexOf(delim, this.cursor);
        if (endIndex < 0) {
            throw new IllegalStateException("Expected to be able to find " + delim);
        }
        String prefix = this.source.substring(this.cursor, endIndex);
        this.cursor = endIndex + delim.length();
        return prefix;
    }

    private java.util.List<Javadoc> sourceBefore(String delim) {
        if (this.cursor >= this.source.length()) {
            return Collections.emptyList();
        }
        int endIndex = this.source.indexOf(delim, this.cursor);
        if (endIndex < 0) {
            throw new IllegalStateException("Expected to be able to find " + delim);
        }
        java.util.List<Javadoc> before = this.whitespaceBefore();
        this.cursor += delim.length();
        return before;
    }

    private String whitespaceBeforeAsString() {
        int i;
        if (this.cursor >= this.source.length()) {
            return "";
        }
        for (i = this.cursor; i < this.source.length() && Character.isWhitespace(this.source.charAt(i)); ++i) {
        }
        String fmt = this.source.substring(this.cursor, i);
        this.cursor = i;
        return fmt;
    }

    private java.util.List<Javadoc> whitespaceBefore() {
        Javadoc.LineBreak lineBreak;
        if (this.cursor >= this.source.length()) {
            return Collections.emptyList();
        }
        ArrayList<Javadoc> whitespace = new ArrayList<Javadoc>();
        while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
            ++this.cursor;
            whitespace.add((Javadoc)lineBreak);
        }
        StringBuilder space = new StringBuilder();
        while (this.cursor < this.source.length() && Character.isWhitespace(this.source.charAt(this.cursor))) {
            char c = this.source.charAt(this.cursor);
            if (c == '\n') {
                if (space.length() > 0) {
                    whitespace.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, space.toString()));
                }
                space = new StringBuilder();
                lineBreak = this.lineBreaks.remove(this.cursor + 1);
                assert (lineBreak != null);
                whitespace.add((Javadoc)lineBreak);
            } else {
                space.append(c);
            }
            ++this.cursor;
        }
        if (space.length() > 0) {
            whitespace.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, space.toString()));
        }
        return whitespace;
    }

    private java.util.List<Javadoc> endBrace() {
        if (this.cursor < this.source.length()) {
            int tempCursor = this.cursor;
            java.util.List end = this.whitespaceBefore();
            if (this.cursor < this.source.length()) {
                boolean containsEndLine = end.stream().anyMatch(p -> p instanceof Javadoc.LineBreak);
                if (this.source.charAt(this.cursor) == '}') {
                    end = ListUtils.concat(end, (Object)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "}"));
                    ++this.cursor;
                } else if (containsEndLine) {
                    end = ListUtils.concat((java.util.List)end, (Object)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, ""));
                }
                return end;
            }
            this.cursor = tempCursor;
        }
        return Collections.emptyList();
    }

    private java.util.List<Javadoc> convertMultiline(java.util.List<? extends DocTree> dts) {
        Javadoc.LineBreak lineBreak;
        ArrayList<Javadoc> js = new ArrayList<Javadoc>(dts.size());
        while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
            ++this.cursor;
            js.add((Javadoc)lineBreak);
        }
        for (int i = 0; i < dts.size(); ++i) {
            DocTree dt = dts.get(i);
            if (i > 0 && dt instanceof DCTree.DCText) {
                js.addAll(this.visitText(((DCTree.DCText)dt).getBody()));
                continue;
            }
            while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
                ++this.cursor;
                js.add((Javadoc)lineBreak);
            }
            js.addAll(this.whitespaceBefore());
            if (dt instanceof DCTree.DCText) {
                js.addAll(this.visitText(((DCTree.DCText)dt).getBody()));
                continue;
            }
            js.add((Javadoc)this.scan(dt, Collections.emptyList()));
        }
        return js;
    }

    private java.util.List<Javadoc> lineBreaksInMultilineJReference() {
        java.util.List linebreakIndexes = this.lineBreaks.keySet().stream().filter(o -> o <= this.cursor).collect(Collectors.toList());
        java.util.List<Javadoc> referenceLineBreaks = linebreakIndexes.stream().sorted().map(this.lineBreaks::get).collect(Collectors.toList());
        for (Integer key : linebreakIndexes) {
            this.lineBreaks.remove(key);
        }
        return referenceLineBreaks;
    }

    class JavaVisitor
    extends TreeScanner<J, Space> {
        JavaVisitor() {
        }

        @Override
        public J visitMemberSelect(MemberSelectTree node, Space fmt) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node;
            Expression selected = (Expression)this.scan(fieldAccess.selected, Space.EMPTY);
            ReloadableJava8JavadocVisitor.this.sourceBefore(".");
            ReloadableJava8JavadocVisitor.this.cursor = ReloadableJava8JavadocVisitor.this.cursor + fieldAccess.name.toString().length();
            return new J.FieldAccess(Tree.randomId(), fmt, Markers.EMPTY, selected, JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), fieldAccess.name.toString(), null, null)), ReloadableJava8JavadocVisitor.this.typeMapping.type(node));
        }

        @Override
        public J visitIdentifier(com.sun.source.tree.IdentifierTree node, Space fmt) {
            String name = node.getName().toString();
            ReloadableJava8JavadocVisitor.this.cursor = ReloadableJava8JavadocVisitor.this.cursor + name.length();
            JavaType type = ReloadableJava8JavadocVisitor.this.typeMapping.type(node);
            return new J.Identifier(Tree.randomId(), fmt, Markers.EMPTY, Collections.emptyList(), name, type, null);
        }

        @Override
        public J visitPrimitiveType(PrimitiveTypeTree node, Space fmt) {
            JCTree.JCPrimitiveTypeTree primitiveType = (JCTree.JCPrimitiveTypeTree)node;
            String name = primitiveType.toString();
            ReloadableJava8JavadocVisitor.this.cursor = ReloadableJava8JavadocVisitor.this.cursor + name.length();
            return new J.Identifier(Tree.randomId(), fmt, Markers.EMPTY, Collections.emptyList(), name, (JavaType)ReloadableJava8JavadocVisitor.this.typeMapping.primitive(primitiveType.typetag), null);
        }

        @Override
        public J visitArrayType(ArrayTypeTree node, Space fmt) {
            TypeTree elemType = (TypeTree)this.scan(node.getType(), Space.EMPTY);
            int saveCursor = ReloadableJava8JavadocVisitor.this.cursor;
            Space before = this.whitespace();
            if (!ReloadableJava8JavadocVisitor.this.source.startsWith("[", ReloadableJava8JavadocVisitor.this.cursor)) {
                ReloadableJava8JavadocVisitor.this.cursor = saveCursor;
                return elemType.withPrefix(fmt);
            }
            ReloadableJava8JavadocVisitor.this.cursor++;
            JLeftPadded dimension = JLeftPadded.build((Object)Space.build((String)ReloadableJava8JavadocVisitor.this.sourceBeforeAsString("]"), Collections.emptyList())).withBefore(before);
            return new J.ArrayType(Tree.randomId(), fmt, Markers.EMPTY, elemType, null, dimension, ReloadableJava8JavadocVisitor.this.typeMapping.type(node));
        }

        private Space whitespace() {
            int nextNonWhitespace = StringUtils.indexOfNextNonWhitespace((int)ReloadableJava8JavadocVisitor.this.cursor, (String)ReloadableJava8JavadocVisitor.this.source);
            if (nextNonWhitespace == ReloadableJava8JavadocVisitor.this.cursor) {
                return Space.EMPTY;
            }
            Space space = Space.format((String)ReloadableJava8JavadocVisitor.this.source, (int)ReloadableJava8JavadocVisitor.this.cursor, (int)nextNonWhitespace);
            ReloadableJava8JavadocVisitor.this.cursor = nextNonWhitespace;
            return space;
        }

        @Override
        public J visitParameterizedType(ParameterizedTypeTree node, Space fmt) {
            NameTree id = (NameTree)ReloadableJava8JavadocVisitor.this.javaVisitor.scan(node.getType(), Space.EMPTY);
            ArrayList<JRightPadded> expressions = new ArrayList<JRightPadded>(node.getTypeArguments().size());
            String spaceBeforeTypeParams = ReloadableJava8JavadocVisitor.this.whitespaceBeforeAsString();
            ReloadableJava8JavadocVisitor.this.cursor = ReloadableJava8JavadocVisitor.this.cursor + 1;
            int argsSize = node.getTypeArguments().size();
            for (int i = 0; i < argsSize; ++i) {
                Space space = Space.build((String)ReloadableJava8JavadocVisitor.this.whitespaceBeforeAsString(), Collections.emptyList());
                JRightPadded expression = JRightPadded.build((Object)((Expression)ReloadableJava8JavadocVisitor.this.javaVisitor.scan(node.getTypeArguments().get(i), space)));
                Space after = i == argsSize - 1 ? Space.build((String)ReloadableJava8JavadocVisitor.this.sourceBeforeAsString(">"), Collections.emptyList()) : Space.build((String)ReloadableJava8JavadocVisitor.this.sourceBeforeAsString(","), Collections.emptyList());
                expression = expression.withAfter(after);
                expressions.add(expression);
            }
            JContainer typeArgs = JContainer.build(expressions).withBefore(Space.build((String)spaceBeforeTypeParams, Collections.emptyList()));
            return new J.ParameterizedType(Tree.randomId(), fmt, Markers.EMPTY, id, typeArgs, ReloadableJava8JavadocVisitor.this.typeMapping.type(node));
        }
    }
}

