/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.isolated;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaParsingException;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.isolated.ReloadableJava17ParserInputFileObject;
import org.openrewrite.java.isolated.ReloadableJava17ParserVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.slf4j.LoggerFactory;

@NonNullApi
public class ReloadableJava17Parser
implements JavaParser {
    private final JavaTypeCache typeCache;
    @Nullable
    private Collection<Path> classpath;
    @Nullable
    private final Collection<Parser.Input> dependsOn;
    private final JavacFileManager pfm;
    private final Context context;
    private final JavaCompiler compiler;
    private final ResettableLog compilerLog;
    private final Collection<NamedStyles> styles;

    private ReloadableJava17Parser(final boolean logCompilationWarningsAndErrors, @Nullable Collection<Path> classpath, Collection<byte[]> classBytesClasspath, @Nullable Collection<Parser.Input> dependsOn, Charset charset, Collection<NamedStyles> styles, JavaTypeCache typeCache) {
        this.classpath = classpath;
        this.dependsOn = dependsOn;
        this.styles = styles;
        this.typeCache = typeCache;
        this.context = new Context();
        this.compilerLog = new ResettableLog(this.context);
        this.pfm = new ByteArrayCapableJavacFileManager(this.context, true, charset, classBytesClasspath);
        Options.instance(this.context).put("allowStringFolding", "false");
        Options.instance(this.context).put("compilePolicy", "attr");
        Options.instance(this.context).put("-implicit", "none");
        Options.instance(this.context).put("-g", "-g");
        Options.instance(this.context).put("-proc", "none");
        this.compiler = new JavaCompiler(this.context);
        this.compiler.genEndPos = true;
        this.compiler.keepComments = true;
        this.compiler.lineDebugInfo = false;
        this.compilerLog.setWriters(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                String log;
                if (logCompilationWarningsAndErrors && !(log = new String(Arrays.copyOfRange(cbuf, off, len))).isBlank()) {
                    LoggerFactory.getLogger(ReloadableJava17Parser.class).warn(log);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }));
        this.compileDependencies();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit> cus = this.parseInputsToCompilerAst(sourceFiles, ctx);
        return cus.entrySet().stream().map(cuByPath -> {
            Parser.Input input = (Parser.Input)cuByPath.getKey();
            parsingListener.startedParsing(input);
            try {
                ReloadableJava17ParserVisitor parser = new ReloadableJava17ParserVisitor(input.getRelativePath(relativeTo), input.getFileAttributes(), input.getSource(ctx), this.styles, this.typeCache, ctx, this.context);
                J.CompilationUnit cu = (J.CompilationUnit)parser.scan((Tree)cuByPath.getValue(), Space.EMPTY);
                cuByPath.setValue(null);
                parsingListener.parsed(input, (SourceFile)cu);
                return this.requirePrintEqualsInput((SourceFile)cu, input, relativeTo, ctx);
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        });
    }

    LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit> parseInputsToCompilerAst(Iterable<Parser.Input> sourceFiles, ExecutionContext ctx) {
        if (this.classpath != null) {
            if (this.context.get(JavaFileManager.class) != this.pfm) {
                throw new IllegalStateException("JavaFileManager has been forked unexpectedly");
            }
            try {
                this.pfm.setLocationFromPaths(StandardLocation.CLASS_PATH, new ArrayList<Path>(this.classpath));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit> cus = new LinkedHashMap<Parser.Input, JCTree.JCCompilationUnit>();
        this.acceptedInputs(sourceFiles).forEach(input1 -> {
            try {
                JCTree.JCCompilationUnit jcCompilationUnit = this.compiler.parse(new ReloadableJava17ParserInputFileObject((Parser.Input)input1, ctx));
                cus.put((Parser.Input)input1, jcCompilationUnit);
            }
            catch (IllegalStateException e) {
                if ("endPosTable already set".equals(e.getMessage())) {
                    throw new IllegalStateException("Call reset() on JavaParser before parsing another set of source files that have some of the same fully qualified names. Source file [" + input1.getPath() + "]\n[\n" + StringUtils.readFully((InputStream)input1.getSource(ctx), (Charset)this.getCharset(ctx)) + "\n]", e);
                }
                throw e;
            }
        });
        try {
            this.initModules(cus.values());
            this.enterAll(cus.values());
            Annotate annotate = Annotate.instance(this.context);
            while (annotate.annotationsBlocked()) {
                annotate.unblockAnnotations();
            }
            this.compiler.attribute(this.compiler.todo);
        }
        catch (Throwable t) {
            ctx.getOnError().accept(new JavaParsingException("Failed symbol entering or attribution", t));
        }
        return cus;
    }

    public ReloadableJava17Parser reset() {
        this.typeCache.clear();
        this.compilerLog.reset();
        this.pfm.flush();
        Check.instance(this.context).newRound();
        Annotate.instance(this.context).newRound();
        Enter.instance(this.context).newRound();
        Modules.instance(this.context).newRound();
        this.compileDependencies();
        return this;
    }

    public JavaParser reset(Collection<URI> uris) {
        if (!uris.isEmpty()) {
            this.compilerLog.reset(uris);
        }
        this.pfm.flush();
        Check.instance(this.context).newRound();
        Annotate.instance(this.context).newRound();
        Enter.instance(this.context).newRound();
        Modules.instance(this.context).newRound();
        return this;
    }

    public void setClasspath(Collection<Path> classpath) {
        this.classpath = classpath;
    }

    private void compileDependencies() {
        if (this.dependsOn != null) {
            InMemoryExecutionContext ctx = new InMemoryExecutionContext();
            ctx.putMessage("org.openrewrite.java.skipSourceSetMarker", (Object)true);
            this.parseInputs(this.dependsOn, null, (ExecutionContext)ctx);
        }
        Modules.instance(this.context).newRound();
    }

    private void initModules(Collection<JCTree.JCCompilationUnit> cus) {
        Modules modules = Modules.instance(this.context);
        modules.newRound();
        modules.initModules(List.from(cus));
    }

    private void enterAll(Collection<JCTree.JCCompilationUnit> cus) {
        Enter enter = Enter.instance(this.context);
        List<JCTree.JCCompilationUnit> compilationUnits = List.from((JCTree.JCCompilationUnit[])cus.toArray(JCTree.JCCompilationUnit[]::new));
        enter.main(compilationUnits);
    }

    private static class ResettableLog
    extends Log {
        protected ResettableLog(Context context) {
            super(context);
        }

        public void reset() {
            this.sourceMap.clear();
        }

        public void reset(Collection<URI> uris) {
            this.sourceMap.keySet().removeIf(f -> uris.contains(f.toUri()));
        }
    }

    private static class ByteArrayCapableJavacFileManager
    extends JavacFileManager {
        private final java.util.List<PackageAwareJavaFileObject> classByteClasspath;

        public ByteArrayCapableJavacFileManager(Context context, boolean register, Charset charset, Collection<byte[]> classByteClasspath) {
            super(context, register, charset);
            this.classByteClasspath = classByteClasspath.stream().map(PackageAwareJavaFileObject::new).collect(Collectors.toList());
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof PackageAwareJavaFileObject) {
                return ((PackageAwareJavaFileObject)file).getClassName();
            }
            return super.inferBinaryName(location, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            if (StandardLocation.CLASS_PATH.equals(location)) {
                Iterable listed = super.list(location, packageName, kinds, recurse);
                return this.classByteClasspath.isEmpty() ? listed : (Iterable)Stream.concat(this.classByteClasspath.stream().filter(jfo -> jfo.getPackage().equals(packageName)), StreamSupport.stream(listed.spliterator(), false)).collect(Collectors.toList());
            }
            return super.list(location, packageName, kinds, recurse);
        }
    }

    public static class Builder
    extends JavaParser.Builder<ReloadableJava17Parser, Builder> {
        public ReloadableJava17Parser build() {
            return new ReloadableJava17Parser(this.logCompilationWarningsAndErrors, this.classpath, this.classBytesClasspath, this.dependsOn, this.charset, this.styles, this.javaTypeCache);
        }
    }

    private static class PackageAwareJavaFileObject
    extends SimpleJavaFileObject {
        private final String pkg;
        private final String className;
        private final byte[] classBytes;

        private PackageAwareJavaFileObject(byte[] classBytes) {
            super(URI.create("file:///.byteArray"), JavaFileObject.Kind.CLASS);
            final AtomicReference pkgRef = new AtomicReference();
            final AtomicReference nameRef = new AtomicReference();
            ClassReader classReader = new ClassReader(classBytes);
            classReader.accept(new ClassVisitor(589824){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (name.contains("/")) {
                        pkgRef.set(name.substring(0, name.lastIndexOf(47)).replace('/', '.'));
                        nameRef.set(name.substring(name.lastIndexOf(47) + 1));
                    } else {
                        pkgRef.set("");
                        nameRef.set(name);
                    }
                }
            }, 7);
            this.pkg = (String)pkgRef.get();
            this.className = (String)nameRef.get();
            this.classBytes = classBytes;
        }

        public String getPackage() {
            return this.pkg;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.classBytes);
        }
    }
}

