/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.Java17Parser;

public class Java17UnrestrictedClassLoader
extends ClassLoader {
    final List<Path> modules;

    public Java17UnrestrictedClassLoader(ClassLoader parentClassloader) {
        super(parentClassloader);
        FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
        this.modules = List.of(fs.getPath("modules", "jdk.compiler"), fs.getPath("modules", "java.compiler"), fs.getPath("modules", "java.base"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            String internalName = name.replace('.', '/') + ".class";
            Class<?> _class = this.loadIsolatedClass(name);
            if (_class != null) {
                return _class;
            }
            if (name.startsWith("com.sun") || name.startsWith("sun")) {
                try {
                    for (Path path : this.modules) {
                        Path classFile = path.resolve(internalName);
                        if (!Files.exists(classFile, new LinkOption[0])) continue;
                        byte[] bytes = Files.readAllBytes(classFile);
                        return this.defineClass(name, bytes, 0, bytes.length);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return super.loadClass(name);
    }

    @Override
    @Nullable
    public URL getResource(String name) {
        try {
            for (Path path : this.modules) {
                Path classFile = path.resolve(name);
                if (!Files.exists(classFile, new LinkOption[0])) continue;
                return classFile.toUri().toURL();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return super.getResource(name);
    }

    @Nullable
    private Class<?> loadIsolatedClass(String className) {
        Class<?> clazz;
        block11: {
            if (!className.startsWith("org.openrewrite.java.isolated")) {
                return null;
            }
            String internalName = className.replace('.', '/') + ".class";
            URL url = Java17Parser.class.getClassLoader().getResource(internalName);
            if (url == null) {
                return null;
            }
            InputStream stream = url.openStream();
            try {
                int bytesRead;
                ByteArrayOutputStream classBytes = new ByteArrayOutputStream();
                byte[] bytes = new byte[4096];
                while ((bytesRead = stream.read(bytes)) > 0) {
                    classBytes.write(bytes, 0, bytesRead);
                }
                clazz = this.defineClass(className, classBytes.toByteArray(), 0, classBytes.size());
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return clazz;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

