/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.CommentsAndFormatting;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java11ParserVisitor
extends TreePathScanner<J, CommentsAndFormatting> {
    private static final Logger logger = LoggerFactory.getLogger(Java11ParserVisitor.class);
    private final Path path;
    private final String source;
    private final boolean relaxedClassTypeMatching;
    private final Collection<JavaStyle> styles;
    private final Map<String, JavaType.Class> sharedClassTypes;
    private EndPosTable endPosTable;
    private int cursor = 0;
    private final Function<com.sun.source.tree.Tree, String> statementDelim = t -> {
        if (t instanceof JCTree.JCThrow || t instanceof JCTree.JCBreak || t instanceof JCTree.JCAssert || t instanceof JCTree.JCContinue || t instanceof JCTree.JCExpressionStatement || t instanceof JCTree.JCReturn || t instanceof JCTree.JCVariableDecl || t instanceof JCTree.JCDoWhileLoop || t instanceof JCTree.JCSkip) {
            return this.sourceBefore(";");
        }
        if (t instanceof JCTree.JCCase) {
            return this.sourceBefore(":");
        }
        if (t instanceof JCTree.JCMethodDecl) {
            return this.sourceBefore(((JCTree.JCMethodDecl)t).body == null ? ";" : "");
        }
        return this.sourceBefore("");
    };
    private final Map<Long, Flag> flagMasks = Map.of(1L, Flag.Public, 2L, Flag.Private, 4L, Flag.Protected, 8L, Flag.Static, 16L, Flag.Final, 32L, Flag.Synchronized, 64L, Flag.Volatile, 128L, Flag.Transient, 1024L, Flag.Abstract);
    private final Function<com.sun.source.tree.Tree, String> semiDelim = ignored -> this.sourceBefore(";");
    private final Function<com.sun.source.tree.Tree, String> commaDelim = ignored -> this.sourceBefore(",");
    private final Function<com.sun.source.tree.Tree, String> noDelim = ignored -> "";

    public Java11ParserVisitor(Path path, String source, boolean relaxedClassTypeMatching, Collection<JavaStyle> styles, Map<String, JavaType.Class> sharedClassTypes) {
        this.path = path;
        this.source = source;
        this.relaxedClassTypeMatching = relaxedClassTypeMatching;
        this.styles = styles;
        this.sharedClassTypes = sharedClassTypes;
    }

    @Override
    public J visitAnnotation(AnnotationTree node, CommentsAndFormatting fmt) {
        this.skip("@");
        NameTree name = (NameTree)this.convert(node.getAnnotationType());
        J.Annotation.Arguments args = null;
        if (node.getArguments().size() > 0) {
            ExpressionTree arg;
            CommentsAndFormatting argsFmt = CommentsAndFormatting.format(this.sourceBefore("("));
            List<Object> expressions = node.getArguments().size() == 1 ? ((arg = node.getArguments().get(0)) instanceof JCTree.JCAssign ? (this.endPos(arg) < 0 ? Collections.singletonList((Expression)this.convert(((JCTree.JCAssign)arg).rhs, t -> this.sourceBefore(")"))) : Collections.singletonList((Expression)this.convert(arg, t -> this.sourceBefore(")")))) : Collections.singletonList((Expression)this.convert(arg, t -> this.sourceBefore(")")))) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")"));
            args = new J.Annotation.Arguments(Tree.randomId(), expressions, argsFmt.getComments(), argsFmt.getFormatting(), Markers.EMPTY);
        } else {
            String remaining = this.source.substring(this.cursor, this.endPos(node));
            if (remaining.contains("(") && remaining.contains(")")) {
                CommentsAndFormatting parensFmt = CommentsAndFormatting.format(this.sourceBefore("("));
                CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore(")"));
                args = new J.Annotation.Arguments(Tree.randomId(), Collections.singletonList(new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY)), parensFmt.getComments(), parensFmt.getFormatting(), Markers.EMPTY);
            }
        }
        return new J.Annotation(Tree.randomId(), name, args, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitArrayAccess(ArrayAccessTree node, CommentsAndFormatting fmt) {
        Expression indexed = (Expression)this.convert(node.getExpression());
        CommentsAndFormatting dimensionFmt = CommentsAndFormatting.format(this.sourceBefore("["));
        J.ArrayAccess.Dimension dimension = new J.ArrayAccess.Dimension(Tree.randomId(), (Expression)this.convert(node.getIndex(), t -> this.sourceBefore("]")), dimensionFmt.getComments(), dimensionFmt.getFormatting(), Markers.EMPTY);
        return new J.ArrayAccess(Tree.randomId(), indexed, dimension, this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitArrayType(ArrayTypeTree node, CommentsAndFormatting fmt) {
        com.sun.source.tree.Tree typeIdent = node.getType();
        int dimCount = 1;
        while (typeIdent instanceof ArrayTypeTree) {
            ++dimCount;
            typeIdent = ((ArrayTypeTree)typeIdent).getType();
        }
        TypeTree elemType = (TypeTree)this.convert(typeIdent);
        List dimensions = IntStream.range(0, dimCount).mapToObj(n -> {
            CommentsAndFormatting dimFmt = CommentsAndFormatting.format(this.sourceBefore("["));
            CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore("]"));
            return new J.ArrayType.Dimension(Tree.randomId(), new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY), dimFmt.getComments(), dimFmt.getFormatting(), Markers.EMPTY);
        }).collect(Collectors.toList());
        return new J.ArrayType(Tree.randomId(), elemType, dimensions, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitAssert(AssertTree node, CommentsAndFormatting fmt) {
        this.skip("assert");
        return new J.Assert(Tree.randomId(), (Expression)this.convert(((JCTree.JCAssert)node).cond), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitAssignment(AssignmentTree node, CommentsAndFormatting fmt) {
        Expression variable = (Expression)this.convert(node.getVariable(), t -> this.sourceBefore("="));
        return new J.Assign(Tree.randomId(), variable, (Expression)this.convert(node.getExpression()), this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitBinary(BinaryTree node, CommentsAndFormatting fmt) {
        J.Binary.Operator.Addition op;
        Expression left = (Expression)this.convert(node.getLeftOperand());
        CommentsAndFormatting opPrefix = CommentsAndFormatting.format(this.whitespace());
        switch (((JCTree.JCBinary)node).getTag()) {
            case PLUS: {
                this.skip("+");
                op = new J.Binary.Operator.Addition(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case MINUS: {
                this.skip("-");
                op = new J.Binary.Operator.Subtraction(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case DIV: {
                this.skip("/");
                op = new J.Binary.Operator.Division(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case MUL: {
                this.skip("*");
                op = new J.Binary.Operator.Multiplication(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case MOD: {
                this.skip("%");
                op = new J.Binary.Operator.Modulo(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case AND: {
                this.skip("&&");
                op = new J.Binary.Operator.And(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case OR: {
                this.skip("||");
                op = new J.Binary.Operator.Or(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case BITAND: {
                this.skip("&");
                op = new J.Binary.Operator.BitAnd(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case BITOR: {
                this.skip("|");
                op = new J.Binary.Operator.BitOr(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case BITXOR: {
                this.skip("^");
                op = new J.Binary.Operator.BitXor(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case SL: {
                this.skip("<<");
                op = new J.Binary.Operator.LeftShift(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case SR: {
                this.skip(">>");
                op = new J.Binary.Operator.RightShift(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case USR: {
                this.skip(">>>");
                op = new J.Binary.Operator.UnsignedRightShift(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case LT: {
                this.skip("<");
                op = new J.Binary.Operator.LessThan(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case GT: {
                this.skip(">");
                op = new J.Binary.Operator.GreaterThan(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case LE: {
                this.skip("<=");
                op = new J.Binary.Operator.LessThanOrEqual(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case GE: {
                this.skip(">=");
                op = new J.Binary.Operator.GreaterThanOrEqual(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case EQ: {
                this.skip("==");
                op = new J.Binary.Operator.Equal(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case NE: {
                this.skip("!=");
                op = new J.Binary.Operator.NotEqual(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected binary tag " + ((JCTree.JCBinary)node).getTag());
            }
        }
        return new J.Binary(Tree.randomId(), left, (J.Binary.Operator)op, (Expression)this.convert(node.getRightOperand()), this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitBlock(BlockTree node, CommentsAndFormatting fmt) {
        J.Empty stat = null;
        if ((((JCTree.JCBlock)node).flags & 8L) != 0L) {
            this.skip("static");
            CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore("{"));
            stat = new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY);
        } else {
            this.skip("{");
        }
        ArrayList<StatementTree> statementTrees = new ArrayList<StatementTree>();
        for (StatementTree statementTree : node.getStatements()) {
            if (this.endPos(statementTree) <= 0) continue;
            statementTrees.add(statementTree);
        }
        List statements = this.convertPossibleMultiVariable(statementTrees);
        CommentsAndFormatting commentsAndFormatting = CommentsAndFormatting.format(this.sourceBefore("}"));
        return new J.Block(Tree.randomId(), stat, statements, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY, new J.Block.End(Tree.randomId(), commentsAndFormatting.getComments(), commentsAndFormatting.getFormatting(), Markers.EMPTY));
    }

    @Override
    public J visitBreak(BreakTree node, CommentsAndFormatting fmt) {
        this.skip("break");
        J.Ident label = null;
        Name labelName = node.getLabel();
        if (labelName != null) {
            CommentsAndFormatting labelFmt = CommentsAndFormatting.format(this.sourceBefore(labelName.toString()));
            label = J.Ident.build((UUID)Tree.randomId(), (String)labelName.toString(), null, labelFmt.getComments(), (Formatting)labelFmt.getFormatting(), (Markers)Markers.EMPTY);
            this.skip(labelName.toString());
        }
        return new J.Break(Tree.randomId(), label, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitCase(CaseTree node, CommentsAndFormatting fmt) {
        Expression pattern = (Expression)this.convertOrNull(node.getExpression(), t -> this.sourceBefore(":"));
        if (pattern == null) {
            String def = this.skip("default");
            CommentsAndFormatting caseFmt = CommentsAndFormatting.format(this.sourceBefore(":"));
            pattern = J.Ident.build((UUID)Tree.randomId(), (String)def, null, caseFmt.getComments(), (Formatting)caseFmt.getFormatting(), (Markers)Markers.EMPTY);
        }
        return new J.Case(Tree.randomId(), pattern, this.convertPossibleMultiVariable(node.getStatements()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitCatch(CatchTree node, CommentsAndFormatting fmt) {
        this.skip("catch");
        CommentsAndFormatting paramFmt = CommentsAndFormatting.format(this.sourceBefore("("));
        J.VariableDecls paramDecl = (J.VariableDecls)this.convert(node.getParameter(), t -> this.sourceBefore(")"));
        J.Parentheses param = new J.Parentheses(Tree.randomId(), (J)paramDecl, paramFmt.getComments(), paramFmt.getFormatting(), Markers.EMPTY);
        return new J.Try.Catch(Tree.randomId(), param, (J.Block)this.convert(node.getBlock()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitClass(ClassTree node, CommentsAndFormatting fmt) {
        J.ClassDecl.Kind.Enum kind;
        List annotations = this.convertAll(node.getModifiers().getAnnotations(), this.noDelim, this.noDelim);
        List<J.Modifier> modifiers = this.sortedFlags(node.getModifiers());
        if (this.hasFlag(node.getModifiers(), 16384L)) {
            CommentsAndFormatting enumFmt = CommentsAndFormatting.format(this.sourceBefore("enum"));
            kind = new J.ClassDecl.Kind.Enum(Tree.randomId(), enumFmt.getComments(), enumFmt.getFormatting(), Markers.EMPTY);
        } else if (this.hasFlag(node.getModifiers(), 8192L)) {
            CommentsAndFormatting annotFmt = CommentsAndFormatting.format(this.sourceBefore("@interface"));
            kind = new J.ClassDecl.Kind.Annotation(Tree.randomId(), annotFmt.getComments(), annotFmt.getFormatting(), Markers.EMPTY);
        } else if (this.hasFlag(node.getModifiers(), 512L)) {
            CommentsAndFormatting intFmt = CommentsAndFormatting.format(this.sourceBefore("interface"));
            kind = new J.ClassDecl.Kind.Interface(Tree.randomId(), intFmt.getComments(), intFmt.getFormatting(), Markers.EMPTY);
        } else {
            CommentsAndFormatting clazzFmt = CommentsAndFormatting.format(this.sourceBefore("class"));
            kind = new J.ClassDecl.Kind.Class(Tree.randomId(), clazzFmt.getComments(), clazzFmt.getFormatting(), Markers.EMPTY);
        }
        CommentsAndFormatting nameFmt = CommentsAndFormatting.format(this.sourceBefore(node.getSimpleName().toString()));
        J.Ident name = J.Ident.build((UUID)Tree.randomId(), (String)((JCTree.JCClassDecl)node).getSimpleName().toString(), (JavaType)this.type(node), nameFmt.getComments(), (Formatting)nameFmt.getFormatting(), (Markers)Markers.EMPTY);
        J.TypeParameters typeParams = null;
        if (!node.getTypeParameters().isEmpty()) {
            CommentsAndFormatting paramsFmt = CommentsAndFormatting.format(this.sourceBefore("<"));
            List params = this.convertAll(node.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">"));
            typeParams = new J.TypeParameters(Tree.randomId(), params, paramsFmt.getComments(), paramsFmt.getFormatting(), Markers.EMPTY);
        }
        J.ClassDecl.Extends extendings = null;
        if (node.getExtendsClause() != null) {
            CommentsAndFormatting extendsFmt = CommentsAndFormatting.format(this.sourceBefore("extends"));
            TypeTree extendsClause = (TypeTree)this.convertOrNull(node.getExtendsClause());
            extendings = new J.ClassDecl.Extends(Tree.randomId(), extendsClause, extendsFmt.getComments(), extendsFmt.getFormatting(), Markers.EMPTY);
        }
        J.ClassDecl.Implements implementings = null;
        if (node.getImplementsClause() != null && !node.getImplementsClause().isEmpty()) {
            CommentsAndFormatting implementsFmt = CommentsAndFormatting.format(this.sourceBefore(kind instanceof J.ClassDecl.Kind.Interface ? "extends" : "implements"));
            List from = this.convertAll(node.getImplementsClause(), this.commaDelim, this.noDelim);
            implementings = new J.ClassDecl.Implements(Tree.randomId(), from, implementsFmt.getComments(), implementsFmt.getFormatting(), Markers.EMPTY);
        }
        CommentsAndFormatting bodyFmt = CommentsAndFormatting.format(this.sourceBefore("{"));
        ArrayList<com.sun.source.tree.Tree> jcEnums = new ArrayList<com.sun.source.tree.Tree>();
        for (com.sun.source.tree.Tree tree : node.getMembers()) {
            if (!(tree instanceof JCTree.JCVariableDecl) || !this.hasFlag(((JCTree.JCVariableDecl)tree).getModifiers(), 16384L)) continue;
            jcEnums.add(tree);
        }
        J.EnumValueSet enumSet = null;
        if (!jcEnums.isEmpty()) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            List enumValues = this.convertAll(jcEnums, this.commaDelim, t -> {
                semicolonPresent.set(this.positionOfNext(";", Character.valueOf('}')) > 0);
                return semicolonPresent.get() ? this.sourceBefore(";", Character.valueOf('}')) : "";
            });
            enumSet = new J.EnumValueSet(Tree.randomId(), enumValues, atomicBoolean.get(), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY);
        }
        ArrayList<com.sun.source.tree.Tree> arrayList = new ArrayList<com.sun.source.tree.Tree>();
        for (com.sun.source.tree.Tree tree : node.getMembers()) {
            if (tree instanceof JCTree.JCMethodDecl && this.hasFlag(((JCTree.JCMethodDecl)tree).getModifiers(), 0x1000000000L) || tree instanceof JCTree.JCVariableDecl && this.hasFlag(((JCTree.JCVariableDecl)tree).getModifiers(), 16384L)) continue;
            arrayList.add(tree);
        }
        ArrayList<Object> members = new ArrayList<Object>();
        if (enumSet != null) {
            members.add(enumSet);
        }
        members.addAll(this.convertPossibleMultiVariable(arrayList));
        CommentsAndFormatting commentsAndFormatting = CommentsAndFormatting.format(this.sourceBefore("}"));
        J.Block body = new J.Block(Tree.randomId(), null, members, bodyFmt.getComments(), bodyFmt.getFormatting(), Markers.EMPTY, new J.Block.End(Tree.randomId(), commentsAndFormatting.getComments(), commentsAndFormatting.getFormatting(), Markers.EMPTY));
        return new J.ClassDecl(Tree.randomId(), annotations, modifiers, (J.ClassDecl.Kind)kind, name, typeParams, extendings, implementings, body, (JavaType.Class)this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitCompilationUnit(CompilationUnitTree node, CommentsAndFormatting fmt) {
        CommentsAndFormatting endFmt;
        logger.debug("Building AST for: " + this.path);
        JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)node;
        CommentsAndFormatting prefix = CommentsAndFormatting.format(this.source.substring(0, cu.getStartPosition()));
        this.cursor(cu.getStartPosition());
        this.endPosTable = cu.endPositions;
        J.Package packageDecl = null;
        if (cu.getPackageName() != null) {
            CommentsAndFormatting packageFmt = CommentsAndFormatting.format(this.sourceBefore("package"));
            Expression packageName = (Expression)this.convert(cu.getPackageName());
            endFmt = CommentsAndFormatting.format(this.sourceBefore(";"));
            packageDecl = new J.Package(Tree.randomId(), packageName, new J.Empty(Tree.randomId(), endFmt.getComments(), endFmt.getFormatting(), Markers.EMPTY), packageFmt.getComments(), packageFmt.getFormatting(), Markers.EMPTY);
        }
        List imports = this.convertAll(node.getImports(), this.semiDelim, this.semiDelim);
        List classDecls = this.convertAll(node.getTypeDecls().stream().filter(JCTree.JCClassDecl.class::isInstance).collect(Collectors.toList()), this::whitespace, this.noDelim);
        endFmt = CommentsAndFormatting.format(this.source.substring(this.cursor));
        return new J.CompilationUnit(Tree.randomId(), this.path, packageDecl, imports, classDecls, new J.Empty(Tree.randomId(), endFmt.getComments(), endFmt.getFormatting(), Markers.EMPTY), prefix.getComments(), prefix.getFormatting(), Markers.EMPTY, this.styles);
    }

    @Override
    public J visitCompoundAssignment(CompoundAssignmentTree node, CommentsAndFormatting fmt) {
        J.AssignOp.Operator.Addition op;
        Expression left = (Expression)this.convert(((JCTree.JCAssignOp)node).lhs);
        CommentsAndFormatting opPrefix = CommentsAndFormatting.format(this.whitespace());
        switch (((JCTree.JCAssignOp)node).getTag()) {
            case PLUS_ASG: {
                this.skip("+=");
                op = new J.AssignOp.Operator.Addition(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case MINUS_ASG: {
                this.skip("-=");
                op = new J.AssignOp.Operator.Subtraction(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case DIV_ASG: {
                this.skip("/=");
                op = new J.AssignOp.Operator.Division(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case MUL_ASG: {
                this.skip("*=");
                op = new J.AssignOp.Operator.Multiplication(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case MOD_ASG: {
                this.skip("%=");
                op = new J.AssignOp.Operator.Modulo(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case BITAND_ASG: {
                this.skip("&=");
                op = new J.AssignOp.Operator.BitAnd(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case BITOR_ASG: {
                this.skip("|=");
                op = new J.AssignOp.Operator.BitOr(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case BITXOR_ASG: {
                this.skip("^=");
                op = new J.AssignOp.Operator.BitXor(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case SL_ASG: {
                this.skip("<<=");
                op = new J.AssignOp.Operator.LeftShift(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case SR_ASG: {
                this.skip(">>=");
                op = new J.AssignOp.Operator.RightShift(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            case USR_ASG: {
                this.skip(">>>=");
                op = new J.AssignOp.Operator.UnsignedRightShift(Tree.randomId(), opPrefix.getComments(), opPrefix.getFormatting(), Markers.EMPTY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected compound assignment tag " + ((JCTree.JCAssignOp)node).getTag());
            }
        }
        return new J.AssignOp(Tree.randomId(), left, (J.AssignOp.Operator)op, (Expression)this.convert(((JCTree.JCAssignOp)node).rhs), this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitConditionalExpression(ConditionalExpressionTree node, CommentsAndFormatting fmt) {
        return new J.Ternary(Tree.randomId(), (Expression)this.convert(node.getCondition(), t -> this.sourceBefore("?")), (Expression)this.convert(node.getTrueExpression(), t -> this.sourceBefore(":")), (Expression)this.convert(node.getFalseExpression()), this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitContinue(ContinueTree node, CommentsAndFormatting fmt) {
        this.skip("continue");
        Name label = node.getLabel();
        J.Ident labelIdent = null;
        if (label != null) {
            CommentsAndFormatting labelFmt = CommentsAndFormatting.format(this.sourceBefore(label.toString()));
            labelIdent = J.Ident.build((UUID)Tree.randomId(), (String)label.toString(), null, labelFmt.getComments(), (Formatting)labelFmt.getFormatting(), (Markers)Markers.EMPTY);
        }
        return new J.Continue(Tree.randomId(), labelIdent, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitDoWhileLoop(DoWhileLoopTree node, CommentsAndFormatting fmt) {
        this.skip("do");
        Statement stat = (Statement)this.convert(node.getStatement());
        CommentsAndFormatting whileFmt = CommentsAndFormatting.format(this.sourceBefore("while"));
        J.Parentheses condition = (J.Parentheses)this.convert(node.getCondition());
        return new J.DoWhileLoop(Tree.randomId(), stat, new J.DoWhileLoop.While(Tree.randomId(), condition, whileFmt.getComments(), whileFmt.getFormatting(), Markers.EMPTY), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitEmptyStatement(EmptyStatementTree node, CommentsAndFormatting fmt) {
        return new J.Empty(Tree.randomId(), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitEnhancedForLoop(EnhancedForLoopTree node, CommentsAndFormatting fmt) {
        this.skip("for");
        CommentsAndFormatting ctrlFmt = CommentsAndFormatting.format(this.sourceBefore("("));
        J.VariableDecls variable = (J.VariableDecls)this.convert(node.getVariable(), t -> this.sourceBefore(":"));
        Expression expression = (Expression)this.convert(node.getExpression(), t -> this.sourceBefore(")"));
        return new J.ForEachLoop(Tree.randomId(), new J.ForEachLoop.Control(Tree.randomId(), variable, expression, ctrlFmt.getComments(), ctrlFmt.getFormatting(), Markers.EMPTY), (Statement)this.convert(node.getStatement(), this.statementDelim), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    private J visitEnumVariable(VariableTree node, CommentsAndFormatting fmt) {
        this.skip(node.getName().toString());
        J.Ident name = J.Ident.build((UUID)Tree.randomId(), (String)node.getName().toString(), (JavaType)this.type(node), Collections.emptyList(), (Formatting)Formatting.EMPTY, (Markers)Markers.EMPTY);
        J.NewClass initializer = null;
        if (this.source.charAt(this.endPos(node) - 1) == ')' || this.source.charAt(this.endPos(node) - 1) == '}') {
            initializer = (J.NewClass)this.convert(node.getInitializer());
        }
        return new J.EnumValue(Tree.randomId(), name, initializer, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitForLoop(ForLoopTree node, CommentsAndFormatting fmt) {
        List<Object> update;
        this.skip("for");
        CommentsAndFormatting ctrlFmt = CommentsAndFormatting.format(this.sourceBefore("("));
        Statement init = this.convertPossibleMultiVariable(node.getInitializer()).stream().filter(Statement.class::isInstance).map(Statement.class::cast).findAny().orElseGet(() -> {
            CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore(";"));
            return new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY);
        });
        Expression condition = (Expression)this.convertOrNull(node.getCondition(), this.semiDelim);
        if (condition == null) {
            CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore(";"));
            condition = new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY);
        }
        if (node.getUpdate().isEmpty()) {
            CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore(")"));
            update = Collections.singletonList(new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY));
        } else {
            update = new ArrayList();
            List<? extends ExpressionStatementTree> nodeUpdate = node.getUpdate();
            for (int i = 0; i < nodeUpdate.size(); ++i) {
                ExpressionStatementTree tree = nodeUpdate.get(i);
                update.add((Statement)this.convert(tree, i == nodeUpdate.size() - 1 ? t -> this.sourceBefore(")") : this.commaDelim));
            }
        }
        return new J.ForLoop(Tree.randomId(), new J.ForLoop.Control(Tree.randomId(), init, condition, update, ctrlFmt.getComments(), ctrlFmt.getFormatting(), Markers.EMPTY), (Statement)this.convert(node.getStatement(), this.statementDelim), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitIdentifier(IdentifierTree node, CommentsAndFormatting fmt) {
        this.cursor += node.getName().toString().length();
        return J.Ident.build((UUID)Tree.randomId(), (String)node.getName().toString(), (JavaType)this.type(node), fmt.getComments(), (Formatting)fmt.getFormatting(), (Markers)Markers.EMPTY);
    }

    @Override
    public J visitIf(IfTree node, CommentsAndFormatting fmt) {
        this.skip("if");
        J.Parentheses ifPart = (J.Parentheses)this.convert(node.getCondition());
        Statement then = (Statement)this.convert(node.getThenStatement());
        J.If.Else elsePart = null;
        if (node.getElseStatement() instanceof JCTree.JCStatement) {
            CommentsAndFormatting elseFmt = CommentsAndFormatting.format(this.sourceBefore("else"));
            elsePart = new J.If.Else(Tree.randomId(), (Statement)this.convert(node.getElseStatement(), this.statementDelim), elseFmt.getComments(), elseFmt.getFormatting(), Markers.EMPTY);
        }
        return new J.If(Tree.randomId(), ifPart, then, elsePart, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitImport(ImportTree node, CommentsAndFormatting fmt) {
        this.skip("import");
        this.skipPattern("\\s+static");
        return new J.Import(Tree.randomId(), (J.FieldAccess)this.convert(node.getQualifiedIdentifier()), node.isStatic(), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitInstanceOf(InstanceOfTree node, CommentsAndFormatting fmt) {
        return new J.InstanceOf(Tree.randomId(), (Expression)this.convert(node.getExpression(), t -> this.sourceBefore("instanceof")), this.convert(node.getType()), this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitLabeledStatement(LabeledStatementTree node, CommentsAndFormatting fmt) {
        this.skip(node.getLabel().toString());
        CommentsAndFormatting endFmt = CommentsAndFormatting.format(this.sourceBefore(":"));
        return new J.Label(Tree.randomId(), J.Ident.build((UUID)Tree.randomId(), (String)node.getLabel().toString(), null, Collections.emptyList(), (Formatting)Formatting.EMPTY, (Markers)Markers.EMPTY), new J.Empty(Tree.randomId(), endFmt.getComments(), endFmt.getFormatting(), Markers.EMPTY), (Statement)this.convert(node.getStatement()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitLambdaExpression(LambdaExpressionTree node, CommentsAndFormatting fmt) {
        Object body;
        List<Object> paramList;
        boolean parenthesized = this.source.charAt(this.cursor) == '(';
        this.skip("(");
        if (parenthesized && node.getParameters().isEmpty()) {
            CommentsAndFormatting paramsFmt = CommentsAndFormatting.format(this.sourceBefore(")"));
            paramList = Collections.singletonList(new J.Empty(Tree.randomId(), paramsFmt.getComments(), paramsFmt.getFormatting(), Markers.EMPTY));
        } else {
            paramList = this.convertAll(node.getParameters(), this.commaDelim, t -> parenthesized ? this.sourceBefore(")") : "");
        }
        J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), parenthesized, paramList, Markers.EMPTY);
        CommentsAndFormatting arrowFmt = CommentsAndFormatting.format(this.sourceBefore("->"));
        J.Lambda.Arrow arrow = new J.Lambda.Arrow(Tree.randomId(), arrowFmt.getComments(), arrowFmt.getFormatting(), Markers.EMPTY);
        if (node.getBody() instanceof JCTree.JCBlock) {
            String prefix = this.sourceBefore("{");
            --this.cursor;
            body = this.convert(node.getBody());
            body = (J)body.withPrefix(prefix);
        } else {
            body = this.convert(node.getBody());
        }
        return new J.Lambda(Tree.randomId(), params, arrow, body, this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitLiteral(LiteralTree node, CommentsAndFormatting fmt) {
        this.cursor(this.endPos(node));
        Object value = node.getValue();
        JavaType.Primitive type = this.primitive(((JCTree.JCLiteral)node).typetag);
        return new J.Literal(Tree.randomId(), value, this.source.substring(((JCTree.JCLiteral)node).getStartPosition(), this.endPos(node)), type, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitMemberReference(MemberReferenceTree node, CommentsAndFormatting fmt) {
        String referenceName;
        JCTree.JCMemberReference ref = (JCTree.JCMemberReference)node;
        Expression expr = (Expression)this.convert(ref.expr, t -> this.sourceBefore("::"));
        switch (ref.getMode()) {
            case NEW: {
                referenceName = "new";
                break;
            }
            default: {
                referenceName = node.getName().toString();
            }
        }
        J.TypeParameters typeParams = this.convertTypeParameters(node.getTypeArguments());
        CommentsAndFormatting refFmt = CommentsAndFormatting.format(this.sourceBefore(referenceName));
        J.Ident reference = J.Ident.build((UUID)Tree.randomId(), (String)referenceName, null, refFmt.getComments(), (Formatting)refFmt.getFormatting(), (Markers)Markers.EMPTY);
        return new J.MemberReference(Tree.randomId(), expr, typeParams, reference, this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitMemberSelect(MemberSelectTree node, CommentsAndFormatting fmt) {
        JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node;
        Expression target = (Expression)this.convert(fieldAccess.selected, t -> this.sourceBefore("."));
        CommentsAndFormatting nameFmt = CommentsAndFormatting.format(this.sourceBefore(fieldAccess.name.toString()));
        J.Ident name = J.Ident.build((UUID)Tree.randomId(), (String)fieldAccess.name.toString(), null, nameFmt.getComments(), (Formatting)nameFmt.getFormatting(), (Markers)Markers.EMPTY);
        return new J.FieldAccess(Tree.randomId(), target, name, this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitMethodInvocation(MethodInvocationTree node, CommentsAndFormatting fmt) {
        J.MethodInvocation.Arguments args;
        J.Ident name;
        JCTree.JCExpression jcSelect = ((JCTree.JCMethodInvocation)node).getMethodSelect();
        Expression select = null;
        if (jcSelect instanceof JCTree.JCFieldAccess) {
            select = (Expression)this.convert(((JCTree.JCFieldAccess)jcSelect).selected, t -> this.sourceBefore("."));
        } else if (!(jcSelect instanceof JCTree.JCIdent)) {
            throw new IllegalStateException("Unexpected method select type " + jcSelect.getClass().getSimpleName());
        }
        J.TypeParameters typeParams = null;
        if (!node.getTypeArguments().isEmpty()) {
            CommentsAndFormatting genericFmt = CommentsAndFormatting.format(this.sourceBefore("<"));
            List genericParams = this.convertAll(node.getTypeArguments(), this.commaDelim, t -> this.sourceBefore(">"));
            ArrayList<J.TypeParameter> mappedGenericParams = new ArrayList<J.TypeParameter>();
            for (Expression gp : genericParams) {
                J.TypeParameter typeParameter = new J.TypeParameter(Tree.randomId(), Collections.emptyList(), (Expression)gp.withComments(Collections.emptyList()).withFormatting(Formatting.EMPTY), null, gp.getComments(), gp.getFormatting(), Markers.EMPTY);
                mappedGenericParams.add(typeParameter);
            }
            typeParams = new J.TypeParameters(Tree.randomId(), mappedGenericParams, genericFmt.getComments(), genericFmt.getFormatting(), Markers.EMPTY);
        }
        if (jcSelect instanceof JCTree.JCFieldAccess) {
            String selectName = ((JCTree.JCFieldAccess)jcSelect).name.toString();
            CommentsAndFormatting nameFmt = CommentsAndFormatting.format(this.sourceBefore(selectName));
            name = J.Ident.build((UUID)Tree.randomId(), (String)selectName, null, nameFmt.getComments(), (Formatting)nameFmt.getFormatting(), (Markers)Markers.EMPTY);
        } else {
            name = (J.Ident)this.convert(jcSelect);
        }
        CommentsAndFormatting argsFmt = CommentsAndFormatting.format(this.sourceBefore("("));
        if (node.getArguments().isEmpty()) {
            CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore(")"));
            args = new J.MethodInvocation.Arguments(Tree.randomId(), Collections.singletonList(new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY)), argsFmt.getComments(), argsFmt.getFormatting(), Markers.EMPTY);
        } else {
            args = new J.MethodInvocation.Arguments(Tree.randomId(), this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")")), argsFmt.getComments(), argsFmt.getFormatting(), Markers.EMPTY);
        }
        Symbol genericSymbolAny = jcSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)jcSelect).sym : ((JCTree.JCIdent)jcSelect).sym;
        Symbol.MethodSymbol genericSymbol = genericSymbolAny instanceof Symbol.MethodSymbol ? (Symbol.MethodSymbol)genericSymbolAny : null;
        JavaType.Method type = null;
        if (genericSymbol != null && jcSelect.type != null) {
            Function<Type, JavaType.Method.Signature> signature = t -> {
                if (t instanceof Type.MethodType) {
                    Type.MethodType mt = (Type.MethodType)t;
                    ArrayList<JavaType> paramTypes = new ArrayList<JavaType>();
                    for (Type argtype : mt.argtypes) {
                        if (argtype == null) continue;
                        JavaType javaType = this.type(argtype);
                        paramTypes.add(javaType);
                    }
                    return new JavaType.Method.Signature(this.type(mt.restype), paramTypes);
                }
                return null;
            };
            JavaType.Method.Signature genericSignature = genericSymbol.type instanceof Type.ForAll ? signature.apply(((Type.ForAll)genericSymbol.type).qtype) : signature.apply(genericSymbol.type);
            ArrayList<String> paramNames = new ArrayList<String>();
            for (Symbol.VarSymbol p : genericSymbol.params()) {
                String s = p.name.toString();
                paramNames.add(s);
            }
            type = JavaType.Method.build((JavaType.FullyQualified)TypeUtils.asClass((JavaType)this.type(genericSymbol.owner)), (String)name.getSimpleName(), (JavaType.Method.Signature)genericSignature, (JavaType.Method.Signature)signature.apply(jcSelect.type), paramNames, this.filteredFlags(genericSymbol));
        }
        return new J.MethodInvocation(Tree.randomId(), select, typeParams, name, args, type, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitMethod(MethodTree node, CommentsAndFormatting fmt) {
        J.MethodDecl.Parameters params;
        J.Ident name;
        logger.trace("Visiting method {}", (Object)node.getName());
        List annotations = this.convertAll(node.getModifiers().getAnnotations(), this.noDelim, this.noDelim);
        List<J.Modifier> modifiers = this.sortedFlags(node.getModifiers());
        J.TypeParameters typeParams = null;
        if (!node.getTypeParameters().isEmpty()) {
            CommentsAndFormatting genericFmt = CommentsAndFormatting.format(this.sourceBefore("<"));
            typeParams = new J.TypeParameters(Tree.randomId(), this.convertAll(node.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">")), genericFmt.getComments(), genericFmt.getFormatting(), Markers.EMPTY);
        }
        TypeTree returnType = (TypeTree)this.convertOrNull(node.getReturnType());
        if ("<init>".equals(node.getName().toString())) {
            Symbol.MethodSymbol nodeSym = ((JCTree.JCMethodDecl)node).sym;
            String owner = null;
            if (nodeSym == null) {
                for (com.sun.source.tree.Tree tree : this.getCurrentPath()) {
                    if (!(tree instanceof JCTree.JCClassDecl)) continue;
                    owner = ((JCTree.JCClassDecl)tree).getSimpleName().toString();
                    break;
                }
                if (owner == null) {
                    throw new IllegalStateException("Should have been able to locate an owner");
                }
            } else {
                owner = ((JCTree.JCMethodDecl)node).sym.owner.name.toString();
            }
            CommentsAndFormatting ownerFmt = CommentsAndFormatting.format(this.sourceBefore(owner));
            name = J.Ident.build((UUID)Tree.randomId(), (String)owner, null, ownerFmt.getComments(), (Formatting)ownerFmt.getFormatting(), (Markers)Markers.EMPTY);
        } else {
            CommentsAndFormatting nameFmt = CommentsAndFormatting.format(this.sourceBefore(node.getName().toString()));
            name = J.Ident.build((UUID)Tree.randomId(), (String)node.getName().toString(), null, nameFmt.getComments(), (Formatting)nameFmt.getFormatting(), (Markers)Markers.EMPTY);
        }
        CommentsAndFormatting paramFmt = CommentsAndFormatting.format(this.sourceBefore("("));
        if (!node.getParameters().isEmpty()) {
            params = new J.MethodDecl.Parameters(Tree.randomId(), this.convertAll(node.getParameters(), this.commaDelim, t -> this.sourceBefore(")")), paramFmt.getComments(), paramFmt.getFormatting(), Markers.EMPTY);
        } else {
            CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore(")"));
            params = new J.MethodDecl.Parameters(Tree.randomId(), Collections.singletonList(new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY)), paramFmt.getComments(), paramFmt.getFormatting(), Markers.EMPTY);
        }
        J.MethodDecl.Throws throwss = null;
        if (!node.getThrows().isEmpty()) {
            CommentsAndFormatting throwsFmt = CommentsAndFormatting.format(this.sourceBefore("throws"));
            throwss = new J.MethodDecl.Throws(Tree.randomId(), this.convertAll(node.getThrows(), this.commaDelim, this.noDelim), throwsFmt.getComments(), throwsFmt.getFormatting(), Markers.EMPTY);
        }
        J.Block body = (J.Block)this.convertOrNull(node.getBody());
        J.MethodDecl.Default defaultValue = null;
        if (node.getDefaultValue() != null) {
            CommentsAndFormatting defaultFmt = CommentsAndFormatting.format(this.sourceBefore("default"));
            defaultValue = new J.MethodDecl.Default(Tree.randomId(), (Expression)this.convert(node.getDefaultValue()), defaultFmt.getComments(), defaultFmt.getFormatting(), Markers.EMPTY);
        }
        return new J.MethodDecl(Tree.randomId(), annotations, modifiers, typeParams, returnType, name, params, throwss, body, defaultValue, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public J visitNewArray(NewArrayTree node, CommentsAndFormatting fmt) {
        void var8_13;
        TypeTree typeExpr;
        this.skip("new");
        JCTree.JCExpression jcVarType = ((JCTree.JCNewArray)node).elemtype;
        if (jcVarType instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCExpression elementType = ((JCTree.JCArrayTypeTree)jcVarType).elemtype;
            while (elementType instanceof JCTree.JCArrayTypeTree) {
                elementType = ((JCTree.JCArrayTypeTree)elementType).elemtype;
            }
            typeExpr = (TypeTree)this.convertOrNull(elementType);
        } else {
            typeExpr = (TypeTree)this.convertOrNull(jcVarType);
        }
        ArrayList<J.NewArray.Dimension> dimensions = new ArrayList<J.NewArray.Dimension>();
        List<? extends ExpressionTree> nodeDimensions = node.getDimensions();
        for (ExpressionTree expressionTree : nodeDimensions) {
            String dimensionPrefix = this.sourceBefore("[");
            Expression size = (Expression)this.convert(expressionTree, t -> this.sourceBefore("]"));
            CommentsAndFormatting dimFmt = CommentsAndFormatting.format(dimensionPrefix);
            dimensions.add(new J.NewArray.Dimension(Tree.randomId(), size, dimFmt.getComments(), dimFmt.getFormatting(), Markers.EMPTY));
        }
        Matcher matcher = Pattern.compile("\\G(\\s*)\\[(\\s*)]").matcher(this.source);
        while (matcher.find(this.cursor)) {
            this.cursor(matcher.end());
            CommentsAndFormatting commentsAndFormatting = CommentsAndFormatting.format(matcher.group(2));
            J.Empty ws = new J.Empty(Tree.randomId(), commentsAndFormatting.getComments(), commentsAndFormatting.getFormatting(), Markers.EMPTY);
            CommentsAndFormatting dimFmt = CommentsAndFormatting.format(matcher.group(1));
            dimensions.add(new J.NewArray.Dimension(Tree.randomId(), (Expression)ws, dimFmt.getComments(), dimFmt.getFormatting(), Markers.EMPTY));
        }
        Object var8_11 = null;
        if (node.getInitializers() != null) {
            List<Object> initializers;
            CommentsAndFormatting initFmt = CommentsAndFormatting.format(this.sourceBefore("{"));
            if (node.getInitializers().isEmpty()) {
                CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore("}"));
                initializers = Collections.singletonList(new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY));
            } else {
                initializers = this.convertAll(node.getInitializers(), this.commaDelim, t -> this.sourceBefore("}"));
            }
            J.NewArray.Initializer initializer = new J.NewArray.Initializer(Tree.randomId(), initializers, initFmt.getComments(), initFmt.getFormatting(), Markers.EMPTY);
        }
        return new J.NewArray(Tree.randomId(), typeExpr, dimensions, (J.NewArray.Initializer)var8_13, this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitNewClass(NewClassTree node, CommentsAndFormatting fmt) {
        Expression encl;
        Expression expression = encl = node.getEnclosingExpression() == null ? null : (Expression)this.convert(node.getEnclosingExpression());
        if (encl != null) {
            encl = (Expression)encl.withSuffix(this.sourceBefore("."));
        }
        String whitespaceBeforeNew = "";
        com.sun.source.tree.Tree parent = this.getCurrentPath().getParentPath().getLeaf();
        if (!(parent instanceof JCTree.JCVariableDecl) || (((JCTree.JCVariableDecl)parent).mods.flags & 0x4000L) == 0L) {
            whitespaceBeforeNew = this.sourceBefore("new");
            this.skip("new");
        }
        TypeTree clazz = this.endPos(node.getIdentifier()) >= 0 ? (TypeTree)this.convertOrNull(node.getIdentifier()) : null;
        J.NewClass.Arguments args = null;
        if (this.positionOfNext("(", Character.valueOf('{')) > -1) {
            CommentsAndFormatting argFmt = CommentsAndFormatting.format(this.sourceBefore("("));
            if (node.getArguments().isEmpty()) {
                CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore(")"));
                args = new J.NewClass.Arguments(Tree.randomId(), Collections.singletonList(new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY)), argFmt.getComments(), argFmt.getFormatting(), Markers.EMPTY);
            } else {
                args = new J.NewClass.Arguments(Tree.randomId(), this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")")), argFmt.getComments(), argFmt.getFormatting(), Markers.EMPTY);
            }
        }
        J.Block body = null;
        if (node.getClassBody() != null) {
            CommentsAndFormatting bodyFmt = CommentsAndFormatting.format(this.sourceBefore("{"));
            ArrayList<com.sun.source.tree.Tree> members = new ArrayList<com.sun.source.tree.Tree>();
            for (com.sun.source.tree.Tree tree : node.getClassBody().getMembers()) {
                if (tree instanceof JCTree.JCMethodDecl && (((JCTree.JCMethodDecl)tree).getModifiers().flags & 0x1000000000L) != 0L) continue;
                members.add(tree);
            }
            List mappedMembers = this.convertAll(members, this.noDelim, this.noDelim);
            CommentsAndFormatting commentsAndFormatting = CommentsAndFormatting.format(this.sourceBefore("}"));
            body = new J.Block(Tree.randomId(), null, mappedMembers, bodyFmt.getComments(), bodyFmt.getFormatting(), Markers.EMPTY, new J.Block.End(Tree.randomId(), commentsAndFormatting.getComments(), commentsAndFormatting.getFormatting(), Markers.EMPTY));
        }
        CommentsAndFormatting beforeNewFmt = CommentsAndFormatting.format(whitespaceBeforeNew);
        return new J.NewClass(Tree.randomId(), encl, new J.NewClass.New(UUID.randomUUID(), beforeNewFmt.getComments(), beforeNewFmt.getFormatting(), Markers.EMPTY), clazz, args, body, this.type(((JCTree.JCNewClass)node).type), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitParameterizedType(ParameterizedTypeTree node, CommentsAndFormatting fmt) {
        return new J.ParameterizedType(Tree.randomId(), (NameTree)this.convert(node.getType()), this.convertTypeParameters(node.getTypeArguments()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitParenthesized(ParenthesizedTree node, CommentsAndFormatting fmt) {
        this.skip("(");
        return new J.Parentheses(Tree.randomId(), (J)((Expression)this.convert(node.getExpression(), t -> this.sourceBefore(")"))), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitPrimitiveType(PrimitiveTypeTree node, CommentsAndFormatting fmt) {
        JavaType.Primitive primitiveType;
        this.cursor(this.endPos(node));
        switch (node.getPrimitiveTypeKind()) {
            case BOOLEAN: {
                primitiveType = JavaType.Primitive.Boolean;
                break;
            }
            case BYTE: {
                primitiveType = JavaType.Primitive.Byte;
                break;
            }
            case CHAR: {
                primitiveType = JavaType.Primitive.Char;
                break;
            }
            case DOUBLE: {
                primitiveType = JavaType.Primitive.Double;
                break;
            }
            case FLOAT: {
                primitiveType = JavaType.Primitive.Float;
                break;
            }
            case INT: {
                primitiveType = JavaType.Primitive.Int;
                break;
            }
            case LONG: {
                primitiveType = JavaType.Primitive.Long;
                break;
            }
            case SHORT: {
                primitiveType = JavaType.Primitive.Short;
                break;
            }
            case VOID: {
                primitiveType = JavaType.Primitive.Void;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive type " + node.getPrimitiveTypeKind());
            }
        }
        return new J.Primitive(Tree.randomId(), primitiveType, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitReturn(ReturnTree node, CommentsAndFormatting fmt) {
        this.skip("return");
        return new J.Return(Tree.randomId(), (Expression)this.convertOrNull(node.getExpression()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitSwitch(SwitchTree node, CommentsAndFormatting fmt) {
        this.skip("switch");
        J.Parentheses selector = (J.Parentheses)this.convert(node.getExpression());
        CommentsAndFormatting caseFmt = CommentsAndFormatting.format(this.sourceBefore("{"));
        List cases = this.convertAll(node.getCases(), this.noDelim, this.noDelim);
        CommentsAndFormatting endFmt = CommentsAndFormatting.format(this.sourceBefore("}"));
        return new J.Switch(Tree.randomId(), selector, new J.Block(Tree.randomId(), null, cases, caseFmt.getComments(), caseFmt.getFormatting(), Markers.EMPTY, new J.Block.End(Tree.randomId(), endFmt.getComments(), endFmt.getFormatting(), Markers.EMPTY)), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitSynchronized(SynchronizedTree node, CommentsAndFormatting fmt) {
        this.skip("synchronized");
        return new J.Synchronized(Tree.randomId(), (J.Parentheses)this.convert(node.getExpression()), (J.Block)this.convert(node.getBlock()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitThrow(ThrowTree node, CommentsAndFormatting fmt) {
        this.skip("throw");
        return new J.Throw(Tree.randomId(), (Expression)this.convert(node.getExpression()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitTry(TryTree node, CommentsAndFormatting fmt) {
        this.skip("try");
        J.Try.Resources resources = null;
        if (!node.getResources().isEmpty()) {
            CommentsAndFormatting resourcesFmt = CommentsAndFormatting.format(this.sourceBefore("("));
            List decls = this.convertAll(node.getResources(), this.semiDelim, t -> this.sourceBefore(")"));
            resources = new J.Try.Resources(Tree.randomId(), decls, resourcesFmt.getComments(), resourcesFmt.getFormatting(), Markers.EMPTY);
        }
        J.Block block = (J.Block)this.convert(node.getBlock());
        List catches = this.convertAll(node.getCatches(), this.noDelim, this.noDelim);
        J.Try.Finally finallyy = null;
        if (node.getFinallyBlock() != null) {
            CommentsAndFormatting finallyFmt = CommentsAndFormatting.format(this.sourceBefore("finally"));
            finallyy = new J.Try.Finally(Tree.randomId(), (J.Block)this.convert(node.getFinallyBlock()), finallyFmt.getComments(), finallyFmt.getFormatting(), Markers.EMPTY);
        }
        return new J.Try(Tree.randomId(), resources, block, catches, finallyy, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitTypeCast(TypeCastTree node, CommentsAndFormatting fmt) {
        CommentsAndFormatting clazzFmt = CommentsAndFormatting.format(this.sourceBefore("("));
        J.Parentheses clazz = new J.Parentheses(Tree.randomId(), (J)((TypeTree)this.convert(node.getType(), t -> this.sourceBefore(")"))), clazzFmt.getComments(), clazzFmt.getFormatting(), Markers.EMPTY);
        return new J.TypeCast(Tree.randomId(), clazz, (Expression)this.convert(node.getExpression()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitAnnotatedType(AnnotatedTypeTree node, CommentsAndFormatting fmt) {
        List annotations = this.convertAll(node.getAnnotations(), this.noDelim, this.noDelim);
        return new J.AnnotatedType(Tree.randomId(), annotations, (TypeTree)this.convert(node.getUnderlyingType()), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitTypeParameter(TypeParameterTree node, CommentsAndFormatting fmt) {
        List annotations = this.convertAll(node.getAnnotations(), this.noDelim, this.noDelim);
        CommentsAndFormatting nameFmt = CommentsAndFormatting.format(this.sourceBefore(node.getName().toString()));
        Expression name = (Expression)TreeBuilder.buildName((String)node.getName().toString()).withComments(nameFmt.getComments()).withFormatting(nameFmt.getFormatting());
        J.TypeParameter.Bounds bounds = null;
        if (!node.getBounds().isEmpty()) {
            CommentsAndFormatting boundFmt = CommentsAndFormatting.format(!node.getBounds().isEmpty() ? this.sourceBefore("extends") : "");
            bounds = new J.TypeParameter.Bounds(Tree.randomId(), this.convertAll(node.getBounds(), t -> this.sourceBefore("&"), this.noDelim), boundFmt.getComments(), boundFmt.getFormatting(), Markers.EMPTY);
        }
        return new J.TypeParameter(Tree.randomId(), annotations, name, bounds, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitUnionType(UnionTypeTree node, CommentsAndFormatting fmt) {
        return new J.MultiCatch(Tree.randomId(), this.convertAll(node.getTypeAlternatives(), t -> this.sourceBefore("|"), this.noDelim), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitUnary(UnaryTree node, CommentsAndFormatting fmt) {
        Expression expr;
        J.Unary.Operator.Positive op;
        JCTree.JCUnary unary = (JCTree.JCUnary)node;
        JCTree.Tag tag = unary.getTag();
        switch (tag) {
            case POS: {
                this.skip("+");
                op = new J.Unary.Operator.Positive(Tree.randomId(), Markers.EMPTY);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case NEG: {
                this.skip("-");
                op = new J.Unary.Operator.Negative(Tree.randomId(), Markers.EMPTY);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case PREDEC: {
                this.skip("--");
                op = new J.Unary.Operator.PreDecrement(Tree.randomId(), Markers.EMPTY);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case PREINC: {
                this.skip("++");
                op = new J.Unary.Operator.PreIncrement(Tree.randomId(), Markers.EMPTY);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case POSTDEC: {
                expr = (Expression)this.convert(unary.arg);
                CommentsAndFormatting opFmt = CommentsAndFormatting.format(this.sourceBefore("--"));
                op = new J.Unary.Operator.PostDecrement(Tree.randomId(), opFmt.getComments(), opFmt.getFormatting(), Markers.EMPTY);
                break;
            }
            case POSTINC: {
                expr = (Expression)this.convert(unary.arg);
                CommentsAndFormatting opFmt = CommentsAndFormatting.format(this.sourceBefore("++"));
                op = new J.Unary.Operator.PostIncrement(Tree.randomId(), opFmt.getComments(), opFmt.getFormatting(), Markers.EMPTY);
                break;
            }
            case COMPL: {
                this.skip("~");
                op = new J.Unary.Operator.Complement(Tree.randomId(), Markers.EMPTY);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case NOT: {
                this.skip("!");
                op = new J.Unary.Operator.Not(Tree.randomId(), Markers.EMPTY);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected unary tag " + tag);
            }
        }
        return new J.Unary(Tree.randomId(), (J.Unary.Operator)op, expr, this.type(node), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitVariable(VariableTree node, CommentsAndFormatting fmt) {
        return this.hasFlag(node.getModifiers(), 16384L) ? this.visitEnumVariable(node, fmt) : this.visitVariables(Collections.singletonList(node), fmt);
    }

    private J.VariableDecls visitVariables(List<VariableTree> nodes, CommentsAndFormatting fmt) {
        TypeTree typeExpr;
        JCTree.JCVariableDecl node = (JCTree.JCVariableDecl)nodes.get(0);
        List annotations = this.convertAll(node.getModifiers().annotations, this.noDelim, this.noDelim);
        JCTree.JCExpression vartype = node.vartype;
        List<Object> modifiers = node.getModifiers().pos >= 0 ? this.sortedFlags(node.getModifiers()) : Collections.emptyList();
        if (vartype == null || this.endPos(vartype) < 0 || vartype instanceof JCTree.JCErroneous) {
            typeExpr = null;
        } else if (vartype instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCExpression elementType = ((JCTree.JCArrayTypeTree)vartype).elemtype;
            while (elementType instanceof JCTree.JCArrayTypeTree) {
                elementType = ((JCTree.JCArrayTypeTree)elementType).elemtype;
            }
            typeExpr = (TypeTree)this.convert(elementType);
        } else {
            typeExpr = (TypeTree)this.convert(vartype);
        }
        Supplier<List> dimensions = () -> {
            Matcher matcher = Pattern.compile("\\G(\\s*)\\[(\\s*)]").matcher(this.source);
            ArrayList<J.VariableDecls.Dimension> dims = new ArrayList<J.VariableDecls.Dimension>();
            while (matcher.find(this.cursor)) {
                this.cursor(matcher.end());
                CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(matcher.group(2));
                J.Empty ws = new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY);
                CommentsAndFormatting dimFmt = CommentsAndFormatting.format(matcher.group(1));
                dims.add(new J.VariableDecls.Dimension(Tree.randomId(), ws, dimFmt.getComments(), dimFmt.getFormatting(), Markers.EMPTY));
            }
            return dims;
        };
        List beforeDimensions = dimensions.get();
        String vartypeString = typeExpr == null ? "" : this.source.substring(vartype.getStartPosition(), this.endPos(vartype));
        Matcher varargMatcher = Pattern.compile("(\\s*)\\.{3}").matcher(vartypeString);
        J.VariableDecls.Varargs varargs = null;
        if (varargMatcher.find()) {
            this.skipPattern("(\\s*)\\.{3}");
            CommentsAndFormatting varargFmt = CommentsAndFormatting.format(varargMatcher.group(1));
            varargs = new J.VariableDecls.Varargs(Tree.randomId(), varargFmt.getComments(), varargFmt.getFormatting(), Markers.EMPTY);
        }
        ArrayList<J.VariableDecls.NamedVar> vars = new ArrayList<J.VariableDecls.NamedVar>();
        for (int i = 0; i < nodes.size(); ++i) {
            VariableTree n = nodes.get(i);
            CommentsAndFormatting namedVarFmt = CommentsAndFormatting.format(this.sourceBefore(n.getName().toString()));
            JCTree.JCVariableDecl vd = (JCTree.JCVariableDecl)n;
            List dimensionsAfterName = dimensions.get();
            if (!dimensionsAfterName.isEmpty()) {
                dimensionsAfterName = Formatting.formatLastSuffix((List)dimensionsAfterName, (String)(vd.init != null ? this.sourceBefore("=") : ""));
            }
            J.Ident name = J.Ident.build((UUID)Tree.randomId(), (String)n.getName().toString(), (JavaType)this.type(node), Collections.emptyList(), (Formatting)Formatting.EMPTY, (Markers)Markers.EMPTY);
            CommentsAndFormatting afterNameFmt = CommentsAndFormatting.format(dimensionsAfterName.isEmpty() && vd.init != null ? this.sourceBefore("=") : "");
            Expression init = (Expression)this.convertOrNull(vd.init);
            J.Empty beforeComma = null;
            if (i != nodes.size() - 1) {
                CommentsAndFormatting beforeCommaFmt = CommentsAndFormatting.format(this.sourceBefore(","));
                beforeComma = new J.Empty(Tree.randomId(), beforeCommaFmt.getComments(), beforeCommaFmt.getFormatting(), Markers.EMPTY);
            }
            vars.add(new J.VariableDecls.NamedVar(Tree.randomId(), name, new J.Empty(Tree.randomId(), afterNameFmt.getComments(), afterNameFmt.getFormatting(), Markers.EMPTY), dimensionsAfterName, init, beforeComma, this.type(n), namedVarFmt.getComments(), namedVarFmt.getFormatting(), Markers.EMPTY));
        }
        return new J.VariableDecls(Tree.randomId(), annotations, modifiers, typeExpr, varargs, beforeDimensions, vars, fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitWhileLoop(WhileLoopTree node, CommentsAndFormatting fmt) {
        this.skip("while");
        return new J.WhileLoop(Tree.randomId(), (J.Parentheses)this.convert(node.getCondition()), (Statement)this.convert(node.getStatement(), this.statementDelim), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    @Override
    public J visitWildcard(WildcardTree node, CommentsAndFormatting fmt) {
        J.Wildcard.Bound.Extends bound;
        this.skip("?");
        JCTree.JCWildcard wildcard = (JCTree.JCWildcard)node;
        switch (wildcard.kind.kind) {
            case EXTENDS: {
                CommentsAndFormatting extendsFmt = CommentsAndFormatting.format(this.sourceBefore("extends"));
                bound = new J.Wildcard.Bound.Extends(Tree.randomId(), extendsFmt.getComments(), extendsFmt.getFormatting(), Markers.EMPTY);
                break;
            }
            case SUPER: {
                CommentsAndFormatting superFmt = CommentsAndFormatting.format(this.sourceBefore("super"));
                bound = new J.Wildcard.Bound.Super(Tree.randomId(), superFmt.getComments(), superFmt.getFormatting(), Markers.EMPTY);
                break;
            }
            default: {
                bound = null;
            }
        }
        return new J.Wildcard(Tree.randomId(), (J.Wildcard.Bound)bound, (NameTree)this.convertOrNull(wildcard.inner), fmt.getComments(), fmt.getFormatting(), Markers.EMPTY);
    }

    private <T extends J> T convert(com.sun.source.tree.Tree t) {
        return this.convert(t, t2 -> "");
    }

    private <T extends J> T convert(com.sun.source.tree.Tree t2, Function<com.sun.source.tree.Tree, String> suffix) {
        try {
            String prefix = this.source.substring(this.cursor, Math.max(((JCTree)t2).getStartPosition(), this.cursor));
            this.cursor += prefix.length();
            J t = (J)this.scan(t2, CommentsAndFormatting.format(prefix));
            if (t != null) {
                t = (J)t.withSuffix(suffix.apply(t2));
            }
            this.cursor(Math.max(this.endPos(t2), this.cursor));
            return (T)t;
        }
        catch (Throwable ex) {
            logger.error("Failed to convert " + t2.getClass().getSimpleName() + " for the following cursor stack:");
            this.logCurrentPathAsError();
            throw ex;
        }
    }

    private void logCurrentPathAsError() {
        logger.error("--- BEGIN PATH ---");
        List paths = StreamSupport.stream(this.getCurrentPath().spliterator(), false).collect(Collectors.toList());
        int i = paths.size();
        while (i-- > 0) {
            JCTree tree = (JCTree)paths.get(i);
            if (tree instanceof JCTree.JCCompilationUnit) {
                logger.error("JCCompilationUnit(sourceFile = " + ((JCTree.JCCompilationUnit)tree).sourcefile.getName() + ")");
                continue;
            }
            if (tree instanceof JCTree.JCClassDecl) {
                logger.error("JCClassDecl(name = " + ((JCTree.JCClassDecl)tree).name + ", line = " + this.lineNumber(tree) + ")");
                continue;
            }
            if (tree instanceof JCTree.JCVariableDecl) {
                logger.error("JCVariableDecl(name = " + ((JCTree.JCVariableDecl)tree).name + ", line = " + this.lineNumber(tree) + ")");
                continue;
            }
            logger.error(tree.getClass().getSimpleName() + "(line = " + this.lineNumber(tree) + ")");
        }
        logger.error("--- END PATH ---");
    }

    private long lineNumber(com.sun.source.tree.Tree tree) {
        return this.source.substring(0, ((JCTree)tree).getStartPosition()).chars().filter(c -> c == 10).count() + 1L;
    }

    private <T extends J> T convertOrNull(@Nullable com.sun.source.tree.Tree t) {
        return this.convertOrNull(t, t2 -> "");
    }

    @Nullable
    private <T extends J> T convertOrNull(@Nullable com.sun.source.tree.Tree t, Function<com.sun.source.tree.Tree, String> suffix) {
        return t == null ? null : (T)this.convert(t, suffix);
    }

    private <T extends J> List<T> convertAll(List<? extends com.sun.source.tree.Tree> trees, Function<com.sun.source.tree.Tree, String> innerSuffix, Function<com.sun.source.tree.Tree, String> suffix) {
        ArrayList<T> converted = new ArrayList<T>(trees.size());
        for (int i = 0; i < trees.size(); ++i) {
            converted.add(this.convert(trees.get(i), i == trees.size() - 1 ? suffix : innerSuffix));
        }
        return converted;
    }

    private J.TypeParameters convertTypeParameters(List<? extends com.sun.source.tree.Tree> typeArguments) {
        List<Object> typeArgs;
        if (typeArguments == null) {
            return null;
        }
        CommentsAndFormatting typeArgFmt = CommentsAndFormatting.format(this.sourceBefore("<"));
        if (typeArguments.isEmpty()) {
            CommentsAndFormatting emptyFmt = CommentsAndFormatting.format(this.sourceBefore(">"));
            typeArgs = Collections.singletonList(new J.Empty(Tree.randomId(), emptyFmt.getComments(), emptyFmt.getFormatting(), Markers.EMPTY));
        } else {
            typeArgs = this.convertAll(typeArguments, this.commaDelim, t -> this.sourceBefore(">"));
        }
        ArrayList<J.TypeParameter> params = new ArrayList<J.TypeParameter>();
        for (Expression gp : typeArgs) {
            J.TypeParameter typeParameter = new J.TypeParameter(Tree.randomId(), Collections.emptyList(), (Expression)gp.withComments(Collections.emptyList()).withFormatting(Formatting.EMPTY), null, gp.getComments(), gp.getFormatting(), Markers.EMPTY);
            params.add(typeParameter);
        }
        return new J.TypeParameters(Tree.randomId(), params, typeArgFmt.getComments(), typeArgFmt.getFormatting(), Markers.EMPTY);
    }

    private <T extends J> List<T> convertPossibleMultiVariable(@Nullable List<? extends com.sun.source.tree.Tree> trees) {
        if (trees == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<Integer, List> treesGroupedByStartPosition = new LinkedHashMap<Integer, List>();
        for (com.sun.source.tree.Tree tree : trees) {
            treesGroupedByStartPosition.computeIfAbsent(((JCTree)tree).getStartPosition(), k -> new ArrayList()).add(tree);
        }
        ArrayList<Object> converted = new ArrayList<Object>();
        for (List treeGroup : treesGroupedByStartPosition.values()) {
            if (treeGroup.size() == 1) {
                converted.add(this.convert((com.sun.source.tree.Tree)treeGroup.get(0), this.statementDelim));
                continue;
            }
            String prefix = this.source.substring(this.cursor, Math.max(((JCTree)treeGroup.get(0)).getStartPosition(), this.cursor));
            this.cursor += prefix.length();
            com.sun.source.tree.Tree last = (com.sun.source.tree.Tree)treeGroup.get(treeGroup.size() - 1);
            J.VariableDecls vars = this.visitVariables(treeGroup, CommentsAndFormatting.format(prefix));
            vars = (J.VariableDecls)vars.withSuffix(this.semiDelim.apply(last));
            this.cursor(Math.max(this.endPos(last), this.cursor));
            converted.add(vars);
        }
        return converted;
    }

    private Set<Flag> filteredFlags(Symbol sym) {
        HashSet<Flag> set = new HashSet<Flag>();
        for (Map.Entry<Long, Flag> mask : this.flagMasks.entrySet()) {
            if ((sym.flags() & mask.getKey()) == 0L) continue;
            Flag value = mask.getValue();
            set.add(value);
        }
        return set;
    }

    @Nullable
    private JavaType type(@Nullable Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.TypeVariableSymbol) {
            return this.type(symbol.type);
        }
        if (symbol instanceof Symbol.VarSymbol) {
            return new JavaType.GenericTypeVariable(symbol.name.toString(), null);
        }
        return null;
    }

    @Nullable
    private JavaType type(@Nullable Type type) {
        return this.type(type, Collections.emptyList());
    }

    @Nullable
    private JavaType type(@Nullable Type type, List<Symbol> stack) {
        return this.type(type, stack, false);
    }

    @Nullable
    private JavaType type(@Nullable Type type, List<Symbol> stack, boolean shallow) {
        if (type instanceof Type.ClassType) {
            List interfaces;
            List typeParameters;
            List fields;
            if (type instanceof Type.ErrorType) {
                return null;
            }
            Symbol.ClassSymbol sym = (Symbol.ClassSymbol)type.tsym;
            if (stack.contains(sym)) {
                return new JavaType.Cyclic(sym.className());
            }
            if (shallow) {
                return new JavaType.ShallowClass(sym.className());
            }
            JavaType.Class flyweight = this.sharedClassTypes.get(sym.className());
            if (flyweight != null) {
                return flyweight;
            }
            ArrayList<Symbol> stackWithSym = new ArrayList<Symbol>(stack);
            stackWithSym.add(sym);
            if (sym.members_field == null) {
                fields = Collections.emptyList();
            } else {
                fields = new ArrayList();
                for (Symbol elem : sym.members_field.getSymbols()) {
                    if (!(elem instanceof Symbol.VarSymbol)) continue;
                    fields.add(new JavaType.Var(elem.name.toString(), this.type(elem.type, stackWithSym), this.filteredFlags(elem)));
                }
            }
            Type.ClassType classType = (Type.ClassType)type;
            Type.ClassType symType = (Type.ClassType)sym.type;
            if (classType.typarams_field == null) {
                typeParameters = Collections.emptyList();
            } else {
                typeParameters = new ArrayList();
                for (Type type2 : classType.typarams_field) {
                    JavaType javaType = this.type(type2, stackWithSym, true);
                    if (javaType == null) continue;
                    typeParameters.add(javaType);
                }
            }
            if (symType.interfaces_field == null) {
                interfaces = Collections.emptyList();
            } else {
                interfaces = new ArrayList();
                for (Type iParam : symType.interfaces_field) {
                    JavaType javaType = this.type(iParam, stackWithSym, false);
                    if (javaType == null) continue;
                    interfaces.add(javaType);
                }
            }
            JavaType.Class clazz = JavaType.Class.build((String)sym.className(), fields, typeParameters, interfaces, null, (JavaType.Class)TypeUtils.asClass((JavaType)this.type(classType.supertype_field, stackWithSym)), (boolean)this.relaxedClassTypeMatching);
            this.sharedClassTypes.put(sym.className(), clazz);
            return clazz;
        }
        if (type instanceof Type.TypeVar) {
            return new JavaType.GenericTypeVariable(type.tsym.name.toString(), TypeUtils.asClass((JavaType)this.type(type.getUpperBound(), stack)));
        }
        if (type instanceof Type.JCPrimitiveType) {
            return this.primitive(type.getTag());
        }
        if (type instanceof Type.ArrayType) {
            return new JavaType.Array(this.type(((Type.ArrayType)type).elemtype, stack));
        }
        if (Type.noType.equals(type)) {
            return null;
        }
        return null;
    }

    @Nullable
    private JavaType type(com.sun.source.tree.Tree t) {
        return this.type(((JCTree)t).type);
    }

    private JavaType.Primitive primitive(TypeTag tag) {
        switch (tag) {
            case BOOLEAN: {
                return JavaType.Primitive.Boolean;
            }
            case BYTE: {
                return JavaType.Primitive.Byte;
            }
            case CHAR: {
                return JavaType.Primitive.Char;
            }
            case DOUBLE: {
                return JavaType.Primitive.Double;
            }
            case FLOAT: {
                return JavaType.Primitive.Float;
            }
            case INT: {
                return JavaType.Primitive.Int;
            }
            case LONG: {
                return JavaType.Primitive.Long;
            }
            case SHORT: {
                return JavaType.Primitive.Short;
            }
            case VOID: {
                return JavaType.Primitive.Void;
            }
            case NONE: {
                return JavaType.Primitive.None;
            }
            case CLASS: {
                return JavaType.Primitive.String;
            }
            case BOT: {
                return JavaType.Primitive.Null;
            }
        }
        throw new IllegalArgumentException("Unknown type tag " + tag);
    }

    private int endPos(com.sun.source.tree.Tree t) {
        return ((JCTree)t).getEndPosition(this.endPosTable);
    }

    private String sourceBefore(String untilDelim) {
        return this.sourceBefore(untilDelim, null);
    }

    private String sourceBefore(String untilDelim, @Nullable Character stop) {
        int delimIndex = this.positionOfNext(untilDelim, stop);
        if (delimIndex < 0) {
            return "";
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return prefix;
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment && this.source.charAt(delimIndex) == '\n') {
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                switch (this.source.substring(delimIndex, delimIndex + 2)) {
                    case "//": {
                        inSingleLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "/*": {
                        inMultiLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "*/": {
                        inMultiLineComment = false;
                        ++delimIndex;
                    }
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }

    private String whitespace() {
        return this.whitespace(null);
    }

    /*
     * Unable to fully structure code
     */
    private String whitespace(@Nullable com.sun.source.tree.Tree t) {
        inMultiLineComment = false;
        inSingleLineComment = false;
        block10: for (delimIndex = this.cursor; delimIndex < this.source.length(); ++delimIndex) {
            if (inSingleLineComment && (this.source.charAt(delimIndex) == '\n' || this.source.charAt(delimIndex) == '\r')) {
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() <= delimIndex + 1) ** GOTO lbl-1000
            var5_5 = this.source.substring(delimIndex, delimIndex + 2);
            var6_6 = -1;
            switch (var5_5.hashCode()) {
                case 1504: {
                    if (!var5_5.equals("//")) break;
                    var6_6 = 0;
                    break;
                }
                case 1499: {
                    if (!var5_5.equals("/*")) break;
                    var6_6 = 1;
                    break;
                }
                case 1349: {
                    if (!var5_5.equals("*/")) break;
                    var6_6 = 2;
                }
            }
            switch (var6_6) {
                case 0: {
                    inSingleLineComment = true;
                    ++delimIndex;
                    continue block10;
                }
                case 1: {
                    inMultiLineComment = true;
                    ++delimIndex;
                    continue block10;
                }
                case 2: {
                    inMultiLineComment = false;
                    ++delimIndex;
                    continue block10;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (!inMultiLineComment && !inSingleLineComment && !Character.isWhitespace(this.source.substring(delimIndex, delimIndex + 1).charAt(0))) break block10;
                }
            }
        }
        prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length();
        return prefix;
    }

    @Nullable
    private String skip(@Nullable String token) {
        if (token == null) {
            return null;
        }
        if (this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
        return token;
    }

    private void skipPattern(String pattern) {
        Matcher matcher = Pattern.compile("\\G" + pattern).matcher(this.source);
        if (matcher.find(this.cursor)) {
            this.cursor(matcher.end());
        }
    }

    private void cursor(int n) {
        this.cursor = n;
    }

    private boolean hasFlag(ModifiersTree modifiers, long flag) {
        return (((JCTree.JCModifiers)modifiers).flags & flag) != 0L;
    }

    private List<String> listFlags(long flags) {
        Map<String, Long> allFlags = Arrays.stream(Flags.class.getDeclaredFields()).filter(field -> {
            field.setAccessible(true);
            try {
                return field.get(null) instanceof Long && field.getName().matches("[A-Z_]+");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(Field::getName, field -> {
            try {
                return (Long)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }));
        ArrayList<String> all = new ArrayList<String>();
        for (Map.Entry<String, Long> flagNameAndCode : allFlags.entrySet()) {
            if ((flagNameAndCode.getValue() & flags) == 0L) continue;
            all.add(flagNameAndCode.getKey());
        }
        return all;
    }

    private List<J.Modifier> sortedFlags(ModifiersTree modifiers) {
        if (modifiers.getFlags().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Modifier> sortedModifiers = new ArrayList<Modifier>();
        boolean inComment = false;
        boolean inMultilineComment = false;
        AtomicReference<String> word = new AtomicReference<String>("");
        for (int i = this.cursor; i < this.source.length(); ++i) {
            char c = this.source.charAt(i);
            if (c == '/' && this.source.length() > i + 1) {
                char next = this.source.charAt(i + 1);
                if (next == '*') {
                    inMultilineComment = true;
                } else if (next == '/') {
                    inComment = true;
                }
            }
            if (inMultilineComment && c == '/' && this.source.charAt(i - 1) == '*') {
                inMultilineComment = false;
                continue;
            }
            if (inComment && c == '\n' || c == '\r') {
                inComment = false;
                continue;
            }
            if (inMultilineComment || inComment) continue;
            if (Character.isWhitespace(c)) {
                if (word.get().isEmpty()) continue;
                Modifier matching = null;
                for (Modifier modifier : modifiers.getFlags()) {
                    if (!modifier.name().toLowerCase().equals(word.get())) continue;
                    matching = modifier;
                    break;
                }
                if (matching == null) break;
                sortedModifiers.add(matching);
                word.set("");
                continue;
            }
            word.getAndUpdate(w -> w + c);
        }
        ArrayList<J.Modifier> mappedModifiers = new ArrayList<J.Modifier>();
        block16: for (Modifier mod : sortedModifiers) {
            CommentsAndFormatting modFormat = CommentsAndFormatting.format(this.whitespace());
            this.cursor += mod.name().length();
            switch (mod) {
                case DEFAULT: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Default(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case PUBLIC: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Public(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case PROTECTED: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Protected(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case PRIVATE: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Private(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case ABSTRACT: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Abstract(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case STATIC: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Static(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case FINAL: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Final(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case NATIVE: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Native(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case STRICTFP: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Strictfp(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case SYNCHRONIZED: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Synchronized(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case TRANSIENT: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Transient(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
                case VOLATILE: {
                    mappedModifiers.add((J.Modifier)new J.Modifier.Volatile(Tree.randomId(), modFormat.getComments(), modFormat.getFormatting(), Markers.EMPTY));
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Unexpected modifier " + mod);
        }
        return mappedModifiers;
    }
}

