/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.quark.Quark;
import org.openrewrite.scheduling.WorkingDirectoryExecutionContextView;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParseError;

public abstract class RoslynRecipe
extends ScanningRecipe<Accumulator> {
    private static final String FIRST_RECIPE = RoslynRecipe.class.getName() + ".FIRST_RECIPE";
    private static final String INIT_REPO_DIR = RoslynRecipe.class.getName() + ".INIT_REPO_DIR";

    public final String getExecutable() {
        String executable = System.getenv("ROSLYN_RECIPE_EXECUTABLE");
        if (executable == null) {
            throw new IllegalStateException("ROSLYN_RECIPE_EXECUTABLE environment variable not set");
        }
        if (!executable.endsWith(".dll")) {
            executable = RoslynRecipe.ensureTrailingSeparator(executable) + "Rewrite.Server.dll";
        }
        return executable;
    }

    public static String ensureTrailingSeparator(String path) {
        if (path == null || path.isEmpty()) {
            return File.separator;
        }
        String separator = File.separator;
        if (path.endsWith("/") || path.endsWith("\\")) {
            if (!path.endsWith(separator)) {
                path = path.substring(0, path.length() - 1) + separator;
            }
            return path;
        }
        return path + separator;
    }

    public abstract String getRecipeId();

    public abstract String getNugetPackageName();

    public abstract String getNugetPackageVersion();

    public Accumulator getInitialValue(ExecutionContext ctx) {
        Path directory = RoslynRecipe.createDirectory(ctx, "repo");
        if (ctx.getMessage(INIT_REPO_DIR) == null) {
            ctx.putMessage(INIT_REPO_DIR, (Object)directory);
            ctx.putMessage(FIRST_RECIPE, (Object)ctx.getCycleDetails().getRecipePosition());
        }
        return new Accumulator(directory);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile && !(tree instanceof Quark) && !(tree instanceof ParseError) && !"org.openrewrite.java.tree.J$CompilationUnit".equals(tree.getClass().getName())) {
                    SourceFile sourceFile = (SourceFile)tree;
                    String fileName = sourceFile.getSourcePath().getFileName().toString();
                    int lastDot = fileName.lastIndexOf(46);
                    if (lastDot > 0) {
                        String extension = fileName.substring(lastDot + 1);
                        if ("sln".equals(extension)) {
                            acc.solutionFile = sourceFile.getSourcePath();
                        }
                        acc.extensionCounts.computeIfAbsent(extension, e -> new AtomicInteger(0)).incrementAndGet();
                    }
                    if (Objects.equals(ctx.getMessage(FIRST_RECIPE), ctx.getCycleDetails().getRecipePosition())) {
                        acc.writeSource(sourceFile);
                    }
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        this.runRoslynRecipe(acc, ctx);
        return Collections.emptyList();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runRoslynRecipe(Accumulator acc, ExecutionContext ctx) {
        String content;
        String part;
        Path dir = acc.getDirectory();
        ArrayList<String> command = new ArrayList<String>();
        Map<String, String> env = this.getCommandEnvironment(acc, ctx);
        String template = "dotnet ${exec} run-recipe --solution ${solution} --id ${recipeId} --package ${package} --version ${version}";
        template = template.replace("${exec}", Objects.requireNonNull(this.getExecutable()));
        template = template.replace("${solution}", acc.solutionFile.toString());
        template = template.replace("${recipeId}", Objects.requireNonNull(this.getRecipeId()));
        template = template.replace("${package}", Objects.requireNonNull(this.getNugetPackageName()));
        template = template.replace("${version}", Objects.requireNonNull(this.getNugetPackageVersion()));
        String[] stringArray = template.split(" ");
        int n = stringArray.length;
        for (int n2 = 0; n2 < n; part = part.trim(), ++n2) {
            part = stringArray[n2];
            command.add(part);
        }
        Path out = null;
        Path err = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(command);
            builder.directory(dir.toFile());
            builder.environment().put("TERM", "dumb");
            env.forEach(builder.environment()::put);
            out = Files.createTempFile(WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory(), "node", null, new FileAttribute[0]);
            err = Files.createTempFile(WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx).getWorkingDirectory(), "node", null, new FileAttribute[0]);
            builder.redirectOutput(ProcessBuilder.Redirect.to(out.toFile()));
            builder.redirectError(ProcessBuilder.Redirect.to(err.toFile()));
            Process process = builder.start();
            if (!process.waitFor(5L, TimeUnit.MINUTES)) {
                throw new RuntimeException(String.format("Command '%s' timed out after 5 minutes", String.join((CharSequence)" ", command)));
            }
            if (process.exitValue() != 0) {
                String error = "Command failed: " + String.join((CharSequence)" ", command);
                if (Files.exists(err, new LinkOption[0])) {
                    error = error + "\n" + new String(Files.readAllBytes(err));
                }
                error = error + "\nCommand:" + template;
                throw new RuntimeException(error);
            }
            for (Map.Entry<Path, Long> entry : acc.beforeModificationTimestamps.entrySet()) {
                Path path = entry.getKey();
                if (Files.exists(path, new LinkOption[0]) && Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() <= entry.getValue()) continue;
                acc.modified(path);
            }
            this.processOutput(out, acc, ctx);
            if (out != null) {
                content = new String(Files.readAllBytes(out));
                System.out.println(content);
                out.toFile().delete();
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                String content2;
                if (out != null) {
                    content2 = new String(Files.readAllBytes(out));
                    System.out.println(content2);
                    out.toFile().delete();
                }
                if (err == null) throw throwable;
                content2 = new String(Files.readAllBytes(err));
                System.out.println(content2);
                err.toFile().delete();
                throw throwable;
            }
        }
        if (err == null) return;
        content = new String(Files.readAllBytes(err));
        System.out.println(content);
        err.toFile().delete();
        return;
    }

    protected Map<String, String> getCommandEnvironment(Accumulator acc, ExecutionContext ctx) {
        return new HashMap<String, String>();
    }

    protected void processOutput(Path out, Accumulator acc, ExecutionContext ctx) {
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    return RoslynRecipe.this.createAfter(sourceFile, acc, ctx);
                }
                return tree;
            }
        };
    }

    protected SourceFile createAfter(SourceFile before, Accumulator acc, ExecutionContext ctx) {
        if (!acc.wasModified(before)) {
            return before;
        }
        return new PlainText(before.getId(), before.getSourcePath(), before.getMarkers(), before.getCharset() != null ? before.getCharset().name() : null, before.isCharsetBomMarked(), before.getFileAttributes(), null, acc.content(before), Collections.emptyList());
    }

    protected static Path createDirectory(ExecutionContext ctx, String prefix) {
        WorkingDirectoryExecutionContextView view = WorkingDirectoryExecutionContextView.view((ExecutionContext)ctx);
        return Optional.of(view.getWorkingDirectory()).map(d -> d.resolve(prefix)).map(d -> {
            try {
                return Files.createDirectory(d, new FileAttribute[0]).toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).orElseThrow(() -> new IllegalStateException("Failed to create working directory for " + prefix));
    }

    public static class Accumulator {
        final Path directory;
        Path solutionFile;
        final Map<Path, Long> beforeModificationTimestamps = new HashMap<Path, Long>();
        final Set<Path> modified = new LinkedHashSet<Path>();
        final Map<String, AtomicInteger> extensionCounts = new HashMap<String, AtomicInteger>();
        final Map<String, Object> data = new HashMap<String, Object>();

        public void copyFromPrevious(final Path previous) {
            try {
                Files.walkFileTree(previous, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path target = directory.resolve(previous.relativize(dir));
                        if (!target.equals(directory)) {
                            Files.createDirectory(target, new FileAttribute[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            Path target = directory.resolve(previous.relativize(file));
                            Files.copy(file, target, new CopyOption[0]);
                            beforeModificationTimestamps.put(target, Files.getLastModifiedTime(target, new LinkOption[0]).toMillis());
                        }
                        catch (NoSuchFileException noSuchFileException) {
                            // empty catch block
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public String parser() {
            if (this.extensionCounts.containsKey("tsx")) {
                return "tsx";
            }
            if (this.extensionCounts.containsKey("ts")) {
                return "ts";
            }
            return "babel";
        }

        public void writeSource(SourceFile tree) {
            try {
                Path path = this.resolvedPath(tree);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                PrintOutputCapture.MarkerPrinter markerPrinter = new PrintOutputCapture.MarkerPrinter(){};
                Path written = Files.write(path, tree.printAll(new PrintOutputCapture((Object)0, markerPrinter)).getBytes(tree.getCharset() != null ? tree.getCharset() : StandardCharsets.UTF_8), new OpenOption[0]);
                this.beforeModificationTimestamps.put(written, Files.getLastModifiedTime(written, new LinkOption[0]).toMillis());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void modified(Path path) {
            this.modified.add(path);
        }

        public boolean wasModified(SourceFile tree) {
            return this.modified.contains(this.resolvedPath(tree));
        }

        public String content(SourceFile tree) {
            try {
                Path path = this.resolvedPath(tree);
                return tree.getCharset() != null ? new String(Files.readAllBytes(path), tree.getCharset()) : new String(Files.readAllBytes(path));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Path resolvedPath(SourceFile tree) {
            return this.directory.resolve(tree.getSourcePath());
        }

        public <T> void putData(String key, T value) {
            this.data.put(key, value);
        }

        public <T> @Nullable T getData(String key) {
            return (T)this.data.get(key);
        }

        @Generated
        public String toString() {
            return "RoslynRecipe.Accumulator(directory=" + this.getDirectory() + ", solutionFile=" + this.getSolutionFile() + ", beforeModificationTimestamps=" + this.beforeModificationTimestamps + ", modified=" + this.modified + ", extensionCounts=" + this.extensionCounts + ", data=" + this.data + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Path this$directory = this.getDirectory();
            Path other$directory = other.getDirectory();
            if (this$directory == null ? other$directory != null : !((Object)this$directory).equals(other$directory)) {
                return false;
            }
            Path this$solutionFile = this.getSolutionFile();
            Path other$solutionFile = other.getSolutionFile();
            if (this$solutionFile == null ? other$solutionFile != null : !((Object)this$solutionFile).equals(other$solutionFile)) {
                return false;
            }
            Map<Path, Long> this$beforeModificationTimestamps = this.beforeModificationTimestamps;
            Map<Path, Long> other$beforeModificationTimestamps = other.beforeModificationTimestamps;
            if (this$beforeModificationTimestamps == null ? other$beforeModificationTimestamps != null : !((Object)this$beforeModificationTimestamps).equals(other$beforeModificationTimestamps)) {
                return false;
            }
            Set<Path> this$modified = this.modified;
            Set<Path> other$modified = other.modified;
            if (this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified)) {
                return false;
            }
            Map<String, AtomicInteger> this$extensionCounts = this.extensionCounts;
            Map<String, AtomicInteger> other$extensionCounts = other.extensionCounts;
            if (this$extensionCounts == null ? other$extensionCounts != null : !((Object)this$extensionCounts).equals(other$extensionCounts)) {
                return false;
            }
            Map<String, Object> this$data = this.data;
            Map<String, Object> other$data = other.data;
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $directory = this.getDirectory();
            result = result * 59 + ($directory == null ? 43 : ((Object)$directory).hashCode());
            Path $solutionFile = this.getSolutionFile();
            result = result * 59 + ($solutionFile == null ? 43 : ((Object)$solutionFile).hashCode());
            Map<Path, Long> $beforeModificationTimestamps = this.beforeModificationTimestamps;
            result = result * 59 + ($beforeModificationTimestamps == null ? 43 : ((Object)$beforeModificationTimestamps).hashCode());
            Set<Path> $modified = this.modified;
            result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
            Map<String, AtomicInteger> $extensionCounts = this.extensionCounts;
            result = result * 59 + ($extensionCounts == null ? 43 : ((Object)$extensionCounts).hashCode());
            Map<String, Object> $data = this.data;
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        @Generated
        public Accumulator(Path directory) {
            this.directory = directory;
        }

        @Generated
        public Path getDirectory() {
            return this.directory;
        }

        @Generated
        public Path getSolutionFile() {
            return this.solutionFile;
        }
    }
}

