/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit6;

import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.J;

public class RemoveInterceptDynamicTest
extends Recipe {
    private static final MethodMatcher INTERCEPT_DYNAMIC_TEST_MATCHER = new MethodMatcher("org.junit.jupiter.api.extension.InvocationInterceptor interceptDynamicTest(..)", true);

    public String getDisplayName() {
        return "Remove `InvocationInterceptor.interceptDynamicTest`";
    }

    public String getDescription() {
        return "JUnit 6 removed the `interceptDynamicTest(Invocation, ExtensionContext)` method from `InvocationInterceptor`. This recipe removes implementations of this deprecated method.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new DeclaresMethod(INTERCEPT_DYNAMIC_TEST_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                if (INTERCEPT_DYNAMIC_TEST_MATCHER.matches(md.getMethodType())) {
                    return null;
                }
                return md;
            }
        });
    }
}

