/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class SimplifyHasSizeAssertion
extends Recipe {
    private static final MethodMatcher HAS_SIZE_MATCHER = new MethodMatcher("org.assertj.core.api.* hasSize(int)");
    private static final MethodMatcher CHAR_SEQUENCE_LENGTH_MATCHER = new MethodMatcher("java.lang.CharSequence length()", true);
    private static final MethodMatcher ITERABLE_SIZE_MATCHER = new MethodMatcher("java.lang.Iterable size()", true);
    private static final MethodMatcher MAP_SIZE_MATCHER = new MethodMatcher("java.util.Map size()", true);
    private static final String HAS_SAME_SIZE_AS = "hasSameSizeAs";

    public String getDisplayName() {
        return "Simplify AssertJ assertions with `hasSize` argument";
    }

    public String getDescription() {
        return "Simplify AssertJ assertions by replacing `hasSize` with `hasSameSizeAs` dedicated assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(HAS_SIZE_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Expression target;
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!HAS_SIZE_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                Expression expression = (Expression)mi.getArguments().get(0);
                if (expression instanceof J.MethodInvocation) {
                    if (CHAR_SEQUENCE_LENGTH_MATCHER.matches(expression) || ITERABLE_SIZE_MATCHER.matches(expression) || MAP_SIZE_MATCHER.matches(expression)) {
                        return this.updateMethodInvocation(mi, ((J.MethodInvocation)expression).getSelect());
                    }
                } else if (expression instanceof J.FieldAccess && (target = ((J.FieldAccess)expression).getTarget()).getType() instanceof JavaType.Array) {
                    return this.updateMethodInvocation(mi, target);
                }
                return mi;
            }

            private J.MethodInvocation updateMethodInvocation(J.MethodInvocation mi, Expression argument) {
                return mi.withMethodType(mi.getMethodType().withName(SimplifyHasSizeAssertion.HAS_SAME_SIZE_AS)).withName(mi.getName().withSimpleName(SimplifyHasSizeAssertion.HAS_SAME_SIZE_AS)).withArguments(Collections.singletonList(argument));
            }
        });
    }
}

