/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class SimplifyAssertJAssertion
extends Recipe {
    private static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.assertj.core.api.Assertions assertThat(..)");
    @Option(displayName="AssertJ assertion", description="The assertion method that should be replaced.", example="hasSize", required=false)
    @Nullable String assertToReplace;
    @Option(displayName="Assertion argument literal", description="The literal argument passed into the assertion to replace; use \"null\" for `null`.", example="0")
    String literalArgument;
    @Option(displayName="Dedicated assertion", description="The zero argument assertion to adopt instead.", example="isEmpty")
    String dedicatedAssertion;
    @Option(displayName="Required type", description="The type of the actual assertion argument.", example="java.lang.String")
    String requiredType;

    public String getDisplayName() {
        return "Simplify AssertJ assertions with literal arguments";
    }

    public String getDescription() {
        return "Simplify AssertJ assertions by replacing them with more expressiove dedicated assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher assertToReplace = new MethodMatcher("org.assertj.core.api.* " + this.assertToReplace + "(..)");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!assertToReplace.matches((MethodCall)mi) || !ASSERT_THAT_MATCHER.matches(mi.getSelect())) {
                    return mi;
                }
                if (!(mi.getArguments().get(0) instanceof J.Literal) || !SimplifyAssertJAssertion.this.literalArgument.equals(((J.Literal)mi.getArguments().get(0)).getValueSource())) {
                    return mi;
                }
                if (!TypeUtils.isAssignableTo((String)SimplifyAssertJAssertion.this.requiredType, (JavaType)((Expression)((J.MethodInvocation)mi.getSelect()).getArguments().get(0)).getType())) {
                    return mi;
                }
                return (J.MethodInvocation)JavaTemplate.builder((String)("#{any()}." + SimplifyAssertJAssertion.this.dedicatedAssertion + "()")).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
            }
        };
    }

    @ConstructorProperties(value={"assertToReplace", "literalArgument", "dedicatedAssertion", "requiredType"})
    @Generated
    public SimplifyAssertJAssertion(@Nullable String assertToReplace, String literalArgument, String dedicatedAssertion, String requiredType) {
        this.assertToReplace = assertToReplace;
        this.literalArgument = literalArgument;
        this.dedicatedAssertion = dedicatedAssertion;
        this.requiredType = requiredType;
    }

    @Generated
    public SimplifyAssertJAssertion() {
    }
}

