/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql.table;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class DatabaseColumnsUsed
extends DataTable<Row> {
    public DatabaseColumnsUsed(Recipe recipe) {
        super(recipe, "Database columns used", "Shows which database columns are read/written by a SQL statement.");
    }

    public static enum Operation {
        SELECT,
        UPDATE,
        INSERT,
        DELETE;

    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file.")
        private final String sourcePath;
        @Column(displayName="Line number", description="The line number the SQL operation appears at")
        private final int lineNumber;
        @Column(displayName="Commit hash", description="The commit hash. Used to generate a link to the source code.")
        private final @Nullable String getCommitHash;
        @Column(displayName="Operation", description="Whether the column is read, written, etc.")
        private final Operation operation;
        @Column(displayName="Table", description="The table name.")
        private final String table;
        @Column(displayName="Column", description="The column name. In the case of a DELETE, column will be null.")
        private final @Nullable String column;

        @Generated
        public Row(String sourcePath, int lineNumber, @Nullable String getCommitHash, Operation operation, String table, @Nullable String column) {
            this.sourcePath = sourcePath;
            this.lineNumber = lineNumber;
            this.getCommitHash = getCommitHash;
            this.operation = operation;
            this.table = table;
            this.column = column;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Generated
        public @Nullable String getGetCommitHash() {
            return this.getCommitHash;
        }

        @Generated
        public Operation getOperation() {
            return this.operation;
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Generated
        public @Nullable String getColumn() {
            return this.column;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getLineNumber() != other.getLineNumber()) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$getCommitHash = this.getGetCommitHash();
            String other$getCommitHash = other.getGetCommitHash();
            if (this$getCommitHash == null ? other$getCommitHash != null : !this$getCommitHash.equals(other$getCommitHash)) {
                return false;
            }
            Operation this$operation = this.getOperation();
            Operation other$operation = other.getOperation();
            if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            return !(this$column == null ? other$column != null : !this$column.equals(other$column));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLineNumber();
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $getCommitHash = this.getGetCommitHash();
            result = result * 59 + ($getCommitHash == null ? 43 : $getCommitHash.hashCode());
            Operation $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DatabaseColumnsUsed.Row(sourcePath=" + this.getSourcePath() + ", lineNumber=" + this.getLineNumber() + ", getCommitHash=" + this.getGetCommitHash() + ", operation=" + (Object)((Object)this.getOperation()) + ", table=" + this.getTable() + ", column=" + this.getColumn() + ")";
        }
    }
}

