/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import java.net.URI;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.constantfold.ConstantFold;
import org.openrewrite.analysis.util.CursorUtil;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class URLConstructorToURICreate
extends Recipe {
    private static final String URI_FQN = "java.net.URI";
    private static final String URL_FQN = "java.net.URL";
    private static final MethodMatcher methodMatcherSingleArg = new MethodMatcher("java.net.URL#<init>(java.lang.String)");
    final String displayName = "Convert `new URL(String)` to `URI.create(String).toURL()`";
    final String description = "Converts `new URL(String)` constructor to `URI.create(String).toURL()`. The URL constructor has been deprecated due to security vulnerabilities when handling malformed URLs. Using `URI.create(String)` provides stronger validation and safer URL handling in modern Java applications.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(URL_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass nc, ExecutionContext ctx) {
                if (methodMatcherSingleArg.matches((MethodCall)nc)) {
                    String path = this.extractPath((Expression)nc.getArguments().get(0));
                    if (this.isNotValidPath(path)) {
                        return nc;
                    }
                    this.maybeRemoveImport(URLConstructorToURICreate.URL_FQN);
                    this.maybeAddImport(URLConstructorToURICreate.URI_FQN);
                    return JavaTemplate.builder((String)"URI.create(#{any(String)}).toURL()").imports(new String[]{URLConstructorToURICreate.URI_FQN}).javaParser(JavaParser.fromJavaVersion()).build().apply(this.getCursor(), nc.getCoordinates().replace(), new Object[]{nc.getArguments().get(0)});
                }
                return super.visitNewClass(nc, (Object)ctx);
            }

            private @Nullable String extractPath(Expression arg) {
                if (arg instanceof J.Literal && TypeUtils.isOfType((JavaType)arg.getType(), (JavaType)JavaType.Primitive.String)) {
                    String literalValueSource = ((J.Literal)arg).getValueSource();
                    return literalValueSource != null ? literalValueSource.substring(1, literalValueSource.length() - 1).trim() : null;
                }
                if (arg instanceof J.Identifier && TypeUtils.isOfType((JavaType)arg.getType(), (JavaType)JavaType.Primitive.String)) {
                    try {
                        return (String)CursorUtil.findCursorForTree((Cursor)this.getCursor(), (Tree)arg).bind(c -> ConstantFold.findConstantLiteralValue((Cursor)c, String.class)).toNull();
                    }
                    catch (RecipeRunException e) {
                        return null;
                    }
                }
                return null;
            }

            private boolean isNotValidPath(@Nullable String path) {
                if (path == null) {
                    return true;
                }
                try {
                    URI.create(path).toURL();
                    return false;
                }
                catch (Exception e) {
                    return true;
                }
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

