/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.logging;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateLoggerGlobalToGetGlobal
extends Recipe {
    final String displayName = "Use `Logger#getGlobal()`";
    final String description = "The preferred way to get the global logger object is via the call `Logger#getGlobal()` over direct field access to `java.util.logging.Logger.global`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.util.logging.Logger", Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                J.FieldAccess fa = (J.FieldAccess)super.visitFieldAccess(fieldAccess, (Object)ctx);
                if (TypeUtils.isOfClassType((JavaType)fa.getTarget().getType(), (String)"java.util.logging.Logger") && "global".equals(fa.getSimpleName())) {
                    return JavaTemplate.builder((String)"Logger.getGlobal();").imports(new String[]{"java.util.logging.Logger"}).build().apply(this.updateCursor((Tree)fa), fa.getCoordinates().replace(), new Object[0]);
                }
                return fa;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

