/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.guava.PreferJavaStringJoinVisitor;
import org.openrewrite.java.search.UsesMethod;

public class PreferJavaStringJoin
extends Recipe {
    static final MethodMatcher JOIN_METHOD_MATCHER = new MethodMatcher("com.google.common.base.Joiner join(..)");
    final String displayName = "Prefer `String#join()` over Guava `Joiner#join()`";
    final String description = "Replaces supported calls to `com.google.common.base.Joiner#join()` with `java.lang.String#join()`.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(JOIN_METHOD_MATCHER), (TreeVisitor)new PreferJavaStringJoinVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

