/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.UpdateJavaCompatibility;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.migrate.UpdateSdkMan;
import org.openrewrite.java.migrate.UpgradeDockerImageVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.UpdateMavenProjectPropertyJavaVersion;
import org.openrewrite.maven.UseMavenCompilerPluginReleaseConfiguration;

public final class UpgradeJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;
    private final String displayName = "Upgrade Java version";
    private final String description = "Upgrade build plugin configuration to use the specified Java version. This recipe changes `java.toolchain.languageVersion` in `build.gradle(.kts)` of gradle projects, or maven-compiler-plugin target version and related settings. Will not downgrade if the version is newer than the specified version.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(0L);

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new UseMavenCompilerPluginReleaseConfiguration(this.version), new UpdateMavenProjectPropertyJavaVersion(this.version), new org.openrewrite.jenkins.UpgradeJavaVersion(this.version, null), new UpdateJavaCompatibility(this.version, null, null, Boolean.valueOf(false), null), new UpdateSdkMan(String.valueOf(this.version), null), new UpgradeDockerImageVersion(this.version)});
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String newVersion = this.version.toString();
        final HashMap updatedMarkers = new HashMap();
        return new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(J tree, ExecutionContext ctx) {
                Optional maybeJavaVersion = tree.getMarkers().findFirst(JavaVersion.class);
                if (maybeJavaVersion.isPresent() && ((JavaVersion)maybeJavaVersion.get()).getMajorVersion() < UpgradeJavaVersion.this.version) {
                    return (J)tree.withMarkers(tree.getMarkers().setByType((Marker)updatedMarkers.computeIfAbsent((JavaVersion)maybeJavaVersion.get(), m -> m.withSourceCompatibility(newVersion).withTargetCompatibility(newVersion))));
                }
                return tree;
            }
        };
    }

    @ConstructorProperties(value={"version"})
    @Generated
    public UpgradeJavaVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeJavaVersion(version=" + this.getVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeJavaVersion)) {
            return false;
        }
        UpgradeJavaVersion other = (UpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeJavaVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }
}

