/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.VariableReferences;

public final class ReplaceUnusedVariablesWithUnderscore
extends Recipe {
    private static final String UNDERSCORE = "_";
    private final String displayName = "Replace unused variables with underscore";
    private final String description = "Replace unused variable declarations with underscore (_) for Java 22+. This includes unused variables in enhanced for loops, catch blocks, and lambda parameters where the variable is never referenced.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(22), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, ExecutionContext ctx) {
                J.ForEachLoop l = super.visitForEachLoop(forLoop, (Object)ctx);
                Statement variable = l.getControl().getVariable();
                if (variable instanceof J.VariableDeclarations) {
                    for (J.VariableDeclarations.NamedVariable namedVariable : ((J.VariableDeclarations)variable).getVariables()) {
                        this.renameVariableIfUnusedInContext(namedVariable, (J)l.getBody());
                    }
                }
                return l;
            }

            public J.Try.Catch visitCatch(J.Try.Catch _catch, ExecutionContext ctx) {
                J.Try.Catch c = super.visitCatch(_catch, (Object)ctx);
                for (J.VariableDeclarations.NamedVariable namedVariable : ((J.VariableDeclarations)c.getParameter().getTree()).getVariables()) {
                    this.renameVariableIfUnusedInContext(namedVariable, (J)c.getBody());
                }
                return c;
            }

            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
                J.Lambda l = super.visitLambda(lambda, (Object)ctx);
                for (J param : l.getParameters().getParameters()) {
                    if (!(param instanceof J.VariableDeclarations)) continue;
                    for (J.VariableDeclarations.NamedVariable namedVariable : ((J.VariableDeclarations)param).getVariables()) {
                        this.renameVariableIfUnusedInContext(namedVariable, l.getBody());
                    }
                }
                return l;
            }

            private void renameVariableIfUnusedInContext(J.VariableDeclarations.NamedVariable variable, J context) {
                if (!ReplaceUnusedVariablesWithUnderscore.UNDERSCORE.equals(variable.getName().getSimpleName()) && VariableReferences.findRhsReferences((J)context, (J.Identifier)variable.getName()).isEmpty() && !this.usedInModifyingUnary(variable.getName(), context)) {
                    this.doAfterVisit((TreeVisitor)new RenameVariable(variable, ReplaceUnusedVariablesWithUnderscore.UNDERSCORE));
                }
            }

            private boolean usedInModifyingUnary(final J.Identifier identifier, J context) {
                return ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

                    public J.Unary visitUnary(J.Unary unary, AtomicBoolean atomicBoolean) {
                        if (unary.getOperator().isModifying() && SemanticallyEqual.areEqual((J)identifier, (J)unary.getExpression())) {
                            atomicBoolean.set(true);
                        }
                        return super.visitUnary(unary, (Object)atomicBoolean);
                    }
                }.reduce((Tree)context, (Object)new AtomicBoolean(false))).get();
            }
        });
    }

    @Generated
    public ReplaceUnusedVariablesWithUnderscore() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceUnusedVariablesWithUnderscore(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceUnusedVariablesWithUnderscore)) {
            return false;
        }
        ReplaceUnusedVariablesWithUnderscore other = (ReplaceUnusedVariablesWithUnderscore)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceUnusedVariablesWithUnderscore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

