/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaSetsNewHashSet
extends Recipe {
    private static final MethodMatcher NEW_HASH_SET = new MethodMatcher("com.google.common.collect.Sets newHashSet(..)");
    final String displayName = "Prefer `new HashSet<>()`";
    final String description = "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(NEW_HASH_SET), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_HASH_SET.matches((MethodCall)method)) {
                    if (method.getArguments().isEmpty() || method.getArguments().get(0) instanceof J.Empty) {
                        this.maybeRemoveImport("com.google.common.collect.Sets");
                        this.maybeAddImport("java.util.HashSet");
                        return JavaTemplate.builder((String)"new HashSet<>()").contextSensitive().imports(new String[]{"java.util.HashSet"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                    }
                    if (method.getArguments().size() == 1) {
                        if (TypeUtils.isAssignableTo((String)"java.util.Collection", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                            this.maybeRemoveImport("com.google.common.collect.Sets");
                            this.maybeAddImport("java.util.HashSet");
                            return JavaTemplate.builder((String)"new HashSet<>(#{any(java.util.Collection)})").contextSensitive().imports(new String[]{"java.util.HashSet"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                        }
                        if (TypeUtils.isAssignableTo((String)"java.lang.Iterable", (JavaType)((Expression)method.getArguments().get(0)).getType()) || TypeUtils.isAssignableTo((String)"java.util.Iterator", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                            return method;
                        }
                    }
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.HashSet");
                    this.maybeAddImport("java.util.Arrays");
                    JavaTemplate newHashSetVarargs = JavaTemplate.builder((String)("new HashSet<>(Arrays.asList(" + method.getArguments().stream().map(a -> "#{any()}").collect(Collectors.joining(",")) + "))")).contextSensitive().imports(new String[]{"java.util.Arrays"}).imports(new String[]{"java.util.HashSet"}).build();
                    return newHashSetVarargs.apply(this.getCursor(), method.getCoordinates().replace(), method.getArguments().toArray());
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

