/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.docker.ChangeFrom;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class UpgradeDockerImageVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;
    private final String displayName = "Upgrade Docker image Java version";
    private final String description = "Upgrade Docker image tags to use the specified Java version. Updates common Java Docker images including eclipse-temurin, amazoncorretto, azul/zulu-openjdk, and others. Also migrates deprecated images (openjdk, adoptopenjdk) to eclipse-temurin.";

    public List<Recipe> getRecipeList() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.version == null) {
            return recipes;
        }
        String[] deprecatedImages = new String[]{"openjdk", "adoptopenjdk"};
        String[] currentImages = new String[]{"eclipse-temurin", "amazoncorretto", "azul/zulu-openjdk", "bellsoft/liberica-openjdk-debian", "bellsoft/liberica-openjdk-alpine", "bellsoft/liberica-openjdk-centos", "ibm-semeru-runtimes", "sapmachine"};
        String[] commonSuffixes = new String[]{"-jdk-alpine", "-jre-alpine", "-jdk-noble", "-jre-noble", "-jdk-jammy", "-jre-jammy", "-jdk-focal", "-jre-focal", "-jdk-bionic", "-jre-bionic", "-jdk-slim-bookworm", "-jre-slim-bookworm", "-jdk-slim-bullseye", "-jre-slim-bullseye", "-jdk-slim-buster", "-jre-slim-buster", "-jdk-bookworm", "-jre-bookworm", "-jdk-bullseye", "-jre-bullseye", "-jdk-buster", "-jre-buster", "-jdk-centos7", "-jre-centos7", "-jdk-ubi9-minimal", "-jre-ubi9-minimal", "-jdk-nanoserver", "-jre-nanoserver", "-jdk-windowsservercore", "-jre-windowsservercore", "-alpine", "-slim", "-jdk", "-jre"};
        for (int oldVersion = 8; oldVersion < this.version; ++oldVersion) {
            for (String image : deprecatedImages) {
                for (String suffix : commonSuffixes) {
                    recipes.add((Recipe)new ChangeFrom(image, oldVersion + suffix, null, null, "eclipse-temurin", this.version + suffix, null, null));
                }
            }
            for (String image : deprecatedImages) {
                recipes.add((Recipe)new ChangeFrom(image, oldVersion + "*", null, null, "eclipse-temurin", this.version.toString(), null, null));
            }
            for (String image : currentImages) {
                for (String suffix : commonSuffixes) {
                    recipes.add((Recipe)new ChangeFrom(image, oldVersion + suffix, null, null, null, this.version + suffix, null, null));
                }
            }
            for (String image : currentImages) {
                recipes.add((Recipe)new ChangeFrom(image, oldVersion + "*", null, null, null, this.version.toString(), null, null));
            }
        }
        return recipes;
    }

    @ConstructorProperties(value={"version"})
    @Generated
    public UpgradeDockerImageVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeDockerImageVersion(version=" + this.getVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDockerImageVersion)) {
            return false;
        }
        UpgradeDockerImageVersion other = (UpgradeDockerImageVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDockerImageVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

