/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.metrics;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class SimplifyMicrometerMeterTags
extends Recipe {
    private static final MethodMatcher COUNTER_TAGS = new MethodMatcher("io.micrometer.core.instrument.Counter.Builder tags(String[])");
    final String displayName = "Simplify [Micrometer](https://micrometer.io) meter tags";
    final String description = "Use the simplest method to add new tags.";
    final Set<String> tags = Collections.singleton("micrometer");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (COUNTER_TAGS.matches((MethodCall)m)) {
                    if (m.getArguments().get(0) instanceof J.NewArray) {
                        J.NewArray arr = (J.NewArray)m.getArguments().get(0);
                        if (arr.getInitializer() != null && arr.getInitializer().size() > 1) {
                            m = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(String)}, #{any(String)}").contextSensitive().build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), new Object[]{arr.getInitializer().get(0), arr.getInitializer().get(1)});
                        }
                    } else {
                        m = (J.MethodInvocation)JavaTemplate.builder((String)"#{any()}[0], #{any()}[1]").contextSensitive().build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0), m.getArguments().get(0)});
                    }
                    m = m.withName(m.getName().withSimpleName("tag"));
                }
                return m;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

