/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.migrate.lang.NullCheck;
import org.openrewrite.java.migrate.lang.SwitchUtils;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class NullCheckAsSwitchCase
extends Recipe {
    private final String displayName = "Add null check to existing switch cases";
    private final String description = "In later Java 21+, null checks are valid in switch cases. This recipe will only add null checks to existing switch cases if there are no other statements in between them or if the block in the if statement is not impacting the flow of the switch.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(3L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(21), Preconditions.not((TreeVisitor)new KotlinFileChecker()), Preconditions.not((TreeVisitor)new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitBlock(J.Block block, ExecutionContext ctx) {
                AtomicReference<@Nullable V> nullCheck = new AtomicReference();
                J.Block b = block.withStatements(ListUtils.map((List)block.getStatements(), (index, statement) -> {
                    Optional nullCheckOpt = NullCheck.Matcher.nullCheck().get((Tree)statement, this.getCursor());
                    if (nullCheckOpt.isPresent()) {
                        J nextStatement;
                        NullCheck check = (NullCheck)nullCheckOpt.get();
                        J j = nextStatement = index + 1 < block.getStatements().size() ? (J)block.getStatements().get(index + 1) : null;
                        if (!(nextStatement instanceof J.Switch) || check.returns() || check.couldModifyNullCheckedValue()) {
                            return statement;
                        }
                        J.Switch nextSwitch = (J.Switch)nextStatement;
                        if (this.hasNullCase(nextSwitch) || !SemanticallyEqual.areEqual((J)nextSwitch.getSelector().getTree(), (J)check.getNullCheckedParameter()) || !SwitchUtils.coversAllPossibleValues(nextSwitch)) {
                            return statement;
                        }
                        nullCheck.set(check);
                        return null;
                    }
                    NullCheck check = nullCheck.getAndSet(null);
                    if (check != null && statement instanceof J.Switch) {
                        J.Switch aSwitch = (J.Switch)statement;
                        J.Case nullCase = this.createNullCase(aSwitch, check.whenNull());
                        return aSwitch.withCases(aSwitch.getCases().withStatements(ListUtils.insert((List)aSwitch.getCases().getStatements(), (Object)nullCase, (int)0)));
                    }
                    return statement;
                }));
                return super.visitBlock(b, (Object)ctx);
            }

            private boolean hasNullCase(J.Switch switch_) {
                for (Statement c : switch_.getCases().getStatements()) {
                    if (!(c instanceof J.Case)) continue;
                    for (J j : ((J.Case)c).getCaseLabels()) {
                        if (!(j instanceof Expression) || !J.Literal.isLiteralValue((Expression)((Expression)j), null)) continue;
                        return true;
                    }
                }
                return false;
            }

            private J.Case createNullCase(J.Switch aSwitch, Statement whenNull) {
                J.Case currentFirstCase;
                J.Case case_ = currentFirstCase = aSwitch.getCases().getStatements().isEmpty() || !(aSwitch.getCases().getStatements().get(0) instanceof J.Case) ? null : (J.Case)aSwitch.getCases().getStatements().get(0);
                if (currentFirstCase == null || J.Case.Type.Rule == currentFirstCase.getType()) {
                    return this.createCaseRule(aSwitch, whenNull);
                }
                return this.createCaseStatement(aSwitch, whenNull, currentFirstCase);
            }

            private J.Case createCaseRule(J.Switch aSwitch, Statement whenNull) {
                Statement firstStatement;
                if (whenNull instanceof J.Block && ((J.Block)whenNull).getStatements().size() == 1 && ((firstStatement = (Statement)((J.Block)whenNull).getStatements().get(0)) instanceof Expression || firstStatement instanceof J.Throw)) {
                    whenNull = firstStatement;
                }
                String semicolon = whenNull instanceof J.Block ? "" : ";";
                J.Switch switchWithNullCase = (J.Switch)JavaTemplate.apply((String)("switch(#{any()}) { case null -> #{any()}" + semicolon + " }"), (Cursor)new Cursor(this.getCursor(), (Object)aSwitch), (JavaCoordinates)aSwitch.getCoordinates().replace(), (Object[])new Object[]{aSwitch.getSelector().getTree(), whenNull});
                J.Case nullCase = (J.Case)switchWithNullCase.getCases().getStatements().get(0);
                return nullCase.withBody(Objects.requireNonNull(nullCase.getBody()).withPrefix(Space.SINGLE_SPACE));
            }

            private J.Case createCaseStatement(J.Switch aSwitch, Statement whenNull, J.Case currentFirstCase) {
                ArrayList<Object> statements = new ArrayList<Object>();
                statements.add(aSwitch.getSelector().getTree());
                if (whenNull instanceof J.Block) {
                    statements.addAll(((J.Block)whenNull).getStatements());
                } else {
                    statements.add(whenNull);
                }
                Statement lastStatement = null;
                if (whenNull instanceof J.Block) {
                    List blockStatements = ((J.Block)whenNull).getStatements();
                    if (!blockStatements.isEmpty()) {
                        lastStatement = (Statement)blockStatements.get(blockStatements.size() - 1);
                    }
                } else {
                    lastStatement = whenNull;
                }
                StringBuilder template = new StringBuilder("switch(#{any()}) {\ncase null:");
                for (int i = 1; i < statements.size(); ++i) {
                    template.append("\n#{any()};");
                }
                if (!(lastStatement instanceof J.Throw)) {
                    template.append("\nbreak;");
                }
                template.append("\n}");
                J.Switch switchWithNullCase = (J.Switch)JavaTemplate.apply((String)template.toString(), (Cursor)new Cursor(this.getCursor(), (Object)aSwitch), (JavaCoordinates)aSwitch.getCoordinates().replace(), (Object[])statements.toArray());
                J.Case nullCase = (J.Case)switchWithNullCase.getCases().getStatements().get(0);
                Space currentFirstCaseIndentation = currentFirstCase.getStatements().stream().map(J::getPrefix).findFirst().orElse(Space.SINGLE_SPACE);
                return nullCase.withStatements(ListUtils.mapFirst((List)nullCase.getStatements(), s -> s == null ? null : (Statement)s.withPrefix(currentFirstCaseIndentation)));
            }
        });
    }

    @Generated
    public NullCheckAsSwitchCase() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @NonNull
    @Generated
    public String toString() {
        return "NullCheckAsSwitchCase(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NullCheckAsSwitchCase)) {
            return false;
        }
        NullCheckAsSwitchCase other = (NullCheckAsSwitchCase)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof NullCheckAsSwitchCase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }
}

