/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaSetsFilter
extends Recipe {
    private static final MethodMatcher SETS_FILTER = new MethodMatcher("com.google.common.collect.Sets filter(java.util.Set, com.google.common.base.Predicate)");
    private static final MethodMatcher SETS_FILTER_SORTED_SET = new MethodMatcher("com.google.common.collect.Sets filter(java.util.SortedSet, com.google.common.base.Predicate)");
    final String displayName = "Prefer `Collection.stream().filter(Predicate)`";
    final String description = "Prefer `Collection.stream().filter(Predicate)` over `Sets.filter(Set, Predicate)`.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor precondition = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(SETS_FILTER), new UsesMethod(SETS_FILTER_SORTED_SET)});
        return Preconditions.check((TreeVisitor)precondition, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (SETS_FILTER_SORTED_SET.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Predicate");
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.TreeSet");
                    this.maybeAddImport("java.util.function.Predicate");
                    this.maybeAddImport("java.util.stream.Collectors");
                    return JavaTemplate.builder((String)"#{any(java.util.Collection)}.stream().filter(#{any(java.util.function.Predicate)}).collect(Collectors.toCollection(TreeSet::new))").imports(new String[]{"java.util.TreeSet"}).imports(new String[]{"java.util.stream.Collectors"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0), method.getArguments().get(1)});
                }
                if (SETS_FILTER.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Predicate");
                    this.maybeRemoveImport("com.google.common.collect.Sets");
                    this.maybeAddImport("java.util.TreeSet");
                    this.maybeAddImport("java.util.function.Predicate");
                    this.maybeAddImport("java.util.stream.Collectors");
                    return JavaTemplate.builder((String)"#{any(java.util.Collection)}.stream().filter(#{any(java.util.function.Predicate)}).collect(Collectors.toSet())").imports(new String[]{"java.util.stream.Collectors"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0), method.getArguments().get(1)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

