/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class RemoveFinalizerFromZip
extends Recipe {
    private static final String JAVA_UTIL_ZIP_DEFLATER = "java.util.zip.Deflater";
    private static final String JAVA_UTIL_ZIP_INFLATER = "java.util.zip.Inflater";
    private static final String JAVA_UTIL_ZIP_ZIP_FILE = "java.util.zip.ZipFile";
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.lang.Object finalize()");

    public String getDisplayName() {
        return "Remove invocations of deprecated invocations from Deflater, Inflater, ZipFile ";
    }

    public String getDescription() {
        return "Remove invocations of finalize() deprecated invocations from Deflater, Inflater, ZipFile.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(12), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(JAVA_UTIL_ZIP_DEFLATER, Boolean.valueOf(false)), new UsesType(JAVA_UTIL_ZIP_INFLATER, Boolean.valueOf(false)), new UsesType(JAVA_UTIL_ZIP_ZIP_FILE, Boolean.valueOf(false))})}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (METHOD_MATCHER.matches((MethodCall)mi)) {
                    Expression select = mi.getSelect();
                    if (select == null) {
                        J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
                        if (this.shouldRemoveFinalize((JavaType)cd.getType())) {
                            return null;
                        }
                    } else if (this.shouldRemoveFinalize(select.getType())) {
                        List sideEffects = select.getSideEffects();
                        if (sideEffects.isEmpty()) {
                            return null;
                        }
                        if (sideEffects.size() == 1) {
                            return ((J)sideEffects.get(0)).withPrefix(mi.getPrefix());
                        }
                    }
                }
                return mi;
            }

            private boolean shouldRemoveFinalize(JavaType type) {
                return TypeUtils.isAssignableTo((String)RemoveFinalizerFromZip.JAVA_UTIL_ZIP_DEFLATER, (JavaType)type) || TypeUtils.isAssignableTo((String)RemoveFinalizerFromZip.JAVA_UTIL_ZIP_INFLATER, (JavaType)type) || TypeUtils.isAssignableTo((String)RemoveFinalizerFromZip.JAVA_UTIL_ZIP_ZIP_FILE, (JavaType)type);
            }
        });
    }

    @Generated
    public RemoveFinalizerFromZip() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveFinalizerFromZip()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveFinalizerFromZip)) {
            return false;
        }
        RemoveFinalizerFromZip other = (RemoveFinalizerFromZip)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveFinalizerFromZip;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

