/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.J;

public final class UpdateManagedBeanToNamed
extends Recipe {
    private static final AnnotationMatcher MANAGED_BEAN_MATCHER = new AnnotationMatcher("*.faces.bean.ManagedBean");

    public String getDisplayName() {
        return "Update Faces `@ManagedBean` to use CDI `@Named`";
    }

    public String getDescription() {
        return "Faces ManagedBean was deprecated in JSF 2.3 (EE8) and removed in Jakarta Faces 4.0 (EE10). Replace `@ManagedBean` with `@Named` for CDI-based bean management.";
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("jakarta", "faces", "jsf"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Preconditions.Check((TreeVisitor)new UsesType("*.faces.bean.ManagedBean", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                Optional annotated = new Annotated.Matcher(MANAGED_BEAN_MATCHER).get(this.getCursor());
                if (annotated.isPresent()) {
                    this.maybeRemoveImport("javax.faces.bean.ManagedBean");
                    this.maybeRemoveImport("jakarta.faces.bean.ManagedBean");
                    this.maybeAddImport("jakarta.inject.Named");
                    String beanName = annotated.flatMap(a -> a.getDefaultAttribute("name")).map(name -> (String)name.getValue(String.class)).orElse(null);
                    if (beanName != null) {
                        return (J.Annotation)JavaTemplate.builder((String)"@Named(\"#{}\")").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.inject-api-2.0.1"})).imports(new String[]{"jakarta.inject.Named"}).build().apply(this.getCursor(), annotation.getCoordinates().replace(), new Object[]{beanName});
                    }
                    return (J.Annotation)JavaTemplate.builder((String)"@Named").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.inject-api-2.0.1"})).imports(new String[]{"jakarta.inject.Named"}).build().apply(this.getCursor(), annotation.getCoordinates().replace(), new Object[0]);
                }
                return annotation;
            }
        });
    }

    @Generated
    public UpdateManagedBeanToNamed() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateManagedBeanToNamed()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateManagedBeanToNamed)) {
            return false;
        }
        UpdateManagedBeanToNamed other = (UpdateManagedBeanToNamed)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateManagedBeanToNamed;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

