/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.Style;

public final class UseTabsOrSpaces
extends Recipe {
    @Option(displayName="Use tabs", description="Whether to use tabs for indentation.")
    private final boolean useTabs;

    public String getDisplayName() {
        return "Force indentation to either tabs or spaces";
    }

    public String getDescription() {
        return "This is useful for one-off migrations of a codebase that has mixed indentation styles, while preserving all other auto-detected formatting rules.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    TabsAndIndentsStyle style = ((TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)cu, IntelliJ::tabsAndIndents)).withUseTabCharacter(Boolean.valueOf(UseTabsOrSpaces.this.useTabs));
                    return new NormalizeTabsOrSpacesVisitor(style).visit(tree, (Object)ctx);
                }
                return (J)tree;
            }
        };
    }

    @ConstructorProperties(value={"useTabs"})
    @Generated
    public UseTabsOrSpaces(boolean useTabs) {
        this.useTabs = useTabs;
    }

    @Generated
    public boolean isUseTabs() {
        return this.useTabs;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseTabsOrSpaces(useTabs=" + this.isUseTabs() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseTabsOrSpaces)) {
            return false;
        }
        UseTabsOrSpaces other = (UseTabsOrSpaces)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isUseTabs() == other.isUseTabs();
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseTabsOrSpaces;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseTabs() ? 79 : 97);
        return result;
    }
}

