/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;

public final class AddTableGenerator
extends Recipe {
    public String getDisplayName() {
        return "Attributes with automatically generated values require configuration";
    }

    public String getDescription() {
        return "Adds missing `@TableGenerator` annotation and updates the `@GeneratedValue` annotation values when it uses automatically generated values.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("javax.persistence.GeneratedValue", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final AnnotationMatcher GENERATED_VALUE = new AnnotationMatcher("@javax.persistence.GeneratedValue");
            private final AnnotationMatcher GENERATED_VALUE_AUTO = new AnnotationMatcher("@javax.persistence.GeneratedValue(strategy=javax.persistence.GenerationType.AUTO)");

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                Set generatedValueAnnotations = FindAnnotations.find((J)multiVariable, (String)"@javax.persistence.GeneratedValue");
                if (generatedValueAnnotations.isEmpty()) {
                    return multiVariable;
                }
                J.Annotation generatedValueAnnotation = (J.Annotation)generatedValueAnnotations.iterator().next();
                List args = generatedValueAnnotation.getArguments();
                if (args != null && !args.isEmpty() && !this.GENERATED_VALUE_AUTO.matches(generatedValueAnnotation)) {
                    return multiVariable;
                }
                J.VariableDeclarations updatedVariable = (J.VariableDeclarations)JavaTemplate.apply((String)"@javax.persistence.TableGenerator(name = \"OPENJPA_SEQUENCE_TABLE\", table = \"OPENJPA_SEQUENCE_TABLE\", pkColumnName = \"ID\", valueColumnName = \"SEQUENCE_VALUE\", pkColumnValue = \"0\")", (Cursor)this.getCursor(), (JavaCoordinates)multiVariable.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), (Object[])new Object[0]);
                return super.visitVariableDeclarations(updatedVariable, (Object)ctx);
            }

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                if (!this.GENERATED_VALUE.matches(annotation) && !this.GENERATED_VALUE_AUTO.matches(annotation)) {
                    return annotation;
                }
                return (J.Annotation)JavaTemplate.builder((String)"strategy = javax.persistence.GenerationType.TABLE, generator = \"OPENJPA_SEQUENCE_TABLE\"").contextSensitive().build().apply(this.getCursor(), annotation.getCoordinates().replaceArguments(), new Object[0]);
            }
        });
    }

    @Generated
    public AddTableGenerator() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddTableGenerator()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTableGenerator)) {
            return false;
        }
        AddTableGenerator other = (AddTableGenerator)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddTableGenerator;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

