/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class SwitchExpressionYieldToArrow
extends Recipe {
    public String getDisplayName() {
        return "Convert switch expression yield to arrow";
    }

    public String getDescription() {
        return "Convert switch expressions with colon cases and yield statements to arrow syntax.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(14), Preconditions.not((TreeVisitor)new KotlinFileChecker()), Preconditions.not((TreeVisitor)new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.SwitchExpression visitSwitchExpression(J.SwitchExpression switchExpression, ExecutionContext ctx) {
                J.SwitchExpression se = super.visitSwitchExpression(switchExpression, (Object)ctx);
                if (this.anythingOtherThanYield(se)) {
                    return se;
                }
                return se.withCases(se.getCases().withStatements(ListUtils.map((List)se.getCases().getStatements(), statement -> {
                    J.Case caseStatement = (J.Case)Objects.requireNonNull(statement);
                    J.Yield yieldStatement = (J.Yield)caseStatement.getStatements().get(0);
                    JContainer caseLabels = caseStatement.getPadding().getCaseLabels();
                    JContainer updatedLabels = caseLabels.getPadding().withElements(ListUtils.mapLast((List)caseLabels.getPadding().getElements(), elem -> elem.withAfter(Space.SINGLE_SPACE)));
                    return caseStatement.withStatements(null).withBody(yieldStatement.getValue().withPrefix(Space.SINGLE_SPACE)).withType(J.Case.Type.Rule).getPadding().withCaseLabels(updatedLabels);
                })));
            }

            private boolean anythingOtherThanYield(J.SwitchExpression se) {
                for (Statement statement : se.getCases().getStatements()) {
                    if (!(statement instanceof J.Case)) {
                        return true;
                    }
                    J.Case caseStatement = (J.Case)statement;
                    if (caseStatement.getType() == J.Case.Type.Statement && caseStatement.getStatements().size() == 1 && caseStatement.getStatements().get(0) instanceof J.Yield) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Generated
    public SwitchExpressionYieldToArrow() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "SwitchExpressionYieldToArrow()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwitchExpressionYieldToArrow)) {
            return false;
        }
        SwitchExpressionYieldToArrow other = (SwitchExpressionYieldToArrow)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SwitchExpressionYieldToArrow;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

